package org.jresearch.commons.gwt.client.model.localization;

import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.google.inject.Singleton;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ModelKeyProvider;

@Singleton
public class L18nProvider implements ModelKeyProvider<LocaleModel>, LabelProvider<LocaleModel> {

	@Override
	public String getLabel(final LocaleModel item) {
		return item.getDisplayLanguage();
	}

	@Override
	public String getKey(final LocaleModel item) {
		return item.getLocaleName();
	}

}
