package org.jresearch.commons.gwt.client.model.localization;

import org.jresearch.commons.gwt.shared.model.localization.L18nSorter;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.SortDir;

@Singleton
public class L18nStore extends ListStore<LocaleModel> {

	private L18nSorter sorter;

	@Inject
	public L18nStore() {
		super(new L18nProvider());
		addSortInfo(new StoreSortInfo<>(sorter = new L18nSorter(), SortDir.ASC));
	}

	public void addTopLocale(LocaleModel item) {
		sorter.addTopLocale(item);
	}

}
