package org.jresearch.commons.gwt.client.service;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.loader.GxtLoadConfig;
import org.jresearch.commons.gwt.shared.loader.GxtLoadConfigBean;
import org.jresearch.commons.gwt.shared.loader.LoadConfig;
import org.jresearch.commons.gwt.shared.loader.LoadConfigBean;
import org.jresearch.commons.gwt.shared.service.IReadDomainServiceAsync;

/** Helper class to create data loader by remote service */
public class ServiceTools<M, S extends IReadDomainServiceAsync<LoadConfig, M>> extends CustomServiceTools<LoadConfig, GxtLoadConfig<LoadConfig>, M, S> {

	public ServiceTools(@Nonnull final S service) {
		super(service);
	}

	@Override
	protected GxtLoadConfig<LoadConfig> createLoadConfig() {
		final LoadConfig jrsConfig = new LoadConfigBean();
		return new GxtLoadConfigBean<>(jrsConfig);
	}

}
