package org.jresearch.commons.gwt.client.model.localization;

import org.jresearch.commons.gwt.client.resource.UtilsRs;
import org.jresearch.commons.gwt.shared.model.localization.L18nProperty;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;
import org.jresearch.commons.gwt.shared.model.localization.LocaleTool;

import com.sencha.gxt.core.client.ValueProvider;

public class L18nValueProvider<T> implements ValueProvider<T, String> {

    private LocaleModel locale;
    private final ValueProvider<T, L18nProperty> provider;

    public L18nValueProvider(final ValueProvider<T, L18nProperty> provider) {
        this.provider = provider;
        locale = LocaleTool.getCurrentLocale(true);
    }

    @Override
    public String getValue(final T object) {
        final L18nProperty property = provider.getValue(object);
        return UtilsRs.TXT.l18nAdminValue(LocaleTool.getRaw(property.getContainer(), locale), property.get(locale));
    }

    @Override
    public void setValue(final T object, final String value) {
        provider.getValue(object).set(locale, value);
    }

    @Override
    public String getPath() {
        return provider.getPath();
    }

    /**
     * @param locale
     *            the locale to set
     */
    public void setLocale(final LocaleModel locale) {
        this.locale = locale;
    }

}
