package org.jresearch.commons.gwt.client.widget;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.jresearch.commons.gwt.client.model.localization.L18nProvider;
import org.jresearch.commons.gwt.client.model.localization.L18nStore;
import org.jresearch.commons.gwt.client.resource.UtilsRs;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.inject.Inject;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.widget.core.client.form.ComboBox;

public class SimpleL18nComboBox extends ComboBox<LocaleModel> {

	private static Logger logger = Logger.getLogger("org.jresearch.commons.gwt.app.client.widget.L18nComboBox"); //$NON-NLS-1$

	@Inject
	public SimpleL18nComboBox(final L18nStore store, final L18nProvider provider) {
		super(store, provider);
		setForceSelection(true);
		setTriggerAction(TriggerAction.ALL);
		setEditable(false);
		addSelectionHandler(new SelectionHandler<LocaleModel>() {
			@Override
			public void onSelection(final SelectionEvent<LocaleModel> event) {
				final LocaleModel item = event.getSelectedItem();
				if (item != null) {
					logger.log(Level.FINE, UtilsRs.FMT.logSelection(item));
					store.addTopLocale(item);
					getStore().applySort(false);
				}
			}
		});
	}

}
