package org.jresearch.commons.gwt.client.mvc;

import javax.annotation.Nonnull;

import com.google.gwt.user.client.ui.HasWidgets;
import com.sencha.gxt.widget.core.client.Window;

public abstract class AbstractWindowsView extends AbstractView<AbstractController<AbstractWindowsView>> {

	private final Window window;

	public AbstractWindowsView(@Nonnull final AbstractController<AbstractWindowsView> controller) {
		super(controller);
		window = new Window();
	}

	// public void closeView(final TextButton button) {
	// window.hide(button);
	// }

	public void closeView() {
		window.hide();
	}

	@Override
	protected HasWidgets.ForIsWidget getParentContainer() {
		return window;
	}

	@Override
	public void showContent() {
		super.showContent();
		window.show();
	}

	/**
	 * @return the window
	 */
	public Window getWindow() {
		return window;
	}

}
