/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.apt.commons;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.dominokit.domino.apt.commons.BaseProcessor;
import org.dominokit.domino.apt.commons.ExceptionUtil;
import org.dominokit.domino.apt.commons.ProcessorUtil;

public abstract class AbstractProcessingStep
implements BaseProcessor.ProcessingStep {
    protected final Messager messager;
    protected final Filer filer;
    protected final Types types;
    protected final Elements elements;
    protected final ProcessingEnvironment processingEnv;
    protected final ProcessorUtil processorUtil;

    protected AbstractProcessingStep(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.processingEnv = processingEnv;
        this.processorUtil = new ProcessorUtil(processingEnv);
    }

    protected void writeSource(JavaFile sourceFile) {
        try {
            sourceFile.writeTo(this.filer);
        }
        catch (IOException e) {
            ExceptionUtil.messageStackTrace(this.messager, e);
        }
    }

    protected void tryWriteSource(JavaFile sourceFile) throws IOException {
        sourceFile.writeTo(this.filer);
    }

    protected void writeSource(List<TypeSpec.Builder> builders, String rootPackage) {
        builders.forEach(builder -> {
            JavaFile javaFile = JavaFile.builder((String)rootPackage, (TypeSpec)builder.build()).build();
            this.writeSource(javaFile);
        });
    }

    protected void tryWriteSources(List<TypeSpec.Builder> builders, String rootPackage) throws IOException {
        for (TypeSpec.Builder builder : builders) {
            JavaFile javaFile = JavaFile.builder((String)rootPackage, (TypeSpec)builder.build()).build();
            this.tryWriteSource(javaFile);
        }
    }
}

