/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.apt.commons;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.dominokit.domino.apt.commons.ProcessingException;
import org.dominokit.domino.apt.commons.ProcessorElement;

public abstract class BaseProcessor
extends AbstractProcessor {
    protected Types typeUtils;
    protected Elements elementUtils;
    protected Filer filer;
    protected Messager messager;
    protected ElementFactory elementFactory;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.elementFactory = new ElementFactory(this.elementUtils, this.typeUtils);
    }

    protected Writer obtainSourceWriter(String targetPackage, String className) throws IOException {
        return this.createSourceFile(targetPackage, className).openWriter();
    }

    protected JavaFileObject createSourceFile(String targetPackage, String className) throws IOException {
        return this.filer.createSourceFile(targetPackage + "." + className, new Element[0]);
    }

    protected Writer obtainResourceWriter(String targetPackage, String className) throws IOException {
        return this.createResourceFile(targetPackage, className).openWriter();
    }

    protected FileObject createResourceFile(String targetPackage, String className) throws IOException {
        return this.filer.createResource(StandardLocation.SOURCE_OUTPUT, targetPackage, className, new Element[0]);
    }

    protected boolean validateElementKind(Element element, ElementKind kind) {
        if (element.getKind() != kind) {
            throw new ProcessingException(element, "Only " + (Object)((Object)kind) + " can be annotated with @%s", new Object[0]);
        }
        return true;
    }

    protected ProcessorElement newProcessorElement(Element element) {
        return new ProcessorElement(element, this.elementUtils, this.typeUtils, this.messager);
    }

    public static interface ProcessingStep {
        public void process(Set<? extends Element> var1);
    }

    public class ElementFactory {
        private final Elements elementUtils;
        private final Types typeUtils;

        public ElementFactory(Elements elementUtils, Types typeUtils) {
            this.elementUtils = elementUtils;
            this.typeUtils = typeUtils;
        }

        public ProcessorElement make(Element element) {
            return new ProcessorElement(element, this.elementUtils, this.typeUtils, BaseProcessor.this.messager);
        }
    }
}

