/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.apt.commons;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ProcessorUtil {
    protected final Messager messager;
    protected final Filer filer;
    protected final Types types;
    protected final Elements elements;
    protected final ProcessingEnvironment processingEnv;

    protected ProcessorUtil(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.processingEnv = processingEnv;
    }

    public List<Element> getAnnotatedMethods(TypeMirror beanType, Class<? extends Annotation> annotation) {
        return this.getAnnotatedElements(beanType, annotation, (Element element) -> ElementKind.METHOD.equals((Object)element.getKind()));
    }

    public List<Element> getAnnotatedFields(TypeMirror beanType, Class<? extends Annotation> annotation) {
        return this.getAnnotatedElements(beanType, annotation, (Element element) -> ElementKind.FIELD.equals((Object)element.getKind()));
    }

    public List<Element> getAnnotatedElements(TypeMirror beanType, Class<? extends Annotation> annotation, Function<Element, Boolean> filter) {
        TypeElement typeElement = (TypeElement)this.types.asElement(beanType);
        ArrayList<Element> methods = new ArrayList<Element>();
        List<Element> annotatedMethods = this.getAnnotatedElements(typeElement, annotation, filter);
        methods.addAll(annotatedMethods);
        return methods;
    }

    public List<Element> getAnnotatedElements(TypeElement typeElement, Class<? extends Annotation> annotation, Function<Element, Boolean> filter) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return new ArrayList<Element>();
        }
        List<Element> methods = typeElement.getEnclosedElements().stream().filter(filter::apply).filter(element -> Objects.nonNull(element.getAnnotation(annotation))).collect(Collectors.toList());
        methods.addAll(this.getAnnotatedElements((TypeElement)this.types.asElement(superclass), annotation, filter));
        return methods;
    }

    public Optional<TypeMirror> findTypeArgument(TypeMirror element, Class<?> targetClass) {
        if (element.getKind().equals((Object)TypeKind.NONE)) {
            return Optional.empty();
        }
        DeclaredType elementType = (DeclaredType)element;
        List<? extends TypeMirror> typeArguments = elementType.getTypeArguments();
        for (TypeMirror typeMirror : typeArguments) {
            if (!this.isAssignableFrom(typeMirror, targetClass)) continue;
            return Optional.of(typeMirror);
        }
        TypeElement typeElement = (TypeElement)this.types.asElement(element);
        List<? extends TypeMirror> list = typeElement.getInterfaces();
        for (TypeMirror typeMirror : list) {
            List<? extends TypeMirror> interfaceTypeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            for (TypeMirror typeMirror2 : interfaceTypeArguments) {
                if (!this.isAssignableFrom(typeMirror2, targetClass)) continue;
                return Optional.of(typeMirror2);
            }
        }
        return this.findTypeArgument(typeElement.getSuperclass(), targetClass);
    }

    public String capitalizeFirstLetter(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public String smallFirstLetter(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public String lowerFirstLetter(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public boolean isAssignableFrom(Element element, Class<?> targetClass) {
        return this.types.isAssignable(element.asType(), this.types.getDeclaredType(this.elements.getTypeElement(targetClass.getCanonicalName()), new TypeMirror[0]));
    }

    public boolean isAssignableFrom(TypeMirror element, Class<?> targetClass) {
        return this.types.isAssignable(element, this.types.getDeclaredType(this.elements.getTypeElement(targetClass.getCanonicalName()), new TypeMirror[0]));
    }

    public Optional<TypeMirror> getClassValueFromAnnotation(Element element, Class<? extends Annotation> annotation, String paramName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.types.isSameType(annotationMirror.getAnnotationType(), this.elements.getTypeElement(annotation.getCanonicalName()).asType())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!paramName.equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue annotationValue = entry.getValue();
                return Optional.of((DeclaredType)annotationValue.getValue());
            }
        }
        return Optional.empty();
    }

    public List<TypeMirror> getClassArrayValueFromAnnotation(Element element, Class<? extends Annotation> annotation, String paramName) {
        ArrayList<TypeMirror> values = new ArrayList<TypeMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.types.isSameType(annotationMirror.getAnnotationType(), this.elements.getTypeElement(annotation.getCanonicalName()).asType())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!paramName.equals(entry.getKey().getSimpleName().toString())) continue;
                List classesTypes = (List)entry.getValue().getValue();
                for (AnnotationValue next : classesTypes) {
                    values.add((TypeMirror)next.getValue());
                }
            }
        }
        return values;
    }

    public List<ExecutableElement> getElementMethods(Element element) {
        return element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).collect(Collectors.toList());
    }

    public boolean isStringType(TypeMirror typeMirror) {
        TypeMirror stringType = this.elements.getTypeElement("java.lang.String").asType();
        return this.types.isAssignable(stringType, typeMirror);
    }
}

