/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.apt.commons;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.dominokit.domino.apt.commons.ProcessingException;

public class ProcessorElement {
    private final Element element;
    private Elements elementUtils;
    private Types typeUtils;
    private Messager messager;

    public ProcessorElement(Element element, Elements elementUtils, Types typeUtils, Messager messager) {
        this.element = element;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.messager = messager;
    }

    public ProcessorElement make(Element element) {
        return new ProcessorElement(element, this.elementUtils, this.typeUtils, this.messager);
    }

    public String elementPackage() {
        return this.elementUtils.getPackageOf(this.element).getQualifiedName().toString();
    }

    public TypeElement asTypeElement() {
        return (TypeElement)this.element;
    }

    public String simpleName() {
        return this.element.getSimpleName().toString();
    }

    public String fullQualifiedNoneGenericName() {
        return this.elementPackage() + "." + this.simpleName();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotation) {
        return this.element.getAnnotation(annotation);
    }

    public Stream<Element> fieldsStream() {
        return this.element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).map(e -> e);
    }

    public Stream<ExecutableElement> methodsStream() {
        return this.element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e);
    }

    public <A extends Annotation> Stream<Element> fieldsAnnotatedWithStream(Class<A> annotationClass) {
        return this.element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(e -> this.fieldAnnotatedWith((Element)e, annotationClass)).map(ele -> ele);
    }

    private <A extends Annotation> boolean fieldAnnotatedWith(Element element, Class<A> annotationClass) {
        return Objects.nonNull(element.getAnnotation(annotationClass));
    }

    public boolean isAssignableFrom(Class<?> targetClass) {
        return this.typeUtils.isAssignable(this.element.asType(), this.typeUtils.getDeclaredType(this.elementUtils.getTypeElement(targetClass.getName()), new TypeMirror[0]));
    }

    public boolean isImplementsGenericInterface(Class<?> targetInterface) {
        return this.asTypeElement().getInterfaces().stream().filter(i -> this.isSameInterface((TypeMirror)i, targetInterface)).count() > 0L;
    }

    private boolean isSameInterface(TypeMirror i, Class<?> targetInterface) {
        return targetInterface.getCanonicalName().equals(this.make(this.typeUtils.asElement(i)).fullQualifiedNoneGenericName());
    }

    public TypeMirror getInterfaceType(Class<?> targetInterface) {
        return (TypeMirror)this.asTypeElement().getInterfaces().stream().filter(i -> this.isSameInterface((TypeMirror)i, targetInterface)).collect(Collectors.toSet()).stream().findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public String getInterfaceFullQualifiedGenericName(Class<?> targetInterface) {
        return this.typeUtils.capture(this.getInterfaceType(targetInterface)).toString();
    }

    public boolean validateElementKind(ElementKind kind) {
        if (this.element.getKind() != kind) {
            throw new ProcessingException(this.element, "Only " + (Object)((Object)kind) + " can be annotated with @%s", new Object[0]);
        }
        return true;
    }

    public Element getElement() {
        return this.element;
    }

    public Messager getMessager() {
        return this.messager;
    }

    public Elements getElementUtils() {
        return this.elementUtils;
    }

    public Types getTypeUtils() {
        return this.typeUtils;
    }
}

