/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.domino.apt.commons;

import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ProcessorUtil {
    private static final int FIRST_ARGUMENT = 0;
    private static final int SECOND_ARGUMENT = 1;
    protected final Messager messager;
    protected final Filer filer;
    protected final Types types;
    protected final Elements elements;
    protected final ProcessingEnvironment processingEnv;

    protected ProcessorUtil(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.processingEnv = processingEnv;
    }

    public List<Element> getAnnotatedMethods(TypeMirror beanType, Class<? extends Annotation> annotation) {
        return this.getAnnotatedElements(beanType, annotation, (Element element) -> ElementKind.METHOD.equals((Object)element.getKind()));
    }

    public List<Element> getAnnotatedFields(TypeMirror beanType, Class<? extends Annotation> annotation) {
        return this.getAnnotatedElements(beanType, annotation, (Element element) -> ElementKind.FIELD.equals((Object)element.getKind()));
    }

    public List<Element> getAnnotatedElements(TypeMirror beanType, Class<? extends Annotation> annotation, Function<Element, Boolean> filter) {
        TypeElement typeElement = (TypeElement)this.types.asElement(beanType);
        ArrayList<Element> methods = new ArrayList<Element>();
        List<Element> annotatedMethods = this.getAnnotatedElements(typeElement, annotation, filter);
        methods.addAll(annotatedMethods);
        return methods;
    }

    public List<Element> getAnnotatedElements(TypeElement typeElement, Class<? extends Annotation> annotation, Function<Element, Boolean> filter) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return new ArrayList<Element>();
        }
        List<Element> methods = typeElement.getEnclosedElements().stream().filter(filter::apply).filter(element -> Objects.nonNull(element.getAnnotation(annotation))).collect(Collectors.toList());
        methods.addAll(this.getAnnotatedElements((TypeElement)this.types.asElement(superclass), annotation, filter));
        return methods;
    }

    public Optional<TypeMirror> findTypeArgument(TypeMirror element, Class<?> targetClass) {
        if (element.getKind().equals((Object)TypeKind.NONE)) {
            return Optional.empty();
        }
        DeclaredType elementType = (DeclaredType)element;
        List<? extends TypeMirror> typeArguments = elementType.getTypeArguments();
        for (TypeMirror typeMirror : typeArguments) {
            if (!this.isAssignableFrom(typeMirror, targetClass)) continue;
            return Optional.of(typeMirror);
        }
        TypeElement typeElement = (TypeElement)this.types.asElement(element);
        List<? extends TypeMirror> list = typeElement.getInterfaces();
        for (TypeMirror typeMirror : list) {
            List<? extends TypeMirror> interfaceTypeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            for (TypeMirror typeMirror2 : interfaceTypeArguments) {
                if (!this.isAssignableFrom(typeMirror2, targetClass)) continue;
                return Optional.of(typeMirror2);
            }
        }
        return this.findTypeArgument(typeElement.getSuperclass(), targetClass);
    }

    public String capitalizeFirstLetter(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public String smallFirstLetter(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public String lowerFirstLetter(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public boolean isAssignableFrom(Element element, Class<?> targetClass) {
        return this.types.isAssignable(element.asType(), this.types.getDeclaredType(this.elements.getTypeElement(targetClass.getCanonicalName()), new TypeMirror[0]));
    }

    public boolean isAssignableFrom(TypeMirror element, Class<?> targetClass) {
        return this.types.isAssignable(element, this.types.getDeclaredType(this.elements.getTypeElement(targetClass.getCanonicalName()), new TypeMirror[0]));
    }

    public Optional<TypeMirror> getClassValueFromAnnotation(Element element, Class<? extends Annotation> annotation, String paramName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.types.isSameType(annotationMirror.getAnnotationType(), this.elements.getTypeElement(annotation.getCanonicalName()).asType())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!paramName.equals(entry.getKey().getSimpleName().toString())) continue;
                AnnotationValue annotationValue = entry.getValue();
                return Optional.of((DeclaredType)annotationValue.getValue());
            }
        }
        return Optional.empty();
    }

    public List<TypeMirror> getClassArrayValueFromAnnotation(Element element, Class<? extends Annotation> annotation, String paramName) {
        ArrayList<TypeMirror> values = new ArrayList<TypeMirror>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.types.isSameType(annotationMirror.getAnnotationType(), this.elements.getTypeElement(annotation.getCanonicalName()).asType())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!paramName.equals(entry.getKey().getSimpleName().toString())) continue;
                List classesTypes = (List)entry.getValue().getValue();
                for (AnnotationValue next : classesTypes) {
                    values.add((TypeMirror)next.getValue());
                }
            }
        }
        return values;
    }

    public List<ExecutableElement> getElementMethods(Element element) {
        return element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).collect(Collectors.toList());
    }

    public boolean isStringType(TypeMirror typeMirror) {
        TypeMirror stringType = this.elements.getTypeElement("java.lang.String").asType();
        return this.types.isAssignable(stringType, typeMirror);
    }

    public TypeName wrapperType(TypeMirror type) {
        if (this.isPrimitive(type)) {
            if ("boolean".equals(type.toString())) {
                return TypeName.get(Boolean.class);
            }
            if ("byte".equals(type.toString())) {
                return TypeName.get(Byte.class);
            }
            if ("short".equals(type.toString())) {
                return TypeName.get(Short.class);
            }
            if ("int".equals(type.toString())) {
                return TypeName.get(Integer.class);
            }
            if ("long".equals(type.toString())) {
                return TypeName.get(Long.class);
            }
            if ("char".equals(type.toString())) {
                return TypeName.get(Character.class);
            }
            if ("float".equals(type.toString())) {
                return TypeName.get(Float.class);
            }
            if ("double".equals(type.toString())) {
                return TypeName.get(Double.class);
            }
            return TypeName.get(Void.class);
        }
        return TypeName.get((TypeMirror)type);
    }

    public boolean isPrimitive(TypeMirror typeMirror) {
        return typeMirror.getKind().isPrimitive();
    }

    public boolean isPrimitiveArray(TypeMirror typeMirror) {
        return this.isArray(typeMirror) && this.isPrimitive(this.arrayComponentType(typeMirror)) || this.isPrimitive2dArray(typeMirror);
    }

    private boolean isPrimitive2dArray(TypeMirror typeMirror) {
        return this.is2dArray(typeMirror) && this.isPrimitiveArray(this.arrayComponentType(typeMirror));
    }

    public boolean isArray(TypeMirror typeMirror) {
        return TypeKind.ARRAY.compareTo(typeMirror.getKind()) == 0;
    }

    public boolean is2dArray(TypeMirror typeMirror) {
        return this.isArray(typeMirror) && this.isArray(this.arrayComponentType(typeMirror));
    }

    public TypeMirror arrayComponentType(TypeMirror typeMirror) {
        return ((ArrayType)typeMirror).getComponentType();
    }

    public TypeMirror deepArrayComponentType(TypeMirror typeMirror) {
        TypeMirror type = ((ArrayType)typeMirror).getComponentType();
        return this.isArray(type) ? this.arrayComponentType(type) : type;
    }

    public boolean isEnum(TypeMirror typeMirror) {
        return !Objects.isNull(this.types.asElement(typeMirror)) && !this.isPrimitive(typeMirror) && !this.isPrimitiveArray(typeMirror) && ElementKind.ENUM.compareTo(this.types.asElement(typeMirror).getKind()) == 0;
    }

    public boolean isCollection(TypeMirror typeMirror) {
        return !this.isPrimitive(typeMirror) && this.isAssignableFrom(typeMirror, Collection.class);
    }

    public boolean isIterable(TypeMirror typeMirror) {
        return !this.isPrimitive(typeMirror) && this.isAssignableFrom(typeMirror, Iterable.class);
    }

    public boolean isMap(TypeMirror typeMirror) {
        return !this.isPrimitive(typeMirror) && this.isAssignableFrom(typeMirror, Map.class);
    }

    public TypeMirror firstTypeArgument(TypeMirror typeMirror) {
        return ((DeclaredType)typeMirror).getTypeArguments().get(0);
    }

    public TypeMirror secondTypeArgument(TypeMirror typeMirror) {
        return ((DeclaredType)typeMirror).getTypeArguments().get(1);
    }

    public String getPackage(TypeMirror typeMirror) {
        return this.elements.getPackageOf(this.types.asElement(typeMirror)).getSimpleName().toString();
    }

    public Name simpleName(TypeMirror typeMirror) {
        return this.types.asElement(typeMirror).getSimpleName();
    }
}

