/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.client.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "kn" locale.
 */
public class DateTimeFormatInfoImpl_kn extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "ಪೂರ್ವಾಹ್ನ",
        "ಅಪರಾಹ್ನ"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, MMMM d, y";
  }

  @Override
  public String dateFormatLong() {
    return "MMMM d, y";
  }

  @Override
  public String dateFormatMedium() {
    return "MMM d, y";
  }

  @Override
  public String dateFormatShort() {
    return "d/M/yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "ಕ್ರಿಸ್ತ ಪೂರ್ವ",
        "ಕ್ರಿಸ್ತ ಶಕ"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "ಕ್ರಿ.ಪೂ",
        "ಕ್ರಿ.ಶ"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatHour12Minute() {
    return "hh:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "hh:mm:ss a";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d,y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "ಜನವರಿ",
        "ಫೆಬ್ರವರಿ",
        "ಮಾರ್ಚ್",
        "ಏಪ್ರಿಲ್",
        "ಮೇ",
        "ಜೂನ್",
        "ಜುಲೈ",
        "ಆಗಸ್ಟ್",
        "ಸೆಪ್ಟೆಂಬರ್",
        "ಅಕ್ಟೋಬರ್",
        "ನವೆಂಬರ್",
        "ಡಿಸೆಂಬರ್"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "ಜ",
        "ಫೆ",
        "ಮಾ",
        "ಏ",
        "ಮೇ",
        "ಜೂ",
        "ಜು",
        "ಆ",
        "ಸೆ",
        "ಅ",
        "ನ",
        "ಡಿ"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "ಜನವರಿ",
        "ಫೆಬ್ರವರಿ",
        "ಮಾರ್ಚ್",
        "ಏಪ್ರಿ",
        "ಮೇ",
        "ಜೂನ್",
        "ಜುಲೈ",
        "ಆಗ",
        "ಸೆಪ್ಟೆಂ",
        "ಅಕ್ಟೋ",
        "ನವೆಂ",
        "ಡಿಸೆಂ"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "ಜನ",
        "ಫೆಬ್ರ",
        "ಮಾರ್ಚ್",
        "ಏಪ್ರಿ",
        "ಮೇ",
        "ಜೂನ್",
        "ಜುಲೈ",
        "ಆಗ",
        "ಸೆಪ್ಟೆಂ",
        "ಅಕ್ಟೋ",
        "ನವೆಂ",
        "ಡಿಸೆಂ"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1ನೇ ತ್ರೈಮಾಸಿಕ",
        "2ನೇ ತ್ರೈಮಾಸಿಕ",
        "3ನೇ ತ್ರೈಮಾಸಿಕ",
        "4ನೇ ತ್ರೈಮಾಸಿಕ"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "ತ್ರೈ 1",
        "ತ್ರೈ 2",
        "ತ್ರೈ 3",
        "ತ್ರೈ 4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "hh:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "hh:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "hh:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "hh:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "ಭಾನುವಾರ",
        "ಸೋಮವಾರ",
        "ಮಂಗಳವಾರ",
        "ಬುಧವಾರ",
        "ಗುರುವಾರ",
        "ಶುಕ್ರವಾರ",
        "ಶನಿವಾರ"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "ಭಾ",
        "ಸೋ",
        "ಮಂ",
        "ಬು",
        "ಗು",
        "ಶು",
        "ಶ"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ಭಾನು",
        "ಸೋಮ",
        "ಮಂಗಳ",
        "ಬುಧ",
        "ಗುರು",
        "ಶುಕ್ರ",
        "ಶನಿ"
    };
  }

  @Override
  public int weekendStart() {
    return 0;
  }
}
