/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.JsonDeserializer;
import org.dominokit.jacksonapt.JsonSerializer;
import org.dominokit.jacksonapt.ObjectMapper;
import org.dominokit.jacksonapt.ObjectReader;
import org.dominokit.jacksonapt.ObjectWriter;
import org.dominokit.jacksonapt.processor.AbstractMapperProcessor;
import org.dominokit.jacksonapt.processor.MapperGenerator;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.deserialization.FieldDeserializersChainBuilder;
import org.dominokit.jacksonapt.processor.serialization.FieldSerializerChainBuilder;

public abstract class AbstractMapperGenerator
implements MapperGenerator {
    @Override
    public void generate(Element element) throws IOException {
        String className = this.enclosingName(element, "_") + (AbstractMapperGenerator.useInterface(element) ? element.getSimpleName() : "Mapper") + "Impl";
        String packageName = AbstractMapperProcessor.elementUtils.getPackageOf(element).getQualifiedName().toString();
        TypeMirror beanType = AbstractMapperGenerator.getElementType(element);
        Name beanName = AbstractMapperProcessor.typeUtils.asElement(beanType).getSimpleName();
        this.generateJsonMappers(beanType, packageName, beanName);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(this.abstractObjectMapper(element)).addField(FieldSpec.builder((TypeName)ClassName.bestGuess((String)className), (String)"INSTANCE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.builder().add("new $T()", new Object[]{ClassName.bestGuess((String)className)}).build()).build()).addMethod(this.makeConstructor(beanName)).addMethods(this.getMapperMethods(element, beanType));
        if (AbstractMapperGenerator.useInterface(element)) {
            builder.addSuperinterface(TypeName.get((TypeMirror)element.asType()));
        }
        TypeSpec classSpec = builder.build();
        JavaFile.builder((String)packageName, (TypeSpec)classSpec).build().writeTo(AbstractMapperProcessor.filer);
    }

    protected static TypeMirror getElementType(Element element) {
        if (AbstractMapperGenerator.useInterface(element)) {
            TypeMirror objectReader = ((TypeElement)AbstractMapperProcessor.typeUtils.asElement(element.asType())).getInterfaces().get(0);
            return MoreTypes.asDeclared((TypeMirror)objectReader).getTypeArguments().get(0);
        }
        return element.asType();
    }

    protected static boolean useInterface(Element element) {
        return Type.isAssignableFrom(element.asType(), ObjectMapper.class) || Type.isAssignableFrom(element.asType(), ObjectReader.class) || Type.isAssignableFrom(element.asType(), ObjectWriter.class);
    }

    protected String enclosingName(Element element, String postfix) {
        if (AbstractMapperGenerator.useInterface(element)) {
            return element.getEnclosingElement().getSimpleName().toString() + postfix;
        }
        return element.getSimpleName().toString() + postfix;
    }

    protected TypeName abstractObjectMapper(Element element) {
        TypeMirror beanType = AbstractMapperGenerator.getElementType(element);
        return ParameterizedTypeName.get((ClassName)ClassName.get(this.getSuperClass()), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)beanType)});
    }

    protected MethodSpec makeConstructor(Name beanName) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super(\"" + beanName + "\")", new Object[0]).build();
    }

    protected MethodSpec makeNewDeserializerMethod(Element element, TypeMirror beanType) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (Type.isBasicType(AbstractMapperProcessor.typeUtils.erasure(beanType))) {
            builder.addStatement("return $L", new Object[]{new FieldDeserializersChainBuilder(AbstractMapperGenerator.getElementType(element)).getInstance(AbstractMapperGenerator.getElementType(element))});
        } else {
            builder.addStatement("return new " + this.deserializerName(beanType), new Object[0]);
        }
        return MethodSpec.methodBuilder((String)"newDeserializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonDeserializer.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)AbstractMapperGenerator.getElementType(element))})).addCode(builder.build()).build();
    }

    protected MethodSpec makeNewSerializerMethod(TypeMirror beanType) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (Type.isBasicType(AbstractMapperProcessor.typeUtils.erasure(beanType))) {
            builder.addStatement("return $L", new Object[]{new FieldSerializerChainBuilder(beanType).getInstance(beanType)});
        } else {
            builder.addStatement("return new " + this.serializerName(beanType), new Object[0]);
        }
        return MethodSpec.methodBuilder((String)"newSerializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonSerializer.class), (TypeName[])new TypeName[]{ObjectMapperProcessor.DEFAULT_WILDCARD})).addCode(builder.build()).build();
    }

    private String deserializerName(TypeMirror type) {
        return Type.stringifyType(type) + "BeanJsonDeserializerImpl()";
    }

    private String serializerName(TypeMirror type) {
        return Type.stringifyType(type) + "BeanJsonSerializerImpl()";
    }

    protected abstract Class<?> getSuperClass();

    protected abstract Iterable<MethodSpec> getMapperMethods(Element var1, TypeMirror var2);

    protected void generateJsonMappers(TypeMirror beanType, String packageName, Name beanName) {
        if (beanType instanceof DeclaredType) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)beanType).getTypeArguments();
            for (TypeMirror typeMirror : typeArguments) {
                this.generateJsonMappers(typeMirror, packageName, AbstractMapperProcessor.typeUtils.asElement(typeMirror).getSimpleName());
            }
            if (!Type.isBasicType(AbstractMapperProcessor.typeUtils.erasure(beanType))) {
                this.generateDeserializer(beanType, packageName);
                this.generateSerializer(beanType, packageName);
            }
        }
    }

    protected void generateSerializer(TypeMirror beanType, String packageName) {
    }

    protected void generateDeserializer(TypeMirror beanType, String packageName) {
    }
}

