/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;

public abstract class AbstractJsonMapperGenerator {
    protected final TypeMirror beanType;
    private final Filer filer;

    public AbstractJsonMapperGenerator(TypeMirror beanType, Filer filer) {
        this.beanType = beanType;
        this.filer = filer;
    }

    protected void generate(String packageName) throws IOException {
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(Type.stringifyType(this.beanType) + this.namePostfix())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(this.superClass()).addMethod(constructor).addMethod(this.targetTypeMethod());
        this.moreMethods().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        builder.addMethod(this.initMethod());
        JavaFile.builder((String)packageName, (TypeSpec)builder.build()).build().writeTo(this.filer);
    }

    private MethodSpec targetTypeMethod() {
        return MethodSpec.methodBuilder((String)this.targetTypeMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get(Class.class)).addStatement("return $T.class", new Object[]{TypeName.get((TypeMirror)ObjectMapperProcessor.typeUtils.erasure(this.beanType))}).build();
    }

    protected abstract TypeName superClass();

    protected abstract String namePostfix();

    protected abstract String targetTypeMethodName();

    protected Set<MethodSpec> moreMethods() {
        return Collections.emptySet();
    }

    protected abstract MethodSpec initMethod();

    protected List<Element> orderedFields() {
        TypeElement typeElement = (TypeElement)ObjectMapperProcessor.typeUtils.asElement(this.beanType);
        List<Object> typeArguments = Collections.emptyList();
        List<Object> typeParameters = Collections.emptyList();
        if (this.beanType instanceof DeclaredType) {
            typeArguments = ((DeclaredType)this.beanType).getTypeArguments();
            typeParameters = typeElement.getTypeParameters();
        }
        ArrayList<Element> fields = new ArrayList<Element>();
        List<Element> orderedFields = this.getOrderedFields(typeElement, typeParameters, typeArguments);
        fields.addAll(orderedFields);
        return fields;
    }

    private List<Element> getOrderedFields(TypeElement typeElement, List<? extends TypeParameterElement> typeParameters, List<? extends TypeMirror> typeArguments) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return new ArrayList<Element>();
        }
        ArrayList orderedProperties = new ArrayList();
        List enclosedFields = typeElement.getEnclosedElements().stream().filter(e -> ElementKind.FIELD.equals((Object)e.getKind()) && this.isEligibleForSerializationDeserialization((Element)e)).collect(Collectors.toList());
        Optional.ofNullable(ObjectMapperProcessor.typeUtils.asElement(this.beanType).getAnnotation(JsonPropertyOrder.class)).ifPresent(jsonPropertyOrder -> {
            List<String> orderedFieldsNames = Arrays.asList(jsonPropertyOrder.value());
            orderedProperties.addAll(enclosedFields.stream().filter(f -> orderedFieldsNames.contains(f.getSimpleName().toString())).collect(Collectors.toList()));
            enclosedFields.removeAll(orderedProperties);
            if (jsonPropertyOrder.alphabetic()) {
                enclosedFields.sort(Comparator.comparing(f -> f.getSimpleName().toString()));
            }
            enclosedFields.addAll(0, orderedProperties);
        });
        List<Element> orderedFields = enclosedFields.stream().map(field -> typeParameters.contains(ObjectMapperProcessor.typeUtils.asElement(field.asType())) ? this.wrapElementWithType((Element)field, (TypeMirror)typeArguments.get(typeParameters.indexOf(ObjectMapperProcessor.typeUtils.asElement(field.asType())))) : field).collect(Collectors.toList());
        List<Object> superTypeArguments = Collections.emptyList();
        List<Object> superTypeParameters = Collections.emptyList();
        if (superclass instanceof DeclaredType) {
            superTypeArguments = ((DeclaredType)superclass).getTypeArguments();
            superTypeParameters = ((TypeElement)ObjectMapperProcessor.typeUtils.asElement(superclass)).getTypeParameters();
        }
        superTypeArguments = superTypeArguments.stream().map(typeArgument -> typeParameters.contains(ObjectMapperProcessor.typeUtils.asElement((TypeMirror)typeArgument)) ? (TypeMirror)typeArguments.get(typeParameters.indexOf(ObjectMapperProcessor.typeUtils.asElement((TypeMirror)typeArgument))) : typeArgument).collect(Collectors.toList());
        orderedFields.addAll(this.getOrderedFields((TypeElement)ObjectMapperProcessor.typeUtils.asElement(superclass), superTypeParameters, superTypeArguments));
        return orderedFields;
    }

    private Element wrapElementWithType(final Element element, final TypeMirror typeMirror) {
        return new Element(){

            @Override
            public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                return element.getAnnotationsByType(annotationType);
            }

            @Override
            public TypeMirror asType() {
                return typeMirror;
            }

            @Override
            public ElementKind getKind() {
                return element.getKind();
            }

            @Override
            public Set<Modifier> getModifiers() {
                return element.getModifiers();
            }

            @Override
            public Name getSimpleName() {
                return element.getSimpleName();
            }

            @Override
            public Element getEnclosingElement() {
                return element.getEnclosingElement();
            }

            @Override
            public List<? extends Element> getEnclosedElements() {
                return element.getEnclosedElements();
            }

            @Override
            public List<? extends AnnotationMirror> getAnnotationMirrors() {
                return element.getAnnotationMirrors();
            }

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                return element.getAnnotation(annotationType);
            }

            @Override
            public <R, P> R accept(ElementVisitor<R, P> v, P p) {
                return element.accept(v, p);
            }
        };
    }

    protected boolean isNotStatic(Element field) {
        return !field.getModifiers().contains((Object)Modifier.STATIC);
    }

    protected boolean isIgnored(Element field) {
        JsonIgnore annotation = field.getAnnotation(JsonIgnore.class);
        return Objects.nonNull(annotation) && annotation.value();
    }

    protected boolean isEligibleForSerializationDeserialization(Element field) {
        return this.isNotStatic(field) && !this.isIgnored(field);
    }

    public static class AccessorInfo {
        public boolean present;
        public String accessor;

        public AccessorInfo(boolean present, String accessor) {
            this.present = present;
            this.accessor = accessor;
        }
    }
}

