/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ccp" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_ccp extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "AM",
        "PM"
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM, y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM, y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM, y";
  }

  @Override
  public String dateFormatShort() {
    return "d/M/yy";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄴𑄛𑄫𑄢𑄴𑄝𑄧",
        "𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄛𑄴𑄘𑄧"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄴𑄛𑄫𑄢𑄴𑄝𑄧",
        "𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄛𑄴𑄘𑄧"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "h:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFull() {
    return "LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String formatYear() {
    return "y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, d MMM, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "𑄎𑄚𑄪𑄠𑄢𑄨",
        "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨",
        "𑄟𑄢𑄴𑄌𑄧",
        "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴",
        "𑄟𑄬",
        "𑄎𑄪𑄚𑄴",
        "𑄎𑄪𑄣𑄭",
        "𑄃𑄉𑄧𑄌𑄴𑄑𑄴",
        "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴",
        "𑄃𑄧𑄇𑄴𑄑𑄬𑄝𑄧𑄢𑄴",
        "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴",
        "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "𑄎𑄚𑄪𑄠𑄢𑄨",
        "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨",
        "𑄟𑄢𑄴𑄌𑄧",
        "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴",
        "𑄟𑄬",
        "𑄎𑄪𑄚𑄴",
        "𑄎𑄪𑄣𑄭",
        "𑄃𑄉𑄧𑄌𑄴𑄑𑄴",
        "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴",
        "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴",
        "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴",
        "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "𑄎",
        "𑄜𑄬",
        "𑄟",
        "𑄃𑄬",
        "𑄟𑄬",
        "𑄎𑄪𑄚𑄴",
        "𑄎𑄪",
        "𑄃",
        "𑄥𑄬",
        "𑄃𑄧",
        "𑄚𑄧",
        "𑄓𑄨"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return monthsNarrow();
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "𑄎𑄚𑄪",
        "𑄜𑄬𑄛𑄴",
        "𑄟𑄢𑄴𑄌𑄧",
        "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴",
        "𑄟𑄬",
        "𑄎𑄪𑄚𑄴",
        "𑄎𑄪𑄣𑄭",
        "𑄃𑄉𑄧𑄌𑄴𑄑𑄴",
        "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴",
        "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴",
        "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴",
        "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄢𑄴"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "𑄎𑄚𑄪𑄠𑄢𑄨",
        "𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨",
        "𑄟𑄢𑄴𑄌𑄧",
        "𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴",
        "𑄟𑄬",
        "𑄎𑄪𑄚𑄴",
        "𑄎𑄪𑄣𑄭",
        "𑄃𑄉𑄧𑄌𑄴𑄑𑄴",
        "𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴",
        "𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴",
        "𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴",
        "𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴",
        "𑄘𑄨 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴",
        "𑄖𑄨𑄚𑄴 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴",
        "𑄌𑄳𑄆𑄬𑄢𑄴 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "Q1",
        "Q2",
        "Q3",
        "Q4"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "𑄢𑄧𑄝𑄨𑄝𑄢𑄴",
        "𑄥𑄧𑄟𑄴𑄝𑄢𑄴",
        "𑄟𑄧𑄁𑄉𑄧𑄣𑄴𑄝𑄢𑄴",
        "𑄝𑄪𑄖𑄴𑄝𑄢𑄴",
        "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴𑄝𑄢𑄴",
        "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴𑄝𑄢𑄴",
        "𑄥𑄧𑄚𑄨𑄝𑄢𑄴"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "𑄢𑄧",
        "𑄥𑄧",
        "𑄟𑄧",
        "𑄝𑄪",
        "𑄝𑄳𑄢𑄨",
        "𑄥𑄪",
        "𑄥𑄧"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "𑄢𑄧𑄝𑄨",
        "𑄥𑄧𑄟𑄴",
        "𑄟𑄧𑄁𑄉𑄧𑄣𑄴",
        "𑄝𑄪𑄖𑄴",
        "𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴",
        "𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴",
        "𑄥𑄧𑄚𑄨"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }

  @Override
  public int weekendEnd() {
    return 0;
  }

  @Override
  public int weekendStart() {
    return 0;
  }
}
