/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "wo" locale.
 */
public class LocalizedNamesImpl_wo extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "SN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "AL",
        "DE",
        "DZ",
        "AD",
        "AI",
        "AO",
        "AQ",
        "AG",
        "SA",
        "AM",
        "AR",
        "AW",
        "AZ",
        "HT",
        "BS",
        "BH",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BD",
        "BR",
        "BM",
        "BG",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BF",
        "BN",
        "BI",
        "BT",
        "TD",
        "CD",
        "CG",
        "CP",
        "DK",
        "DG",
        "DM",
        "AX",
        "UM",
        "FK",
        "FO",
        "HM",
        "KY",
        "CC",
        "CK",
        "MP",
        "MH",
        "PN",
        "SB",
        "TC",
        "VG",
        "VI",
        "BV",
        "CX",
        "IM",
        "NF",
        "EA",
        "ET",
        "EH",
        "EC",
        "SV",
        "AE",
        "IN",
        "ER",
        "EG",
        "SK",
        "SI",
        "ES",
        "EE",
        "US",
        "EU",
        "EZ",
        "FR",
        "FJ",
        "PH",
        "FI",
        "GA",
        "GM",
        "GH",
        "GD",
        "GR",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GL",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HK",
        "IC",
        "UA",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "DJ",
        "CV",
        "KH",
        "CM",
        "CA",
        "KZ",
        "QA",
        "KE",
        "KG",
        "KI",
        "CI",
        "CO",
        "KM",
        "KP",
        "HR",
        "XK",
        "CR",
        "KW",
        "KR",
        "CU",
        "CW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LU",
        "LI",
        "LT",
        "MG",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MK",
        "YT",
        "MX",
        "FM",
        "MM",
        "MO",
        "MD",
        "MC",
        "MN",
        "ME",
        "MR",
        "MS",
        "MU",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NE",
        "NI",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "HN",
        "HU",
        "AU",
        "AT",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "NL",
        "PF",
        "PL",
        "PT",
        "PR",
        "PS",
        "QO",
        "RE",
        "CZ",
        "DO",
        "CF",
        "RU",
        "RO",
        "GB",
        "RW",
        "JM",
        "ZM",
        "WS",
        "AS",
        "SM",
        "JP",
        "ST",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "SN",
        "RS",
        "JE",
        "GE",
        "GS",
        "SC",
        "GI",
        "CN",
        "CY",
        "CL",
        "ZW",
        "SG",
        "SX",
        "SY",
        "LK",
        "SR",
        "VA",
        "CH",
        "SL",
        "SO",
        "JO",
        "SD",
        "SS",
        "SZ",
        "SE",
        "SJ",
        "TA",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TF",
        "IO",
        "TL",
        "TN",
        "TT",
        "TR",
        "TM",
        "TG",
        "TK",
        "TO",
        "TV",
        "UG",
        "UN",
        "UY",
        "UZ",
        "WF",
        "VU",
        "VE",
        "VN",
        "XA",
        "XB",
        "YE",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AD", "Andoor");
    namesMap.put("AE", "Emira Arab Ini");
    namesMap.put("AF", "Afganistaŋ");
    namesMap.put("AG", "Antiguwa ak Barbuda");
    namesMap.put("AI", "Angiiy");
    namesMap.put("AL", "Albani");
    namesMap.put("AM", "Armeni");
    namesMap.put("AO", "Àngolaa");
    namesMap.put("AQ", "Antarktik");
    namesMap.put("AR", "Arsàntin");
    namesMap.put("AS", "Samowa bu Amerig");
    namesMap.put("AT", "Ótiriis");
    namesMap.put("AU", "Ostarali");
    namesMap.put("AX", "Duni Aalànd");
    namesMap.put("AZ", "Aserbayjaŋ");
    namesMap.put("BA", "Bosni Ersegowin");
    namesMap.put("BB", "Barbad");
    namesMap.put("BD", "Bengalades");
    namesMap.put("BE", "Belsig");
    namesMap.put("BF", "Burkina Faaso");
    namesMap.put("BG", "Bilgari");
    namesMap.put("BH", "Bahreyin");
    namesMap.put("BJ", "Benee");
    namesMap.put("BL", "Saŋ Bartalemi");
    namesMap.put("BM", "Bermid");
    namesMap.put("BN", "Burney");
    namesMap.put("BO", "Boliwi");
    namesMap.put("BR", "Beresil");
    namesMap.put("BT", "Butaŋ");
    namesMap.put("BV", "Dunu Buwet");
    namesMap.put("BY", "Belaris");
    namesMap.put("BZ", "Belis");
    namesMap.put("CA", "Kanadaa");
    namesMap.put("CC", "Duni Koko (Kilin)");
    namesMap.put("CF", "Repiblik Sàntar Afrik");
    namesMap.put("CH", "Siwis");
    namesMap.put("CI", "Kodiwaar (Côte d’Ivoire)");
    namesMap.put("CK", "Duni Kuuk");
    namesMap.put("CL", "Sili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Siin");
    namesMap.put("CO", "Kolombi");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kabo Werde");
    namesMap.put("CW", "Kursawo");
    namesMap.put("CX", "Dunu Kirismas");
    namesMap.put("CY", "Siipar");
    namesMap.put("CZ", "Réewum Cek");
    namesMap.put("DE", "Almaañ");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Danmàrk");
    namesMap.put("DM", "Dominik");
    namesMap.put("DO", "Repiblik Dominiken");
    namesMap.put("DZ", "Alseri");
    namesMap.put("EC", "Ekwaatër");
    namesMap.put("EE", "Estoni");
    namesMap.put("EG", "Esipt");
    namesMap.put("ER", "Eritere");
    namesMap.put("ES", "Españ");
    namesMap.put("ET", "Ecopi");
    namesMap.put("FI", "Finlànd");
    namesMap.put("FJ", "Fijji");
    namesMap.put("FK", "Duni Falkland");
    namesMap.put("FM", "Mikoronesi");
    namesMap.put("FO", "Duni Faro");
    namesMap.put("FR", "Faraans");
    namesMap.put("GA", "Gaboŋ");
    namesMap.put("GB", "Ruwaayom Ini");
    namesMap.put("GD", "Garanad");
    namesMap.put("GE", "Seworsi");
    namesMap.put("GF", "Guyaan Farañse");
    namesMap.put("GG", "Gernase");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Sibraltaar");
    namesMap.put("GL", "Girinlànd");
    namesMap.put("GM", "Gàmbi");
    namesMap.put("GN", "Gine");
    namesMap.put("GP", "Guwaadelup");
    namesMap.put("GQ", "Gine Ekuwatoriyal");
    namesMap.put("GR", "Gerees");
    namesMap.put("GS", "Seworsi di Sid ak Duni Sàndwiis di Sid");
    namesMap.put("GT", "Guwatemala");
    namesMap.put("GU", "Guwam");
    namesMap.put("GW", "Gine-Bisaawóo");
    namesMap.put("GY", "Giyaan");
    namesMap.put("HM", "Duni Hërd ak Duni MakDonald");
    namesMap.put("HN", "Onduraas");
    namesMap.put("HR", "Korowasi");
    namesMap.put("HT", "Ayti");
    namesMap.put("HU", "Ongari");
    namesMap.put("ID", "Indonesi");
    namesMap.put("IE", "Irlànd");
    namesMap.put("IL", "Israyel");
    namesMap.put("IM", "Dunu Maan");
    namesMap.put("IN", "End");
    namesMap.put("IO", "Terituwaaru Brëtaañ ci Oseyaa Enjeŋ");
    namesMap.put("IQ", "Irag");
    namesMap.put("IR", "Iraŋ");
    namesMap.put("IS", "Islànd");
    namesMap.put("IT", "Itali");
    namesMap.put("JE", "Serse");
    namesMap.put("JM", "Samayig");
    namesMap.put("JO", "Sordani");
    namesMap.put("JP", "Sàppoŋ");
    namesMap.put("KE", "Keeña");
    namesMap.put("KG", "Kirgistaŋ");
    namesMap.put("KH", "Kàmboj");
    namesMap.put("KM", "Komoor");
    namesMap.put("KN", "Saŋ Kits ak Newis");
    namesMap.put("KP", "Kore Noor");
    namesMap.put("KW", "Kowet");
    namesMap.put("KY", "Duni Kaymaŋ");
    namesMap.put("KZ", "Kasaxstaŋ");
    namesMap.put("LA", "Lawos");
    namesMap.put("LB", "Libaa");
    namesMap.put("LC", "Saŋ Lusi");
    namesMap.put("LI", "Liktensteyin");
    namesMap.put("LK", "Siri Lànka");
    namesMap.put("LR", "Liberiya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litiyani");
    namesMap.put("LU", "Liksàmbur");
    namesMap.put("LV", "Letoni");
    namesMap.put("LY", "Libi");
    namesMap.put("MA", "Marog");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldawi");
    namesMap.put("ME", "Montenegoro");
    namesMap.put("MF", "Saŋ Marteŋ");
    namesMap.put("MG", "Madagaskaar");
    namesMap.put("MH", "Duni Marsaal");
    namesMap.put("MK", "Maseduwaan");
    namesMap.put("MM", "Miyanmaar");
    namesMap.put("MN", "Mongoli");
    namesMap.put("MP", "Duni Mariyaan Noor");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mooritani");
    namesMap.put("MS", "Mooseraa");
    namesMap.put("MT", "Malt");
    namesMap.put("MU", "Moriis");
    namesMap.put("MV", "Maldiiw");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malesi");
    namesMap.put("MZ", "Mosàmbig");
    namesMap.put("NA", "Namibi");
    namesMap.put("NC", "Nuwel Kaledoni");
    namesMap.put("NE", "Niiseer");
    namesMap.put("NF", "Dunu Norfolk");
    namesMap.put("NG", "Niseriya");
    namesMap.put("NI", "Nikaraguwa");
    namesMap.put("NL", "Peyi Baa");
    namesMap.put("NO", "Norwees");
    namesMap.put("NP", "Nepaal");
    namesMap.put("NR", "Nawru");
    namesMap.put("NU", "Niw");
    namesMap.put("NZ", "Nuwel Selànd");
    namesMap.put("OM", "Omaan");
    namesMap.put("PF", "Polinesi Farañse");
    namesMap.put("PG", "Papuwasi Gine Gu Bees");
    namesMap.put("PH", "Filipin");
    namesMap.put("PK", "Pakistaŋ");
    namesMap.put("PL", "Poloñ");
    namesMap.put("PM", "Saŋ Peer ak Mikeloŋ");
    namesMap.put("PN", "Duni Pitkayirn");
    namesMap.put("PR", "Porto Riko");
    namesMap.put("PT", "Portigaal");
    namesMap.put("PW", "Palaw");
    namesMap.put("PY", "Paraguwe");
    namesMap.put("QA", "Kataar");
    namesMap.put("RE", "Reeñoo");
    namesMap.put("RO", "Rumani");
    namesMap.put("RS", "Serbi");
    namesMap.put("RU", "Risi");
    namesMap.put("RW", "Ruwànda");
    namesMap.put("SA", "Arabi Sawudi");
    namesMap.put("SB", "Duni Salmoon");
    namesMap.put("SC", "Seysel");
    namesMap.put("SD", "Sudaŋ");
    namesMap.put("SE", "Suwed");
    namesMap.put("SG", "Singapuur");
    namesMap.put("SH", "Saŋ Eleen");
    namesMap.put("SI", "Esloweni");
    namesMap.put("SJ", "Swalbaar ak Jan Mayen");
    namesMap.put("SK", "Eslowaki");
    namesMap.put("SL", "Siyera Lewon");
    namesMap.put("SN", "Senegaal");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Sirinam");
    namesMap.put("SS", "Sudaŋ di Sid");
    namesMap.put("ST", "Sawo Tome ak Pirinsipe");
    namesMap.put("SV", "El Salwadoor");
    namesMap.put("SX", "Sin Marten");
    namesMap.put("SY", "Siri");
    namesMap.put("SZ", "Suwasilànd");
    namesMap.put("TC", "Duni Tirk ak Kaykos");
    namesMap.put("TD", "Càdd");
    namesMap.put("TF", "Teer Ostraal gu Fraas");
    namesMap.put("TH", "Taylànd");
    namesMap.put("TJ", "Tajikistaŋ");
    namesMap.put("TK", "Tokoloo");
    namesMap.put("TL", "Timor Leste");
    namesMap.put("TM", "Tirkmenistaŋ");
    namesMap.put("TN", "Tinisi");
    namesMap.put("TR", "Tirki");
    namesMap.put("TT", "Tirinite ak Tobago");
    namesMap.put("TV", "Tuwalo");
    namesMap.put("TW", "Taywan");
    namesMap.put("TZ", "Taŋsani");
    namesMap.put("UA", "Ikeren");
    namesMap.put("UG", "Ugànda");
    namesMap.put("UM", "Duni Amerig Utar meer");
    namesMap.put("US", "Etaa Sini");
    namesMap.put("UY", "Uruge");
    namesMap.put("UZ", "Usbekistaŋ");
    namesMap.put("VA", "Site bu Watikaa");
    namesMap.put("VC", "Saŋ Weesaa ak Garanadin");
    namesMap.put("VE", "Wenesiyela");
    namesMap.put("VG", "Duni Wirsin yu Brëtaañ");
    namesMap.put("VI", "Duni Wirsin yu Etaa-sini");
    namesMap.put("VN", "Wiyetnam");
    namesMap.put("VU", "Wanuatu");
    namesMap.put("WF", "Walis ak Futuna");
    namesMap.put("WS", "Samowa");
    namesMap.put("XK", "Kosowo");
    namesMap.put("YE", "Yaman");
    namesMap.put("YT", "Mayot");
    namesMap.put("ZA", "Afrik di Sid");
    namesMap.put("ZM", "Sàmbi");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "Gox buñ xamul");
  }

}
