/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.deserialization;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.dominokit.jacksonapt.JacksonContextProvider;
import org.dominokit.jacksonapt.JsonDeserializer;
import org.dominokit.jacksonapt.JsonDeserializerParameters;
import org.dominokit.jacksonapt.deser.bean.HasDeserializerAndParameters;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.deserialization.FieldDeserializersChainBuilder;

public class ParameterDeserializerBuilder {
    private Types typeUtils;
    private TypeMirror type;
    private VariableElement parameter;
    private String packageName;

    public ParameterDeserializerBuilder(Types typeUtils, TypeMirror type, VariableElement parameter, String packageName) {
        this.typeUtils = typeUtils;
        this.type = type;
        this.parameter = parameter;
        this.packageName = packageName;
    }

    CodeBlock build() {
        TypeName typeName = Type.wrapperType(this.parameter.asType());
        MethodSpec build = MethodSpec.methodBuilder((String)"newDeserializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(ParameterizedTypeName.get(JsonDeserializer.class)).addAnnotation(Override.class).addStatement("return $L", new Object[]{new FieldDeserializersChainBuilder(this.packageName, this.parameter.asType()).getInstance(this.parameter)}).build();
        ParameterizedTypeName deserializerType = ParameterizedTypeName.get((ClassName)ClassName.get(HasDeserializerAndParameters.class), (TypeName[])new TypeName[]{typeName, ParameterizedTypeName.get((ClassName)ClassName.get(JsonDeserializer.class), (TypeName[])new TypeName[]{typeName})});
        TypeSpec.Builder typeBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)deserializerType).addMethod(build);
        this.typeUtils.asElement(this.type).getEnclosedElements().stream().filter(o -> o.getKind().isField()).filter(o -> o.getSimpleName().toString().equals(this.getParameterName())).filter(o -> Objects.nonNull(o.getAnnotation(JsonFormat.class))).findFirst().ifPresent(o -> typeBuilder.addMethod(this.buildParametersMethod((Element)o)));
        return CodeBlock.builder().addStatement("final $T $L = $L", new Object[]{deserializerType, this.getDeserializerName(), typeBuilder.build()}).build();
    }

    private MethodSpec buildParametersMethod(Element element) {
        JsonFormat jsonFormat = element.getAnnotation(JsonFormat.class);
        return MethodSpec.methodBuilder((String)"newParameters").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns(JsonDeserializerParameters.class).addStatement("return $T.get()\n\t\t.newDeserializerParameters()\n\t\t.setPattern($S)\n\t\t.setShape($T.$L)", new Object[]{TypeName.get(JacksonContextProvider.class), jsonFormat.pattern(), TypeName.get(JsonFormat.Shape.class), jsonFormat.shape().toString()}).build();
    }

    public String getParameterName() {
        String parameterName = this.parameter.getSimpleName().toString();
        JsonProperty jsonProperty = this.parameter.getAnnotation(JsonProperty.class);
        if (Objects.nonNull(jsonProperty)) {
            String value = jsonProperty.value();
            parameterName = value.isEmpty() ? parameterName : value;
        }
        return parameterName;
    }

    public String getDeserializerName() {
        return this.getParameterName() + "Deserializer";
    }

    public TypeMirror getParameterType() {
        return this.parameter.asType();
    }
}

