/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.dominokit.jacksonapt.annotation.JSONMapper;
import org.dominokit.jacksonapt.annotation.JSONReader;
import org.dominokit.jacksonapt.annotation.JSONWriter;
import org.dominokit.jacksonapt.processor.TypeRegistry;

public abstract class AbstractMapperProcessor
extends AbstractProcessor {
    public static Messager messager;
    public static Types typeUtils;
    public static Filer filer;
    public static Elements elementUtils;
    public static ProcessingEnvironment environment;
    protected Set<? extends Element> mappers;
    protected Set<? extends Element> readers;
    protected Set<? extends Element> writers;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        environment = processingEnv;
        filer = processingEnv.getFiler();
        messager = processingEnv.getMessager();
        typeUtils = processingEnv.getTypeUtils();
        elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            TypeRegistry.resetTypeRegistry();
            return false;
        }
        this.mappers = roundEnv.getElementsAnnotatedWith(JSONMapper.class);
        this.readers = roundEnv.getElementsAnnotatedWith(JSONReader.class);
        this.writers = roundEnv.getElementsAnnotatedWith(JSONWriter.class);
        return this.doProcess(annotations, roundEnv);
    }

    protected abstract boolean doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    protected void handleError(Exception e) {
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        messager.printMessage(Diagnostic.Kind.ERROR, "error while creating source file " + out.getBuffer().toString());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnotations().stream().map(Class::getCanonicalName).collect(Collectors.toSet());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    protected abstract List<Class<?>> supportedAnnotations();
}

