/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.dominokit.jacksonapt.processor.AbstractJsonMapperGenerator;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;

public class AccessorsFilter {
    protected Types typeUtils;

    public AccessorsFilter(Types typeUtils) {
        this.typeUtils = typeUtils;
    }

    protected Set<AbstractJsonMapperGenerator.AccessorInfo> getAccessors(TypeMirror beanType) {
        TypeElement element = (TypeElement)this.typeUtils.asElement(beanType);
        TypeMirror superclass = element.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return new HashSet<AbstractJsonMapperGenerator.AccessorInfo>();
        }
        Set<AbstractJsonMapperGenerator.AccessorInfo> collect = ((TypeElement)ObjectMapperProcessor.typeUtils.asElement(beanType)).getEnclosedElements().stream().filter(e -> ElementKind.METHOD.equals((Object)e.getKind()) && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.PUBLIC)).map(e -> new AbstractJsonMapperGenerator.AccessorInfo(Optional.of((ExecutableElement)e))).collect(Collectors.toSet());
        collect.addAll(this.getAccessors(superclass));
        return collect;
    }

    protected String getPropertyName(Element field) {
        JsonProperty annotation = field.getAnnotation(JsonProperty.class);
        if (Objects.isNull(annotation) || "".equals(annotation.value())) {
            return field.getSimpleName().toString();
        }
        return annotation.value();
    }
}

