/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.SubTypesInfo;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.TypeRegistry;
import org.dominokit.jacksonapt.processor.deserialization.AptDeserializerBuilder;

public class DeserializerGenerator {
    public String generate(String packageName, TypeMirror beanType) {
        String deserializerName = Type.deserializerName(packageName, beanType);
        if (!TypeRegistry.containsDeserializer(Type.stringifyTypeWithPackage(beanType))) {
            try {
                this.generateSubTypesDeserializers(beanType, packageName);
                TypeRegistry.addInActiveGenDeserializer(beanType);
                new AptDeserializerBuilder(packageName, beanType, ObjectMapperProcessor.filer).generate();
                TypeRegistry.registerDeserializer(Type.stringifyTypeWithPackage(beanType), (TypeName)ClassName.bestGuess((String)deserializerName));
                TypeRegistry.removeInActiveGenDeserializer(beanType);
            }
            catch (IOException e) {
                throw new DeserializerGenerationFailedException(beanType.toString());
            }
        }
        return deserializerName;
    }

    private void generateSubTypesDeserializers(TypeMirror beanType, String packageName) {
        SubTypesInfo subTypesInfo = Type.getSubTypes(beanType);
        for (Map.Entry<String, TypeMirror> subtypeEntry : subTypesInfo.getSubTypes().entrySet()) {
            if (!((DeclaredType)beanType).getTypeArguments().isEmpty() || !((DeclaredType)((DeclaredType)subtypeEntry.getValue()).asElement().asType()).getTypeArguments().isEmpty()) {
                throw new RuntimeException("@JsonSubTypes and &JsonTypeInfo can be used only on non-generic Java types");
            }
            new DeserializerGenerator().generate(packageName, subtypeEntry.getValue());
        }
    }

    private class DeserializerGenerationFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        DeserializerGenerationFailedException(String type) {
            super(type);
        }
    }
}

