/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.deserialization;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.dominokit.jacksonapt.JacksonContextProvider;
import org.dominokit.jacksonapt.JsonDeserializationContext;
import org.dominokit.jacksonapt.JsonDeserializer;
import org.dominokit.jacksonapt.JsonDeserializerParameters;
import org.dominokit.jacksonapt.deser.bean.BeanPropertyDeserializer;
import org.dominokit.jacksonapt.processor.AbstractJsonMapperGenerator;
import org.dominokit.jacksonapt.processor.AccessorsFilter;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.deserialization.FieldDeserializersChainBuilder;

class DeserializerBuilder
extends AccessorsFilter {
    private final TypeMirror beanType;
    private final Element field;
    private final TypeMirror fieldType;
    private final String packageName;

    DeserializerBuilder(Types typeUtils, TypeMirror beanType, String packageName, Element field, TypeMirror fieldType) {
        super(typeUtils);
        this.beanType = beanType;
        this.field = field;
        this.fieldType = fieldType;
        this.packageName = packageName;
    }

    TypeSpec buildDeserializer() {
        String paramValue = "value";
        String paramBean = "bean";
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BeanPropertyDeserializer.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.beanType), Type.wrapperType(this.fieldType)}));
        builder.addMethod(this.buildDeserializerMethod());
        if (Objects.nonNull(this.field.getAnnotation(JsonFormat.class))) {
            builder.addMethod(this.buildParametersMethod());
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"setValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ClassName.get((TypeMirror)this.beanType), "bean", new Modifier[0]);
        AbstractJsonMapperGenerator.AccessorInfo accessorInfo = this.setterInfo(this.field);
        methodBuilder.addParameter(Type.wrapperType(this.fieldType), "value", new Modifier[0]).addParameter(JsonDeserializationContext.class, "ctx", new Modifier[0]).addStatement("$L", new Object[]{"bean." + accessorInfo.getName() + (accessorInfo.method.isPresent() ? "(" : "=") + "value" + (accessorInfo.method.isPresent() ? ")" : "")});
        builder.addMethod(methodBuilder.build());
        return builder.build();
    }

    private MethodSpec buildDeserializerMethod() {
        return MethodSpec.methodBuilder((String)"newDeserializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonDeserializer.class), (TypeName[])new TypeName[]{ObjectMapperProcessor.DEFAULT_WILDCARD})).addStatement("return $L", new Object[]{new FieldDeserializersChainBuilder(this.packageName, this.beanType).getInstance(this.fieldType)}).build();
    }

    private MethodSpec buildParametersMethod() {
        JsonFormat jsonFormat = this.field.getAnnotation(JsonFormat.class);
        return MethodSpec.methodBuilder((String)"newParameters").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns(JsonDeserializerParameters.class).addStatement("return $T.get()\n\t\t.newDeserializerParameters()\n\t\t.setPattern($S)\n\t\t.setShape($T.$L)", new Object[]{TypeName.get(JacksonContextProvider.class), jsonFormat.pattern(), TypeName.get(JsonFormat.Shape.class), jsonFormat.shape().toString()}).build();
    }

    private AbstractJsonMapperGenerator.AccessorInfo setterInfo(Element field) {
        String upperCaseFirstLetter = this.upperCaseFirstLetter(field.getSimpleName().toString());
        Optional<AbstractJsonMapperGenerator.AccessorInfo> accessor = this.getAccessors(this.beanType).stream().filter(accessorInfo -> accessorInfo.getName().equals("set" + upperCaseFirstLetter)).findFirst();
        return accessor.orElseGet(() -> new AbstractJsonMapperGenerator.AccessorInfo(field.getSimpleName().toString()));
    }

    private String upperCaseFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

