/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.registration;

import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.ObjectMapper;
import org.dominokit.jacksonapt.ObjectReader;
import org.dominokit.jacksonapt.ObjectWriter;
import org.dominokit.jacksonapt.annotation.JSONRegistration;
import org.dominokit.jacksonapt.processor.AbstractMapperProcessor;
import org.dominokit.jacksonapt.registration.JsonRegistry;
import org.dominokit.jacksonapt.registration.TypeToken;

public class JSONRegistrationProcessor
extends AbstractMapperProcessor {
    private static final String WRITERS = "WRITERS";
    private static final String READERS = "READERS";
    private static final String MAPPERS = "MAPPERS";
    private static final String INSTANCE_NAME = "INSTANCE";

    @Override
    protected boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(JSONRegistration.class).forEach(this::register);
        return false;
    }

    private void register(Element element) {
        FieldSpec mappersMap = this.createConstantMap(MAPPERS, ObjectMapper.class);
        FieldSpec readersMap = this.createConstantMap(READERS, ObjectReader.class);
        FieldSpec writersMap = this.createConstantMap(WRITERS, ObjectWriter.class);
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        this.mappers.stream().map(this::registerMapperLine).forEach(arg_0 -> ((MethodSpec.Builder)constructorBuilder).addCode(arg_0));
        this.readers.stream().map(this::registerReaderLine).forEach(arg_0 -> ((MethodSpec.Builder)constructorBuilder).addCode(arg_0));
        this.writers.stream().map(this::registerWriterLine).forEach(arg_0 -> ((MethodSpec.Builder)constructorBuilder).addCode(arg_0));
        ClassName className = ClassName.get((String)this.packageOf(element), (String)(element.getAnnotation(JSONRegistration.class).value() + "JsonRegistry"), (String[])new String[0]);
        FieldSpec instanceField = FieldSpec.builder((TypeName)className, (String)INSTANCE_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{className}).build();
        MethodSpec getMapperMethod = this.createGetMethod("getMapper", MAPPERS, ObjectMapper.class, false);
        MethodSpec getReaderMethod = this.createGetMethod("getReader", READERS, ObjectReader.class, true);
        MethodSpec getWriterMethod = this.createGetMethod("getWriter", WRITERS, ObjectWriter.class, true);
        TypeSpec jacksonConfigurator = TypeSpec.classBuilder((ClassName)className).addJavadoc(CodeBlock.of((String)"This is generated class, please don't modify\n", (Object[])new Object[0])).addSuperinterface(JsonRegistry.class).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "\"" + this.getClass().getCanonicalName() + "\"", new Object[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(mappersMap).addField(readersMap).addField(writersMap).addField(instanceField).addMethod(this.createGetInstanceMethod((TypeName)className)).addMethod(constructorBuilder.build()).addMethod(getMapperMethod).addMethod(getReaderMethod).addMethod(getWriterMethod).build();
        try {
            JavaFile.builder((String)this.packageOf(element), (TypeSpec)jacksonConfigurator).build().writeTo(filer);
        }
        catch (IOException e) {
            this.handleError(e);
        }
    }

    private MethodSpec createGetInstanceMethod(TypeName result) {
        return MethodSpec.methodBuilder((String)"getInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(result).addStatement("return INSTANCE", new Object[0]).build();
    }

    private MethodSpec createGetMethod(String name, String mapName, Class<?> returnType, boolean lookupIfNotFound) {
        TypeVariableName typeVariable = TypeVariableName.get((String)"T");
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"unchecked\"", new Object[0]).build()).addTypeVariable(typeVariable).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(returnType), (TypeName[])new TypeName[]{typeVariable})).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.dominokit.jacksonapt.registration", (String)"TypeToken", (String[])new String[0]), (TypeName[])new TypeName[]{typeVariable}), "type", new Modifier[0]);
        ParameterizedTypeName returnTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(returnType), (TypeName[])new TypeName[]{typeVariable});
        if (lookupIfNotFound) {
            methodBuilder.beginControlFlow("if(" + mapName + ".containsKey(type))", new Object[0]).addStatement("return ($T)" + mapName + ".get(type)", new Object[]{returnTypeName}).endControlFlow().addStatement("return ($T)MAPPERS.get(type)", new Object[]{returnTypeName});
        } else {
            methodBuilder.addStatement("return ($T)" + mapName + ".get(type)", new Object[]{returnTypeName});
        }
        return methodBuilder.build();
    }

    private FieldSpec createConstantMap(String name, Class<?> jsonType) {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.dominokit.jacksonapt.registration", (String)"TypeToken", (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"?")}), ParameterizedTypeName.get((ClassName)ClassName.get(jsonType), (TypeName[])new TypeName[]{TypeVariableName.get((String)"?")})});
        return FieldSpec.builder((TypeName)parameterizedTypeName, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>()", new Object[]{HashMap.class}).build();
    }

    private String packageOf(Element configuration) {
        return this.processingEnv.getElementUtils().getPackageOf(configuration).getQualifiedName().toString();
    }

    private CodeBlock registerMapperLine(Element element) {
        return this.registerLine(element, MAPPERS);
    }

    private CodeBlock registerReaderLine(Element element) {
        return this.registerLine(element, READERS);
    }

    private CodeBlock registerWriterLine(Element element) {
        return this.registerLine(element, WRITERS);
    }

    private CodeBlock registerLine(Element element, String mapName) {
        String className = this.enclosingName(element) + (this.useInterface(element) ? element.getSimpleName() : "Mapper") + "Impl";
        String packageName = elementUtils.getPackageOf(element).getQualifiedName().toString();
        CodeBlock.Builder typeTokenBuilder = CodeBlock.builder();
        this.addTypeTokenLiteral(typeTokenBuilder, TypeName.get((TypeMirror)this.getBeanType(element)));
        return CodeBlock.builder().addStatement(mapName + ".put($L, new " + packageName + "." + className + "())", new Object[]{typeTokenBuilder.build()}).build();
    }

    private void addTypeTokenLiteral(CodeBlock.Builder builder, TypeName name) {
        List<Object> typeArguments;
        ClassName rawType;
        builder.add("new $T<$L>(", new Object[]{TypeToken.class, name.isPrimitive() ? name.box() : name});
        if (name instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)name;
            rawType = parameterizedTypeName.rawType;
            typeArguments = parameterizedTypeName.typeArguments;
        } else if (name instanceof ArrayTypeName) {
            ArrayTypeName arrayTypeName = (ArrayTypeName)name;
            rawType = null;
            typeArguments = Collections.singletonList(arrayTypeName.componentType);
        } else if (name instanceof ClassName || name instanceof TypeName) {
            rawType = name.isPrimitive() ? name.box() : name;
            typeArguments = Collections.emptyList();
        } else {
            throw new IllegalArgumentException("Unsupported type " + name);
        }
        if (rawType == null) {
            builder.add("null", new Object[0]);
        } else {
            builder.add("$T.class", new Object[]{rawType});
        }
        for (TypeName typeName : typeArguments) {
            builder.add(", ", new Object[0]);
            this.addTypeTokenLiteral(builder, typeName);
        }
        builder.add(") {}", new Object[0]);
    }

    private String enclosingName(Element element) {
        if (this.useInterface(element)) {
            return element.getEnclosingElement().getSimpleName().toString() + "_";
        }
        return element.getSimpleName().toString() + "_";
    }

    private boolean useInterface(Element element) {
        return this.isAssignableFrom(element, ObjectMapper.class) || this.isAssignableFrom(element, ObjectReader.class) || this.isAssignableFrom(element, ObjectWriter.class);
    }

    private boolean isAssignableFrom(Element element, Class<?> targetClass) {
        return typeUtils.isAssignable(element.asType(), typeUtils.getDeclaredType(elementUtils.getTypeElement(targetClass.getName()), new TypeMirror[0]));
    }

    private TypeMirror getBeanType(Element element) {
        if (this.useInterface(element)) {
            TypeMirror objectReader = ((TypeElement)typeUtils.asElement(element.asType())).getInterfaces().get(0);
            return MoreTypes.asDeclared((TypeMirror)objectReader).getTypeArguments().get(0);
        }
        return element.asType();
    }

    @Override
    protected List<Class<?>> supportedAnnotations() {
        return Collections.singletonList(JSONRegistration.class);
    }
}

