/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.serialization;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.dominokit.jacksonapt.JsonSerializationContext;
import org.dominokit.jacksonapt.JsonSerializer;
import org.dominokit.jacksonapt.processor.AbstractJsonMapperGenerator;
import org.dominokit.jacksonapt.processor.AbstractMapperProcessor;
import org.dominokit.jacksonapt.processor.BeanIdentityInfo;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.serialization.FieldSerializerChainBuilder;
import org.dominokit.jacksonapt.processor.serialization.SerializerBuilder;
import org.dominokit.jacksonapt.ser.bean.AbstractBeanJsonSerializer;
import org.dominokit.jacksonapt.ser.bean.AbstractIdentitySerializationInfo;
import org.dominokit.jacksonapt.ser.bean.BeanPropertySerializer;
import org.dominokit.jacksonapt.ser.bean.IdentitySerializationInfo;
import org.dominokit.jacksonapt.ser.bean.ObjectIdSerializer;
import org.dominokit.jacksonapt.ser.bean.PropertyIdentitySerializationInfo;
import org.dominokit.jacksonapt.ser.bean.SubtypeSerializer;
import org.dominokit.jacksonapt.ser.bean.TypeSerializationInfo;

public class AptSerializerBuilder
extends AbstractJsonMapperGenerator {
    public AptSerializerBuilder(String packageName, TypeMirror beanType, Filer filer) {
        super(packageName, beanType, filer);
    }

    @Override
    protected TypeName superClass() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(AbstractBeanJsonSerializer.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)this.beanType)});
    }

    @Override
    protected String namePostfix() {
        return "BeanJsonSerializerImpl";
    }

    @Override
    protected String targetTypeMethodName() {
        return "getSerializedType";
    }

    @Override
    protected MethodSpec initMethod() {
        return this.buildInitSerializersMethod(this.beanType);
    }

    @Override
    protected Set<MethodSpec> moreMethods() {
        HashSet<MethodSpec> methods = new HashSet<MethodSpec>();
        Optional<BeanIdentityInfo> beanIdentityInfo = Type.processIdentity(this.beanType);
        if (beanIdentityInfo.isPresent()) {
            Optional<CodeBlock> serializerType = this.getIdentitySerializerType(beanIdentityInfo.get());
            methods.add(this.buildInitIdentityInfoMethod(serializerType, beanIdentityInfo));
        }
        return methods;
    }

    private Optional<CodeBlock> getIdentitySerializerType(BeanIdentityInfo identityInfo) {
        if (identityInfo.isIdABeanProperty()) {
            return Optional.empty();
        }
        return Optional.of(new FieldSerializerChainBuilder(identityInfo.getType().get()).getInstance(identityInfo.getType().get()));
    }

    private MethodSpec buildInitIdentityInfoMethod(Optional<CodeBlock> serializerType, Optional<BeanIdentityInfo> beanIdentityInfo) {
        return MethodSpec.methodBuilder((String)"initIdentityInfo").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(IdentitySerializationInfo.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.beanType)})).addStatement("return $L", new Object[]{this.generateIdentifierSerializationInfo(beanIdentityInfo.get(), serializerType)}).build();
    }

    private TypeSpec generateIdentifierSerializationInfo(BeanIdentityInfo identityInfo, Optional<CodeBlock> serializerType) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"$L, $S", (Object[])new Object[]{identityInfo.isAlwaysAsId(), identityInfo.getPropertyName()});
        if (identityInfo.isIdABeanProperty()) {
            Map<Element, TypeMirror> fieldsMap = this.orderedFields();
            Optional<Map.Entry> propertyEntry = fieldsMap.entrySet().stream().filter(entry -> ((Element)entry.getKey()).getSimpleName().toString().equals(identityInfo.getPropertyName())).findFirst();
            if (propertyEntry.isPresent()) {
                builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(PropertyIdentitySerializationInfo.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.beanType), Type.wrapperType((TypeMirror)propertyEntry.get().getValue())}));
                this.buildBeanPropertySerializerBody(builder, propertyEntry.get());
            } else {
                AbstractMapperProcessor.messager.printMessage(Diagnostic.Kind.ERROR, "Property [" + identityInfo.getPropertyName() + "] not found in type [" + this.beanType.toString() + "]!.");
            }
        } else {
            TypeMirror qualifiedType = identityInfo.getType().get();
            builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AbstractIdentitySerializationInfo.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.beanType), TypeName.get((TypeMirror)qualifiedType)}));
            builder.addMethod(MethodSpec.methodBuilder((String)"newSerializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonSerializer.class), (TypeName[])new TypeName[]{ObjectMapperProcessor.DEFAULT_WILDCARD})).addStatement("return $L", new Object[]{serializerType.get()}).build());
            ParameterizedTypeName generatorType = ParameterizedTypeName.get((ClassName)ClassName.get(ObjectIdGenerator.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)qualifiedType)});
            ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(ObjectIdSerializer.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)qualifiedType)});
            builder.addMethod(MethodSpec.methodBuilder((String)"getObjectId").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)returnType).addParameter(TypeName.get((TypeMirror)this.beanType), "bean", new Modifier[0]).addParameter(JsonSerializationContext.class, "ctx", new Modifier[0]).addStatement("$T generator = new $T().forScope($T.class)", new Object[]{generatorType, identityInfo.getGenerator(), identityInfo.getScope().get()}).addStatement("$T scopedGen = ctx.findObjectIdGenerator(generator)", new Object[]{generatorType}).beginControlFlow("if (null == scopedGen)", new Object[0]).addStatement("scopedGen = generator.newForSerialization(ctx)", new Object[0]).addStatement("ctx.addGenerator(scopedGen)", new Object[0]).endControlFlow().addStatement("return new $T(scopedGen.generateId(bean), getSerializer())", new Object[]{returnType}).build());
        }
        return builder.build();
    }

    private void buildBeanPropertySerializerBody(TypeSpec.Builder builder, Map.Entry<Element, TypeMirror> property) {
        CodeBlock serializerType = new FieldSerializerChainBuilder(property.getValue()).getInstance(property.getValue());
        String paramName = "bean";
        AbstractJsonMapperGenerator.AccessorInfo accessorInfo = new SerializerBuilder(AbstractMapperProcessor.typeUtils, this.beanType, this.packageName, property.getKey(), property.getValue()).getterInfo();
        MethodSpec.Builder newSerializerMethodBuilder = MethodSpec.methodBuilder((String)"newSerializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addStatement("return $L", new Object[]{serializerType});
        newSerializerMethodBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonSerializer.class), (TypeName[])new TypeName[]{ObjectMapperProcessor.DEFAULT_WILDCARD}));
        builder.addMethod(newSerializerMethodBuilder.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"getValue").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Type.wrapperType(property.getValue())).addParameter(TypeName.get((TypeMirror)this.beanType), paramName, new Modifier[0]).addParameter(JsonSerializationContext.class, "ctx", new Modifier[0]).addStatement("return $L.$L()", new Object[]{paramName, accessorInfo.getName()}).build());
    }

    @Override
    protected MethodSpec initSubtypesMethod() {
        if (this.subTypesInfo == null) {
            return MethodSpec.methodBuilder((String)"initMapSubtypeClassToSerializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(SubtypeSerializer.class)})).addStatement("return $T.emptyMap()", new Object[]{Collections.class}).build();
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initMapSubtypeClassToSerializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(SubtypeSerializer.class)})).addStatement("$T map = new $T($L)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(SubtypeSerializer.class)}), ClassName.get(IdentityHashMap.class), this.subTypesInfo.getSubTypes().size()});
        for (Map.Entry<String, TypeMirror> subtypeEntry : this.subTypesInfo.getSubTypes().entrySet()) {
            TypeSpec subtypeType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ClassName.get(SubtypeSerializer.BeanSubtypeSerializer.class)).addMethod(MethodSpec.methodBuilder((String)"newSerializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonSerializer.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})).addStatement("return new $T()", new Object[]{ClassName.bestGuess((String)Type.serializerName(this.packageName, subtypeEntry.getValue()))}).build()).build();
            builder.addStatement("map.put($T.class, $L)", new Object[]{TypeName.get((TypeMirror)subtypeEntry.getValue()), subtypeType});
        }
        builder.addStatement("return map", new Object[0]);
        return builder.build();
    }

    private MethodSpec buildInitSerializersMethod(TypeMirror beanType) {
        int[] index = new int[]{0};
        Map<Element, TypeMirror> fields = this.orderedFields();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initSerializers").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns(TypeName.get(BeanPropertySerializer[].class)).addStatement("$T result = new $T[$L]", new Object[]{ArrayTypeName.of(BeanPropertySerializer.class), BeanPropertySerializer.class, fields.size()});
        fields.entrySet().stream().filter(entry -> this.isEligibleForSerializationDeserialization((Element)entry.getKey())).forEach(entry -> {
            Object[] objectArray = new Object[2];
            int n = index[0];
            index[0] = n + 1;
            objectArray[0] = n;
            objectArray[1] = new SerializerBuilder(AbstractMapperProcessor.typeUtils, beanType, this.packageName, (Element)entry.getKey(), (TypeMirror)entry.getValue()).buildSerializer();
            builder.addStatement("result[$L] = $L", objectArray);
        });
        builder.addStatement("return result", new Object[0]);
        return builder.build();
    }

    @Override
    protected Class<?> getMapperType() {
        return TypeSerializationInfo.class;
    }
}

