/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.serialization;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.MappersChainBuilder;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.TypeRegistry;
import org.dominokit.jacksonapt.ser.CollectionJsonSerializer;
import org.dominokit.jacksonapt.ser.EnumJsonSerializer;
import org.dominokit.jacksonapt.ser.IterableJsonSerializer;
import org.dominokit.jacksonapt.ser.array.ArrayJsonSerializer;
import org.dominokit.jacksonapt.ser.array.dd.Array2dJsonSerializer;
import org.dominokit.jacksonapt.ser.map.MapJsonSerializer;

public class FieldSerializerChainBuilder
implements MappersChainBuilder {
    private static final String GET_INSTANCE = "$T.getInstance()";
    private static final String NEW_INSTANCE = "$T.newInstance(";
    private boolean rootGenerated = true;
    private CodeBlock.Builder builder = CodeBlock.builder();
    private Deque<TypeName> serializers = new LinkedList<TypeName>();
    private final TypeMirror beanType;
    private final String packageName;

    public FieldSerializerChainBuilder(TypeMirror beanType) {
        this.beanType = beanType;
        this.packageName = null;
        this.rootGenerated = true;
    }

    public FieldSerializerChainBuilder(TypeMirror beanType, boolean rootGenerated) {
        this.beanType = beanType;
        this.packageName = null;
        this.rootGenerated = rootGenerated;
    }

    public FieldSerializerChainBuilder(String packageName, TypeMirror beanType) {
        this.beanType = beanType;
        this.packageName = packageName;
        this.rootGenerated = true;
    }

    public FieldSerializerChainBuilder(String packageName, TypeMirror beanType, boolean rootGenerated) {
        this.beanType = beanType;
        this.packageName = packageName;
        this.rootGenerated = rootGenerated;
    }

    @Override
    public CodeBlock getInstance(Element field) {
        return this.builder.add(this.getFieldSerializer(field.asType()), (Object[])this.asClassesArray()).build();
    }

    @Override
    public CodeBlock getInstance(TypeMirror fieldType) {
        return this.builder.add(this.getFieldSerializer(fieldType), (Object[])this.asClassesArray()).build();
    }

    private TypeName[] asClassesArray() {
        return this.serializers.toArray(new TypeName[this.serializers.size()]);
    }

    private String getFieldSerializer(TypeMirror typeMirror) {
        if (Type.isCollection(typeMirror = Type.removeOuterWildCards(typeMirror))) {
            return this.getCollectionSerializer(typeMirror);
        }
        if (Type.isIterable(typeMirror)) {
            return this.getIterableSerializer(typeMirror);
        }
        if (Type.isMap(typeMirror)) {
            return this.getMapSerializer(typeMirror);
        }
        if (Type.isArray(typeMirror)) {
            return this.getArraySerializer(typeMirror);
        }
        if (Type.isEnum(typeMirror)) {
            return this.getEnumSerializer();
        }
        return this.getBasicOrCustomSerializer(typeMirror);
    }

    private String getBasicOrCustomSerializer(TypeMirror typeMirror) {
        if (Type.isBasicType(typeMirror)) {
            return this.getBasicSerializer(typeMirror);
        }
        return this.getCustomSerializer(typeMirror);
    }

    private String getCustomSerializer(TypeMirror typeMirror) {
        if (Type.stringifyTypeWithPackage(typeMirror).equals(Type.stringifyTypeWithPackage(this.beanType)) && this.rootGenerated) {
            this.serializers.addLast((TypeName)ClassName.bestGuess((String)Type.serializerName(this.getPackageName(typeMirror), typeMirror)));
        } else if (TypeRegistry.containsSerializer(Type.stringifyTypeWithPackage(typeMirror))) {
            this.serializers.addLast(TypeRegistry.getCustomSerializer(typeMirror));
        } else {
            TypeRegistry.registerSerializer(Type.stringifyTypeWithPackage(typeMirror), (TypeName)ClassName.bestGuess((String)this.generateCustomSerializer(typeMirror)));
            this.serializers.addLast(TypeRegistry.getCustomSerializer(typeMirror));
            this.rootGenerated = true;
        }
        return "new $T()";
    }

    private String getPackageName(TypeMirror typeMirror) {
        if (Type.isJsonMapper(typeMirror) || Objects.isNull(this.packageName)) {
            return ClassName.bestGuess((String)typeMirror.toString()).packageName();
        }
        return this.packageName;
    }

    private String generateCustomSerializer(TypeMirror typeMirror) {
        if (TypeRegistry.containsSerializer(typeMirror) || TypeRegistry.isInActiveGenSerializer(typeMirror)) {
            return Type.serializerName(this.getPackageName(typeMirror), typeMirror);
        }
        TypeRegistry.addInActiveGenSerializer(typeMirror);
        String serializerName = Type.generateSerializer(this.getPackageName(typeMirror), typeMirror);
        TypeRegistry.removeInActiveGenSerializer(typeMirror);
        return serializerName;
    }

    private String getEnumSerializer() {
        this.serializers.addLast(TypeName.get(EnumJsonSerializer.class));
        return GET_INSTANCE;
    }

    private String getBasicSerializer(TypeMirror typeMirror) {
        this.serializers.addLast(TypeRegistry.getSerializer(typeMirror));
        return GET_INSTANCE;
    }

    private String getMapSerializer(TypeMirror typeMirror) {
        this.serializers.addLast(TypeName.get(MapJsonSerializer.class));
        return NEW_INSTANCE + this.getKeySerializer(Type.firstTypeArgument(typeMirror)) + ", " + this.getFieldSerializer(Type.secondTypeArgument(typeMirror)) + ")";
    }

    private String getKeySerializer(TypeMirror typeMirror) {
        if (Type.isEnum(typeMirror = Type.removeOuterWildCards(typeMirror))) {
            this.serializers.addLast(TypeRegistry.getKeySerializer(Enum.class.getName()));
        } else {
            this.serializers.addLast(TypeRegistry.getKeySerializer(Type.stringifyTypeWithPackage(Type.removeOuterWildCards(typeMirror))));
        }
        return GET_INSTANCE;
    }

    private String getCollectionSerializer(TypeMirror typeMirror) {
        this.serializers.addLast(TypeName.get(CollectionJsonSerializer.class));
        return NEW_INSTANCE + this.getFieldSerializer(Type.firstTypeArgument(typeMirror)) + ")";
    }

    private String getIterableSerializer(TypeMirror typeMirror) {
        this.serializers.addLast(TypeName.get(IterableJsonSerializer.class));
        return NEW_INSTANCE + this.getFieldSerializer(Type.firstTypeArgument(typeMirror)) + ")";
    }

    private String getArraySerializer(TypeMirror typeMirror) {
        if (Type.isPrimitiveArray(typeMirror)) {
            return this.getBasicSerializer(typeMirror);
        }
        if (Type.is2dArray(typeMirror)) {
            this.serializers.addLast(TypeName.get(Array2dJsonSerializer.class));
            return NEW_INSTANCE + this.getFieldSerializer(Type.deepArrayComponentType(typeMirror)) + ")";
        }
        this.serializers.addLast(TypeName.get(ArrayJsonSerializer.class));
        return NEW_INSTANCE + this.getFieldSerializer(Type.arrayComponentType(typeMirror)) + ")";
    }
}

