/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.serialization;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.dominokit.jacksonapt.JacksonContextProvider;
import org.dominokit.jacksonapt.JsonSerializationContext;
import org.dominokit.jacksonapt.JsonSerializer;
import org.dominokit.jacksonapt.JsonSerializerParameters;
import org.dominokit.jacksonapt.processor.AbstractJsonMapperGenerator;
import org.dominokit.jacksonapt.processor.AccessorsFilter;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.serialization.FieldSerializerChainBuilder;
import org.dominokit.jacksonapt.ser.bean.BeanPropertySerializer;
import org.dominokit.jacksonapt.stream.impl.DefaultJsonWriter;

class SerializerBuilder
extends AccessorsFilter {
    private final TypeMirror beanType;
    private final Element field;
    private final TypeMirror fieldType;
    private final String packageName;

    SerializerBuilder(Types typeUtils, TypeMirror beanType, String packageName, Element field, TypeMirror fieldType) {
        super(typeUtils);
        this.beanType = beanType;
        this.field = field;
        this.fieldType = fieldType;
        this.packageName = packageName;
    }

    TypeSpec buildSerializer() {
        String paramBean = "bean";
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"\"$L\"", (Object[])new Object[]{DefaultJsonWriter.encodeString((String)this.getPropertyName(this.field))}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(BeanPropertySerializer.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.beanType), Type.wrapperType(this.fieldType)}));
        builder.addMethod(this.buildSerializerMethod());
        if (this.shouldAddParametersMethod()) {
            builder.addMethod(this.buildParametersMethod());
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getValue").returns(Type.wrapperType(this.fieldType)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ClassName.get((TypeMirror)this.beanType), "bean", new Modifier[0]);
        AbstractJsonMapperGenerator.AccessorInfo accessorInfo = this.getterInfo();
        methodBuilder.addParameter(JsonSerializationContext.class, "ctx", new Modifier[0]).addStatement("return $L", new Object[]{"bean." + accessorInfo.getName() + (accessorInfo.method.isPresent() ? "()" : "")});
        builder.addMethod(methodBuilder.build());
        return builder.build();
    }

    private boolean shouldAddParametersMethod() {
        return Objects.nonNull(this.field.getAnnotation(JsonFormat.class)) || Objects.nonNull(this.field.getAnnotation(JsonInclude.class)) || this.hasTypeJsonInclude();
    }

    private MethodSpec buildSerializerMethod() {
        return MethodSpec.methodBuilder((String)"newSerializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonSerializer.class), (TypeName[])new TypeName[]{ObjectMapperProcessor.DEFAULT_WILDCARD})).addStatement("return $L", new Object[]{new FieldSerializerChainBuilder(this.packageName, this.beanType).getInstance(this.fieldType)}).build();
    }

    private MethodSpec buildParametersMethod() {
        JsonFormat jsonFormat = this.field.getAnnotation(JsonFormat.class);
        JsonInclude jsonInclude = this.getJsonInclude();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"newParameters").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns(JsonSerializerParameters.class).addStatement("$T parameters = $T.get().newSerializerParameters()", new Object[]{TypeName.get(JsonSerializerParameters.class), TypeName.get(JacksonContextProvider.class)});
        if (Objects.nonNull(jsonFormat)) {
            methodBuilder.addStatement("parameters.setPattern($S).setShape($T.$L)", new Object[]{jsonFormat.pattern(), TypeName.get(JsonFormat.Shape.class), jsonFormat.shape().toString()});
        }
        if (Objects.nonNull(jsonInclude)) {
            methodBuilder.addStatement("parameters.setInclude($T.$L)", new Object[]{TypeName.get(JsonInclude.Include.class), jsonInclude.value().toString()});
        }
        return methodBuilder.addStatement("return parameters", new Object[0]).build();
    }

    private JsonInclude getJsonInclude() {
        if (Objects.nonNull(this.field.getAnnotation(JsonInclude.class))) {
            return this.field.getAnnotation(JsonInclude.class);
        }
        return this.beanType.getKind() == TypeKind.DECLARED ? this.getJsonInclude((DeclaredType)this.beanType) : null;
    }

    private JsonInclude getJsonInclude(DeclaredType enclosingType) {
        TypeElement enclosingElement = (TypeElement)enclosingType.asElement();
        return enclosingElement.getAnnotation(JsonInclude.class);
    }

    private boolean hasTypeJsonInclude() {
        if (this.beanType.getKind() == TypeKind.DECLARED) {
            return ((DeclaredType)this.beanType).asElement().getAnnotation(JsonInclude.class) != null;
        }
        return false;
    }

    AbstractJsonMapperGenerator.AccessorInfo getterInfo() {
        String upperCaseFirstLetter = this.upperCaseFirstLetter(this.field.getSimpleName().toString());
        String prefix = this.field.asType().getKind() == TypeKind.BOOLEAN ? "is" : "get";
        Optional<AbstractJsonMapperGenerator.AccessorInfo> accessor = this.getAccessors(this.beanType).stream().filter(accessorInfo -> accessorInfo.getName().equals(prefix + upperCaseFirstLetter)).findFirst();
        return accessor.orElseGet(() -> new AbstractJsonMapperGenerator.AccessorInfo(this.field.getSimpleName().toString()));
    }

    private String upperCaseFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

