/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "kab_DZ" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_kab_DZ extends DateTimeFormatInfoImpl_kab {

  @Override
  public String[] ampms() {
    return new String[] {
        "n tufat",
        "n tmeddit"
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "EEEE d MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM, y";
  }

  @Override
  public String dateFormatShort() {
    return "d/M/y";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " 'af' " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " 'af' " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + ", " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + ", " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "send talalit n Ɛisa",
        "seld talalit n Ɛisa"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "snd. T.Ɛ",
        "sld. T.Ɛ"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 6;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "h:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "m:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "MMM";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFull() {
    return "MMMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String formatYear() {
    return "y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE d MMM y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "Yennayer",
        "Fuṛar",
        "Meɣres",
        "Yebrir",
        "Mayyu",
        "Yunyu",
        "Yulyu",
        "Ɣuct",
        "Ctembeṛ",
        "Tubeṛ",
        "Nunembeṛ",
        "Duǧembeṛ"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "Yennayer",
        "Fuṛar",
        "Meɣres",
        "Yebrir",
        "Mayyu",
        "Yunyu",
        "Yulyu",
        "Ɣuct",
        "Ctembeṛ",
        "Tubeṛ",
        "Wambeṛ",
        "Duǧembeṛ"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "Y",
        "F",
        "Ɣ",
        "B",
        "M",
        "N",
        "L",
        "C",
        "T",
        "R",
        "W",
        "D"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return new String[] {
        "Y",
        "F",
        "M",
        "Y",
        "M",
        "Y",
        "Y",
        "Ɣ",
        "C",
        "T",
        "N",
        "D"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "Yen",
        "Fur",
        "Meɣ",
        "Yeb",
        "May",
        "Yun",
        "Yul",
        "Ɣuc",
        "Cte",
        "Tub",
        "Nun",
        "Duǧ"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "Yen",
        "Fur",
        "Meɣ",
        "Yeb",
        "May",
        "Yun",
        "Yul",
        "Ɣuc",
        "Cte",
        "Tub",
        "Wam",
        "Duj"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "akraḍaggur amenzu",
        "akraḍaggur wis-sin",
        "akraḍaggur wis-kraḍ",
        "akraḍaggur wis-kuẓ"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "Kḍg1",
        "Kḍg2",
        "Kḍg3",
        "Kḍg4"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "Yanass",
        "Sanass",
        "Kraḍass",
        "Kuẓass",
        "Samass",
        "Sḍisass",
        "Sayass"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return new String[] {
        "Acer",
        "Arim",
        "Aram",
        "Ahad",
        "Amhad",
        "Sem",
        "Sed"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "C",
        "R",
        "A",
        "H",
        "M",
        "S",
        "D"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return new String[] {
        "Y",
        "S",
        "K",
        "K",
        "S",
        "S",
        "S"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "Yan",
        "San",
        "Kraḍ",
        "Kuẓ",
        "Sam",
        "Sḍis",
        "Say"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return new String[] {
        "Ace",
        "Ari",
        "Ara",
        "Aha",
        "Amh",
        "Sem",
        "Sed"
    };
  }

  @Override
  public int weekendEnd() {
    return 6;
  }

  @Override
  public int weekendStart() {
    return 5;
  }
}
