/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ckb" locale.
 */
public class LocalizedNamesImpl_ckb extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IQ",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AW",
        "AZ",
        "AQ",
        "AG",
        "AD",
        "AI",
        "IS",
        "JO",
        "UY",
        "UZ",
        "AU",
        "UG",
        "UA",
        "IT",
        "IE",
        "EE",
        "IL",
        "ES",
        "ID",
        "EC",
        "IR",
        "SV",
        "ET",
        "AM",
        "AR",
        "ER",
        "ZA",
        "AF",
        "AO",
        "AL",
        "DE",
        "BB",
        "BR",
        "BN",
        "BI",
        "BF",
        "BG",
        "BT",
        "BW",
        "BA",
        "BO",
        "BY",
        "BM",
        "BJ",
        "BH",
        "BE",
        "BZ",
        "BD",
        "BS",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TA",
        "TT",
        "TM",
        "TR",
        "TN",
        "TV",
        "TO",
        "TK",
        "TG",
        "TL",
        "JM",
        "DJ",
        "JE",
        "DZ",
        "DK",
        "BQ",
        "AX",
        "TC",
        "GS",
        "UM",
        "SB",
        "FO",
        "MH",
        "MP",
        "FK",
        "HM",
        "PN",
        "VI",
        "VG",
        "KY",
        "CK",
        "KM",
        "CC",
        "IC",
        "AC",
        "BV",
        "IM",
        "NF",
        "CX",
        "CP",
        "DM",
        "DG",
        "QO",
        "ZM",
        "ZW",
        "WS",
        "AS",
        "SM",
        "ST",
        "RS",
        "LK",
        "SK",
        "SI",
        "SZ",
        "SR",
        "SD",
        "SS",
        "SY",
        "SE",
        "CH",
        "SJ",
        "SO",
        "SC",
        "SX",
        "SG",
        "SL",
        "EA",
        "SN",
        "EH",
        "BL",
        "LC",
        "MF",
        "SH",
        "PM",
        "KN",
        "VC",
        "GB",
        "OM",
        "IQ",
        "SA",
        "GH",
        "PH",
        "FJ",
        "FI",
        "FR",
        "KG",
        "CY",
        "QA",
        "LV",
        "LA",
        "LB",
        "LU",
        "LY",
        "LR",
        "LT",
        "LI",
        "LS",
        "MG",
        "MQ",
        "MW",
        "MV",
        "ML",
        "MY",
        "MO",
        "MK",
        "MT",
        "FM",
        "YT",
        "MU",
        "MR",
        "MZ",
        "MD",
        "MC",
        "MS",
        "ME",
        "MM",
        "AE",
        "EG",
        "MA",
        "MN",
        "MX",
        "NR",
        "NA",
        "PS",
        "EZ",
        "NO",
        "NG",
        "NE",
        "NZ",
        "NU",
        "NC",
        "NP",
        "NI",
        "UN",
        "AT",
        "HK",
        "TF",
        "HU",
        "WF",
        "US",
        "PY",
        "PW",
        "PA",
        "PG",
        "PK",
        "PT",
        "PR",
        "PF",
        "PL",
        "PE",
        "TD",
        "CL",
        "CN",
        "RW",
        "RU",
        "RO",
        "RE",
        "JP",
        "VA",
        "VU",
        "VN",
        "VE",
        "KZ",
        "CM",
        "HR",
        "CW",
        "CU",
        "KW",
        "CI",
        "KR",
        "KP",
        "CR",
        "XK",
        "CO",
        "CF",
        "DO",
        "CZ",
        "CG",
        "CD",
        "KI",
        "KE",
        "KH",
        "CA",
        "CV",
        "GA",
        "GM",
        "GD",
        "GL",
        "GT",
        "GP",
        "GU",
        "GE",
        "GY",
        "GF",
        "GI",
        "GN",
        "GW",
        "GQ",
        "GG",
        "HT",
        "HN",
        "NL",
        "IN",
        "IO",
        "GR",
        "YE",
        "EU",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "جیهان");
    namesMap.put("002", "ئەفریقا");
    namesMap.put("003", "ئەمەریکای باکوور");
    namesMap.put("005", "ئەمەریکای باشوور");
    namesMap.put("009", "ئۆقیانووسیا");
    namesMap.put("011", "ڕۆژاوای ئەفریقا");
    namesMap.put("013", "ئەمریکای ناوەڕاست");
    namesMap.put("014", "ڕۆژھەڵاتی ئەفریقا");
    namesMap.put("015", "باکووری ئەفریقا");
    namesMap.put("017", "ناوەڕاستی ئەفریقا");
    namesMap.put("018", "باشووری ئەفریقا");
    namesMap.put("019", "ئەمەریکای باکوور و باشوور");
    namesMap.put("021", "ئەمریکای باکوور");
    namesMap.put("029", "کاریبی");
    namesMap.put("030", "ڕۆژهەڵاتی ئاسیا");
    namesMap.put("034", "باشووری ئاسیا");
    namesMap.put("035", "باشووری ڕۆژھەڵاتی ئاسیا");
    namesMap.put("039", "باشووری ئەورووپا");
    namesMap.put("053", "ئۆسترالیا");
    namesMap.put("054", "میلانێزیا");
    namesMap.put("057", "ناوچەی مایکرۆنیزیا");
    namesMap.put("061", "پۆلینیزیا");
    namesMap.put("142", "ئاسیا");
    namesMap.put("143", "ناوەڕاستی ئاسیا");
    namesMap.put("145", "ڕۆژاوای ئاسیا");
    namesMap.put("150", "ئەورووپا");
    namesMap.put("151", "ڕۆژهەڵاتی ئەورووپا");
    namesMap.put("154", "باکووری ئەورووپا");
    namesMap.put("155", "ڕۆژاوای ئەورووپا");
    namesMap.put("202", "ئەفریقای ژێر سەحرا");
    namesMap.put("419", "ئەمەریکای لاتین");
    namesMap.put("AC", "دوورگەی ئاسینسیۆن");
    namesMap.put("AD", "ئاندۆرا");
    namesMap.put("AE", "میرنشینە یەکگرتووە عەرەبییەکان");
    namesMap.put("AF", "ئەفغانستان");
    namesMap.put("AG", "ئانتیگوا و باربودا");
    namesMap.put("AI", "ئانگویلا");
    namesMap.put("AL", "ئەڵبانیا");
    namesMap.put("AM", "ئەرمەنستان");
    namesMap.put("AO", "ئەنگۆلا");
    namesMap.put("AQ", "ئانتارکتیکا");
    namesMap.put("AR", "ئەرژەنتین");
    namesMap.put("AS", "ساموای ئەمەریکایی");
    namesMap.put("AT", "نەمسا");
    namesMap.put("AU", "ئوسترالیا");
    namesMap.put("AW", "ئارووبا");
    namesMap.put("AX", "دوورگەکانی ئالاند");
    namesMap.put("AZ", "ئازەربایجان");
    namesMap.put("BA", "بۆسنیا و ھەرزەگۆڤینا");
    namesMap.put("BB", "باربادۆس");
    namesMap.put("BD", "بەنگلادیش");
    namesMap.put("BE", "بەلژیک");
    namesMap.put("BF", "بورکینافاسۆ");
    namesMap.put("BG", "بولگاریا");
    namesMap.put("BH", "بەحرەین");
    namesMap.put("BI", "بوروندی");
    namesMap.put("BJ", "بێنین");
    namesMap.put("BL", "سەن بارتێلێمی");
    namesMap.put("BM", "بێرموودا");
    namesMap.put("BN", "بروونای");
    namesMap.put("BO", "بۆلیڤیا");
    namesMap.put("BQ", "دوورگە کاریبیەکانی هۆڵەندا");
    namesMap.put("BR", "برازیل");
    namesMap.put("BS", "بەھاما");
    namesMap.put("BT", "بووتان");
    namesMap.put("BV", "دوورگەی بووڤێ");
    namesMap.put("BW", "بۆتسوانا");
    namesMap.put("BY", "بیلاڕووس");
    namesMap.put("BZ", "بەلیز");
    namesMap.put("CA", "کەنەدا");
    namesMap.put("CC", "دوورگەکانی کیلینگ");
    namesMap.put("CD", "کۆنگۆ کینشاسا");
    namesMap.put("CF", "کۆماری ئەفریقای ناوەڕاست");
    namesMap.put("CG", "کۆنگۆ برازاڤیل");
    namesMap.put("CH", "سویسڕا");
    namesMap.put("CI", "کۆتدیڤوار");
    namesMap.put("CK", "دوورگەکانی کوک");
    namesMap.put("CL", "چیلی");
    namesMap.put("CM", "کامیرۆن");
    namesMap.put("CN", "چین");
    namesMap.put("CO", "کۆلۆمبیا");
    namesMap.put("CP", "دوورگەی کلیپێرتۆن");
    namesMap.put("CR", "کۆستاریکا");
    namesMap.put("CU", "کووبا");
    namesMap.put("CV", "کەیپڤەرد");
    namesMap.put("CW", "کوراچاو");
    namesMap.put("CX", "دوورگەی کریسمس");
    namesMap.put("CY", "قیبرس");
    namesMap.put("CZ", "کۆماری چیک");
    namesMap.put("DE", "ئەڵمانیا");
    namesMap.put("DG", "دیەگۆ گارسیا");
    namesMap.put("DJ", "جیبووتی");
    namesMap.put("DK", "دانمارک");
    namesMap.put("DM", "دۆمینیکا");
    namesMap.put("DO", "کۆماری دۆمینیکا");
    namesMap.put("DZ", "جەزایر");
    namesMap.put("EA", "سێئووتا و مێلییا");
    namesMap.put("EC", "ئیکوادۆر");
    namesMap.put("EE", "ئیستۆنیا");
    namesMap.put("EG", "میسر");
    namesMap.put("EH", "سەحرای ڕۆژاوا");
    namesMap.put("ER", "ئەریتریا");
    namesMap.put("ES", "ئیسپانیا");
    namesMap.put("ET", "ئەتیۆپیا");
    namesMap.put("EU", "یەکێتیی ئەورووپا");
    namesMap.put("EZ", "ناوچەی یۆرۆ");
    namesMap.put("FI", "فینلاند");
    namesMap.put("FJ", "فیجی");
    namesMap.put("FK", "دوورگەکانی مالڤیناس");
    namesMap.put("FM", "مایکرۆنیزیا");
    namesMap.put("FO", "دوورگەکانی فارەو");
    namesMap.put("FR", "فەڕەنسا");
    namesMap.put("GA", "گابۆن");
    namesMap.put("GB", "شانشینی یەکگرتوو");
    namesMap.put("GD", "گرینادا");
    namesMap.put("GE", "گورجستان");
    namesMap.put("GF", "گیانای فەرەنسا");
    namesMap.put("GG", "گێرنزی");
    namesMap.put("GH", "غەنا");
    namesMap.put("GI", "گیبرالتار");
    namesMap.put("GL", "گرینلاند");
    namesMap.put("GM", "گامبیا");
    namesMap.put("GN", "گینێ");
    namesMap.put("GP", "گوادێلۆپ");
    namesMap.put("GQ", "گینێی ئیستوایی");
    namesMap.put("GR", "یۆنان");
    namesMap.put("GS", "دوورگەکانی جۆرجیا و ساندویچی باشوور");
    namesMap.put("GT", "گواتیمالا");
    namesMap.put("GU", "گوام");
    namesMap.put("GW", "گینێ بیساو");
    namesMap.put("GY", "گویانا");
    namesMap.put("HK", "هۆنگ کۆنگ");
    namesMap.put("HM", "دوورگەکانی هێرد و مەکدانڵد");
    namesMap.put("HN", "ھۆندووراس");
    namesMap.put("HR", "کرۆواتیا");
    namesMap.put("HT", "ھایتی");
    namesMap.put("HU", "هەنگاریا");
    namesMap.put("IC", "دوورگەکانی کەناری");
    namesMap.put("ID", "ئیندۆنیزیا");
    namesMap.put("IE", "ئیرلەند");
    namesMap.put("IL", "ئیسرائیل");
    namesMap.put("IM", "دوورگەی مان");
    namesMap.put("IN", "ھیندستان");
    namesMap.put("IO", "ھەرێمی بەریتانی لە ئۆقیانووسی ھیند");
    namesMap.put("IQ", "عێراق");
    namesMap.put("IR", "ئێران");
    namesMap.put("IS", "ئایسلەند");
    namesMap.put("IT", "ئیتالیا");
    namesMap.put("JE", "جێرسی");
    namesMap.put("JM", "جامایکا");
    namesMap.put("JO", "ئوردن");
    namesMap.put("JP", "ژاپۆن");
    namesMap.put("KE", "کینیا");
    namesMap.put("KG", "قرغیزستان");
    namesMap.put("KH", "کەمبۆدیا");
    namesMap.put("KI", "کیریباس");
    namesMap.put("KM", "دوورگەکانی کۆمۆر");
    namesMap.put("KN", "سەن کیتس و نیڤیس");
    namesMap.put("KP", "کۆریای باکوور");
    namesMap.put("KR", "کۆریای باشوور");
    namesMap.put("KW", "کوەیت");
    namesMap.put("KY", "دوورگەکانی کایمان");
    namesMap.put("KZ", "کازاخستان");
    namesMap.put("LA", "لاوس");
    namesMap.put("LB", "لوبنان");
    namesMap.put("LC", "سەن لووسیا");
    namesMap.put("LI", "لیختنشتاین");
    namesMap.put("LK", "سریلانکا");
    namesMap.put("LR", "لیبەریا");
    namesMap.put("LS", "لەسۆتۆ");
    namesMap.put("LT", "لیتوانایا");
    namesMap.put("LU", "لوکسەمبورگ");
    namesMap.put("LV", "لاتڤیا");
    namesMap.put("LY", "لیبیا");
    namesMap.put("MA", "مەغریب");
    namesMap.put("MC", "مۆناکۆ");
    namesMap.put("MD", "مۆلدۆڤا");
    namesMap.put("ME", "مۆنتینیگرۆ");
    namesMap.put("MF", "سەن مارتین");
    namesMap.put("MG", "ماداگاسکار");
    namesMap.put("MH", "دوورگەکانی مارشاڵ");
    namesMap.put("MK", "ماکەدۆنیا");
    namesMap.put("ML", "مالی");
    namesMap.put("MM", "میانمار");
    namesMap.put("MN", "مەنگۆلیا");
    namesMap.put("MO", "ماکائۆ");
    namesMap.put("MP", "دوورگەکانی ماریانای باکوور");
    namesMap.put("MQ", "مارتینیک");
    namesMap.put("MR", "مۆریتانیا");
    namesMap.put("MS", "مۆنتسێرات");
    namesMap.put("MT", "ماڵتا");
    namesMap.put("MU", "مووریتیووس");
    namesMap.put("MV", "مالدیڤ");
    namesMap.put("MW", "مالاوی");
    namesMap.put("MX", "مەکسیک");
    namesMap.put("MY", "مالیزیا");
    namesMap.put("MZ", "مۆزامبیک");
    namesMap.put("NA", "نامیبیا");
    namesMap.put("NC", "نیووکالێدۆنیا");
    namesMap.put("NE", "نیجەر");
    namesMap.put("NF", "دوورگەی نۆرفۆڵک");
    namesMap.put("NG", "نیجریا");
    namesMap.put("NI", "نیکاراگوا");
    namesMap.put("NL", "ھۆڵەندا");
    namesMap.put("NO", "نۆرویژ");
    namesMap.put("NP", "نیپال");
    namesMap.put("NR", "نائوروو");
    namesMap.put("NU", "نیووئی");
    namesMap.put("NZ", "نیوزیلاند");
    namesMap.put("OM", "عومان");
    namesMap.put("PA", "پاناما");
    namesMap.put("PE", "پێروو");
    namesMap.put("PF", "پۆلینیسیای فەرەنسا");
    namesMap.put("PG", "پاپوا گینێی نوێ");
    namesMap.put("PH", "فلیپین");
    namesMap.put("PK", "پاکستان");
    namesMap.put("PL", "پۆڵەندا");
    namesMap.put("PM", "سەن پیێر و میکێلۆن");
    namesMap.put("PN", "دوورگەکانی پیتکەرن");
    namesMap.put("PR", "پۆرتۆڕیکۆ");
    namesMap.put("PS", "ناوچە فەلەستینیەکان");
    namesMap.put("PT", "پورتوگال");
    namesMap.put("PW", "پالاو");
    namesMap.put("PY", "پاراگوای");
    namesMap.put("QA", "قەتەر");
    namesMap.put("QO", "دەرەوەی ئۆقیانووسیا");
    namesMap.put("RE", "ڕییوونیەن");
    namesMap.put("RO", "ڕۆمانیا");
    namesMap.put("RS", "سربیا");
    namesMap.put("RU", "ڕووسیا");
    namesMap.put("RW", "ڕواندا");
    namesMap.put("SA", "عەرەبستانی سەعوودی");
    namesMap.put("SB", "دوورگەکانی سلێمان");
    namesMap.put("SC", "سیشێل");
    namesMap.put("SD", "سوودان");
    namesMap.put("SE", "سوید");
    namesMap.put("SG", "سینگاپور");
    namesMap.put("SH", "سەن هێلێنا");
    namesMap.put("SI", "سلۆڤێنیا");
    namesMap.put("SJ", "سڤالبارد و یان مایەن");
    namesMap.put("SK", "سلۆڤاکیا");
    namesMap.put("SL", "سیەرالیۆن");
    namesMap.put("SM", "سان مارینۆ");
    namesMap.put("SN", "سێنێگاڵ");
    namesMap.put("SO", "سۆمالیا");
    namesMap.put("SR", "سورینام");
    namesMap.put("SS", "سوودانی باشوور");
    namesMap.put("ST", "ساوتۆمێ و پرینسیپی");
    namesMap.put("SV", "ئێلسالڤادۆر");
    namesMap.put("SX", "سینت مارتن");
    namesMap.put("SY", "سووریا");
    namesMap.put("SZ", "سوازیلاند");
    namesMap.put("TA", "تریستێن دا کوونا");
    namesMap.put("TC", "دوورگەکانی تورکس و کایکۆس");
    namesMap.put("TD", "چاد");
    namesMap.put("TF", "هەرێمە باشووریەکانی فەرەنسا");
    namesMap.put("TG", "تۆگۆ");
    namesMap.put("TH", "تایلەند");
    namesMap.put("TJ", "تاجیکستان");
    namesMap.put("TK", "تۆکێلاو");
    namesMap.put("TL", "تیمۆری ڕۆژھەڵات");
    namesMap.put("TM", "تورکمانستان");
    namesMap.put("TN", "توونس");
    namesMap.put("TO", "تۆنگا");
    namesMap.put("TR", "تورکیا");
    namesMap.put("TT", "ترینیداد و تۆباگو");
    namesMap.put("TV", "تووڤالوو");
    namesMap.put("TW", "تایوان");
    namesMap.put("TZ", "تانزانیا");
    namesMap.put("UA", "ئۆکرانیا");
    namesMap.put("UG", "ئوگاندا");
    namesMap.put("UM", "دوورگەکانی دەرەوەی ئەمریکا");
    namesMap.put("UN", "نەتەوە یەکگرتووەکان");
    namesMap.put("US", "ویلایەتە یەکگرتووەکان");
    namesMap.put("UY", "ئوروگوای");
    namesMap.put("UZ", "ئوزبەکستان");
    namesMap.put("VA", "ڤاتیکان");
    namesMap.put("VC", "سەینت ڤینسەنت و گرینادینز");
    namesMap.put("VE", "ڤەنزوێلا");
    namesMap.put("VG", "دوورگەکانی ڤیرجنی بەریتانیا");
    namesMap.put("VI", "دوورگەکانی ڤیرجنی ئەمەریکا");
    namesMap.put("VN", "ڤیەتنام");
    namesMap.put("VU", "ڤانوواتوو");
    namesMap.put("WF", "والیس و فوتونا");
    namesMap.put("WS", "ساموا");
    namesMap.put("XK", "کۆسۆڤۆ");
    namesMap.put("YE", "یەمەن");
    namesMap.put("YT", "مایۆت");
    namesMap.put("ZA", "ئەفریقای باشوور");
    namesMap.put("ZM", "زامبیا");
    namesMap.put("ZW", "زیمبابوی");
    namesMap.put("ZZ", "ناوچەی نەناسراو");
  }

}
