/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "lag" locale.
 */
public class LocalizedNamesImpl_lag extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "IS",
        "AR",
        "DZ",
        "AL",
        "US",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "IE",
        "AZ",
        "BB",
        "BS",
        "BH",
        "BD",
        "BY",
        "BZ",
        "BJ",
        "BM",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "MG",
        "BF",
        "BG",
        "BN",
        "BI",
        "BT",
        "BV",
        "CC",
        "TD",
        "CL",
        "CN",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "SV",
        "ER",
        "EE",
        "EU",
        "EZ",
        "FJ",
        "FO",
        "GH",
        "GA",
        "GM",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GD",
        "GL",
        "GS",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "ES",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "EC",
        "IM",
        "IN",
        "ID",
        "IQ",
        "IL",
        "IT",
        "CI",
        "JM",
        "CZ",
        "DO",
        "CD",
        "JP",
        "JE",
        "GI",
        "DJ",
        "JO",
        "GE",
        "CF",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CV",
        "KI",
        "KG",
        "NF",
        "CO",
        "KM",
        "CG",
        "KR",
        "KP",
        "HR",
        "CR",
        "CY",
        "CU",
        "KW",
        "LA",
        "LU",
        "LV",
        "LB",
        "LS",
        "LY",
        "LR",
        "LI",
        "LT",
        "ML",
        "MW",
        "MY",
        "MT",
        "MQ",
        "MK",
        "YT",
        "ME",
        "MX",
        "MF",
        "MM",
        "FM",
        "EG",
        "MO",
        "MV",
        "MD",
        "MC",
        "MN",
        "MS",
        "MU",
        "MR",
        "MA",
        "MZ",
        "PS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NZ",
        "OM",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PN",
        "PE",
        "PL",
        "PF",
        "PR",
        "QO",
        "RE",
        "RO",
        "RS",
        "RW",
        "SM",
        "ZM",
        "WS",
        "AS",
        "ST",
        "SA",
        "SN",
        "SL",
        "SC",
        "ZW",
        "SG",
        "SY",
        "LK",
        "SJ",
        "SO",
        "SS",
        "SD",
        "SK",
        "SI",
        "SR",
        "SX",
        "TA",
        "TZ",
        "TH",
        "TW",
        "TJ",
        "TF",
        "TL",
        "TT",
        "TK",
        "TG",
        "TO",
        "TN",
        "TV",
        "FI",
        "PH",
        "GR",
        "UM",
        "UN",
        "UY",
        "RU",
        "UZ",
        "SE",
        "CH",
        "TM",
        "TR",
        "VU",
        "VA",
        "VE",
        "VN",
        "FK",
        "KY",
        "CK",
        "MH",
        "SB",
        "TC",
        "VI",
        "VG",
        "MP",
        "WF",
        "XA",
        "XB",
        "XK",
        "YE",
        "IO",
        "IR",
        "BE",
        "FR",
        "UG",
        "ET",
        "NL",
        "DE",
        "UA",
        "PT",
        "SZ",
        "AE",
        "GB",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AD", "Andóra");
    namesMap.put("AE", "Ʉtemi wa Kɨaráabu");
    namesMap.put("AF", "Afuganisitáani");
    namesMap.put("AG", "Antigúua na Baribúuda");
    namesMap.put("AI", "Anguíila");
    namesMap.put("AL", "Alubánia");
    namesMap.put("AM", "Ariménia");
    namesMap.put("AO", "Angóola");
    namesMap.put("AR", "Ajentíina");
    namesMap.put("AS", "Samóoa ya Amerɨ́ka");
    namesMap.put("AT", "Áusitiria");
    namesMap.put("AU", "Ausiteréelia");
    namesMap.put("AW", "Arúuba");
    namesMap.put("AZ", "Azabajáani");
    namesMap.put("BA", "Bósinia");
    namesMap.put("BB", "Babadóosi");
    namesMap.put("BD", "Bangaladéeshi");
    namesMap.put("BE", "Ʉbeligíiji");
    namesMap.put("BF", "Bukinafáaso");
    namesMap.put("BG", "Buligaría");
    namesMap.put("BH", "Baharéeni");
    namesMap.put("BI", "Burúundi");
    namesMap.put("BJ", "Beníini");
    namesMap.put("BM", "Berimúuda");
    namesMap.put("BN", "Burunéei");
    namesMap.put("BO", "Bolívia");
    namesMap.put("BR", "Brasíili");
    namesMap.put("BS", "Baháama");
    namesMap.put("BT", "Butáani");
    namesMap.put("BW", "Botiswáana");
    namesMap.put("BY", "Belarúusi");
    namesMap.put("BZ", "Belíise");
    namesMap.put("CA", "Kánada");
    namesMap.put("CD", "Jamuhúuri ya Kɨdemokurasía ya Kóongo");
    namesMap.put("CF", "Juhúuri ya Afɨrɨka ya katɨ katɨ");
    namesMap.put("CG", "Kóongo");
    namesMap.put("CH", "Uswíisi");
    namesMap.put("CI", "Ivori Kositi");
    namesMap.put("CK", "Visíiwa vya Kúuku");
    namesMap.put("CL", "Chíile");
    namesMap.put("CM", "Kamerúuni");
    namesMap.put("CN", "Chíina");
    namesMap.put("CO", "Kolómbia");
    namesMap.put("CR", "Kósita Rɨ́ɨka");
    namesMap.put("CU", "Kyúuba");
    namesMap.put("CV", "Kepuvéede");
    namesMap.put("CY", "Kupuróosi");
    namesMap.put("CZ", "Jamuhúuri ya Chéeki");
    namesMap.put("DE", "Ʉjerumáani");
    namesMap.put("DJ", "Jibúuti");
    namesMap.put("DK", "Denimaki");
    namesMap.put("DM", "Domínɨka");
    namesMap.put("DO", "Jamuhúuri ya Dominɨka");
    namesMap.put("DZ", "Alijéria");
    namesMap.put("EC", "Íkwado");
    namesMap.put("EE", "Estonía");
    namesMap.put("EG", "Mísiri");
    namesMap.put("ER", "Eriterea");
    namesMap.put("ES", "Hisipánia");
    namesMap.put("ET", "Ʉhabéeshi");
    namesMap.put("FI", "Ufíini");
    namesMap.put("FJ", "Fíiji");
    namesMap.put("FK", "Visíiwa vya Fakulandi");
    namesMap.put("FM", "Mikironésia");
    namesMap.put("FR", "Ʉfaráansa");
    namesMap.put("GA", "Gabóoni");
    namesMap.put("GB", "Ʉɨngeréesa");
    namesMap.put("GD", "Girenáada");
    namesMap.put("GE", "Jójia");
    namesMap.put("GF", "Gwiyáana yʉ Ʉfaráansa");
    namesMap.put("GH", "Gáana");
    namesMap.put("GI", "Jiburálita");
    namesMap.put("GL", "Giriniláandi");
    namesMap.put("GM", "Gámbia");
    namesMap.put("GN", "Gíine");
    namesMap.put("GP", "Gwadelúupe");
    namesMap.put("GQ", "Gíine Ikwéeta");
    namesMap.put("GR", "Ugiríki");
    namesMap.put("GT", "Gwatemáala");
    namesMap.put("GU", "Gwani");
    namesMap.put("GW", "Gíine Bisáau");
    namesMap.put("GY", "Guyáana");
    namesMap.put("HN", "Honduráasi");
    namesMap.put("HR", "Koréshia");
    namesMap.put("HT", "Haíiti");
    namesMap.put("HU", "Hungária");
    namesMap.put("ID", "Indonésia");
    namesMap.put("IE", "Ayaláandi");
    namesMap.put("IL", "Isiraéeli");
    namesMap.put("IN", "Índia");
    namesMap.put("IO", "Ɨsɨ yʉ Ʉɨngeréesa irivii ra Híindi");
    namesMap.put("IQ", "Iráaki");
    namesMap.put("IR", "Ʉajéemi");
    namesMap.put("IS", "Aisiláandi");
    namesMap.put("IT", "Itália");
    namesMap.put("JM", "Jamáika");
    namesMap.put("JO", "Jódani");
    namesMap.put("JP", "Japáani");
    namesMap.put("KE", "Kéenya");
    namesMap.put("KG", "Kirigisitáani");
    namesMap.put("KH", "Kambódia");
    namesMap.put("KI", "Kiribáati");
    namesMap.put("KM", "Komóoro");
    namesMap.put("KN", "Mʉtakatíifu kitisi na Nevíisi");
    namesMap.put("KP", "Koréa yʉ ʉtʉrʉko");
    namesMap.put("KR", "Koréa ya Saame");
    namesMap.put("KW", "Kʉwáiti");
    namesMap.put("KY", "Visíiwa vya Kayimani");
    namesMap.put("KZ", "Kazakasitáani");
    namesMap.put("LA", "Laóosi");
    namesMap.put("LB", "Lebanóoni");
    namesMap.put("LC", "Mʉtakatíifu Lusíia");
    namesMap.put("LI", "Lishentéeni");
    namesMap.put("LK", "Siriláanka");
    namesMap.put("LR", "Liibéria");
    namesMap.put("LS", "Lesóoto");
    namesMap.put("LT", "Lisuánia");
    namesMap.put("LU", "Lasembáagi");
    namesMap.put("LV", "Lativia");
    namesMap.put("LY", "Líbia");
    namesMap.put("MA", "Moróoko");
    namesMap.put("MC", "Monáako");
    namesMap.put("MD", "Molidóova");
    namesMap.put("MG", "Bukíini");
    namesMap.put("MH", "Visíiwa vya Marisháali");
    namesMap.put("MK", "Masedónia");
    namesMap.put("ML", "Máali");
    namesMap.put("MM", "Miáama");
    namesMap.put("MN", "Mongólia");
    namesMap.put("MP", "Visiwa vya Mariana vya Kaskazini");
    namesMap.put("MQ", "Maritiníiki");
    namesMap.put("MR", "Moritánia");
    namesMap.put("MS", "Monteráati");
    namesMap.put("MT", "Málita");
    namesMap.put("MU", "Moríisi");
    namesMap.put("MV", "Modíivu");
    namesMap.put("MW", "Maláawi");
    namesMap.put("MX", "Mekisiko");
    namesMap.put("MY", "Maleísia");
    namesMap.put("MZ", "Musumbíiji");
    namesMap.put("NA", "Namíbia");
    namesMap.put("NC", "Kaledónia Ifya");
    namesMap.put("NE", "Níija");
    namesMap.put("NF", "Kisíiwa cha Nofifóoki");
    namesMap.put("NG", "Niijéria");
    namesMap.put("NI", "Nikarágʉa");
    namesMap.put("NL", "Ʉholáanzi");
    namesMap.put("NO", "Norwe");
    namesMap.put("NP", "Nepáali");
    namesMap.put("NR", "Naúuru");
    namesMap.put("NU", "Niúue");
    namesMap.put("NZ", "Nyuzílandi");
    namesMap.put("OM", "Ómani");
    namesMap.put("PA", "Panáama");
    namesMap.put("PE", "Péeru");
    namesMap.put("PF", "Polinésia yʉ Ʉfaráansa");
    namesMap.put("PG", "Papúua");
    namesMap.put("PH", "Ufilipíino");
    namesMap.put("PK", "Pakisitáani");
    namesMap.put("PL", "Pólandi");
    namesMap.put("PM", "Mʉtakatíifu Peéteri na Mɨkaéeli");
    namesMap.put("PN", "Patikaírini");
    namesMap.put("PR", "Pwetorɨ́ɨko");
    namesMap.put("PS", "Mweemberera wa kʉmweeri wa Gáaza");
    namesMap.put("PT", "Ʉréeno");
    namesMap.put("PW", "Paláau");
    namesMap.put("PY", "Paraguáai");
    namesMap.put("QA", "Katáari");
    namesMap.put("RE", "Reyunióoni");
    namesMap.put("RO", "Romaníia");
    namesMap.put("RU", "Urúusi");
    namesMap.put("RW", "Rwáanda");
    namesMap.put("SA", "Saudíia Arabíia");
    namesMap.put("SB", "Visíiwa vya Solomóoni");
    namesMap.put("SC", "Shelishéeli");
    namesMap.put("SD", "Sudáani");
    namesMap.put("SE", "Uswíidi");
    namesMap.put("SG", "Singapoo");
    namesMap.put("SH", "Mʉtakatíifu Heléena");
    namesMap.put("SI", "Sulovénia");
    namesMap.put("SK", "Sulováakia");
    namesMap.put("SL", "Seraleóoni");
    namesMap.put("SM", "Samaríino");
    namesMap.put("SN", "Senegáali");
    namesMap.put("SO", "Somália");
    namesMap.put("SR", "Surináamu");
    namesMap.put("ST", "Sao Tóome na Pirinsipe");
    namesMap.put("SV", "Elisalivado");
    namesMap.put("SY", "Síria");
    namesMap.put("SZ", "Ʉswáazi");
    namesMap.put("TC", "Visíiwa vya Turíiki na Kaíiko");
    namesMap.put("TD", "Cháadi");
    namesMap.put("TG", "Tóogo");
    namesMap.put("TH", "Táilandi");
    namesMap.put("TJ", "Tajikisitáani");
    namesMap.put("TK", "Tokeláau");
    namesMap.put("TL", "Timóori yi Itʉʉmba");
    namesMap.put("TM", "Uturukimenisitáani");
    namesMap.put("TN", "Tunísia");
    namesMap.put("TO", "Tóonga");
    namesMap.put("TR", "Uturúuki");
    namesMap.put("TT", "Tiriníida ya Tobáago");
    namesMap.put("TV", "Tuváalu");
    namesMap.put("TW", "Taiwáani");
    namesMap.put("TZ", "Taansanía");
    namesMap.put("UA", "Ʉkɨréeni");
    namesMap.put("UG", "Ʉgáanda");
    namesMap.put("US", "Amerɨka");
    namesMap.put("UY", "Uruguáai");
    namesMap.put("UZ", "Usibekisitáani");
    namesMap.put("VA", "Vatikáani");
    namesMap.put("VC", "Mʉtakatíifu Viséenti na Gernadíini");
    namesMap.put("VE", "Venezuéela");
    namesMap.put("VG", "Visíiwa vya Vigíini vya Ʉɨngeréesa");
    namesMap.put("VI", "Visíiwa vya Vigíini vya Amerɨ́ka");
    namesMap.put("VN", "Vietináamu");
    namesMap.put("VU", "Vanuáatu");
    namesMap.put("WF", "Walíisi na Futúuna");
    namesMap.put("WS", "Samóoa");
    namesMap.put("YE", "Yémeni");
    namesMap.put("YT", "Mayóote");
    namesMap.put("ZA", "Afɨrɨka ya Saame");
    namesMap.put("ZM", "Sámbia");
    namesMap.put("ZW", "Simbáabwe");
  }

}
