/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.serialization;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.AbstractJsonMapperGenerator;
import org.dominokit.jacksonapt.processor.AbstractMapperProcessor;
import org.dominokit.jacksonapt.processor.serialization.SerializerBuilder;
import org.dominokit.jacksonapt.ser.bean.AbstractBeanJsonSerializer;
import org.dominokit.jacksonapt.ser.bean.BeanPropertySerializer;

public class AptSerializerBuilder
extends AbstractJsonMapperGenerator {
    public AptSerializerBuilder(TypeMirror beanType, Filer filer) {
        super(beanType, filer);
    }

    @Override
    protected TypeName superClass() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(AbstractBeanJsonSerializer.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)this.beanType)});
    }

    @Override
    protected String namePostfix() {
        return "BeanJsonSerializerImpl";
    }

    @Override
    protected String targetTypeMethodName() {
        return "getSerializedType";
    }

    @Override
    protected MethodSpec initMethod() {
        return this.buildInitSerializersMethod(this.beanType);
    }

    private MethodSpec buildInitSerializersMethod(TypeMirror beanType) {
        int[] index = new int[]{0};
        List<Element> fields = this.orderedFields();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initSerializers").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns(TypeName.get(BeanPropertySerializer[].class)).addStatement("$T result = new $T[$L]", new Object[]{ArrayTypeName.of(BeanPropertySerializer.class), BeanPropertySerializer.class, fields.size()});
        fields.stream().filter(this::isEligibleForSerializationDeserialization).forEach(field -> {
            Object[] objectArray = new Object[2];
            int n = index[0];
            index[0] = n + 1;
            objectArray[0] = n;
            objectArray[1] = new SerializerBuilder(AbstractMapperProcessor.typeUtils, beanType, (Element)field).buildSerializer();
            builder.addStatement("result[$L] = $L", objectArray);
        });
        builder.addStatement("return result", new Object[0]);
        return builder.build();
    }
}

