/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "dz" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_dz extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "སྔ་ཆ་",
        "ཕྱི་ཆ་"
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, སྤྱི་ལོ་y MMMM ཚེས་dd";
  }

  @Override
  public String dateFormatLong() {
    return "སྤྱི་ལོ་y MMMM ཚེས་ dd";
  }

  @Override
  public String dateFormatMedium() {
    return "སྤྱི་ལོ་y ཟླ་MMM ཚེས་dd";
  }

  @Override
  public String dateFormatShort() {
    return "y-MM-dd";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "BCE",
        "CE"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "BCE",
        "CE"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "ཆུ་ཚོད་ h སྐར་མ་ mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "ཆུ་ཚོད་h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "སྤྱི་LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "སྤྱི་LLL ཚེ་d";
  }

  @Override
  public String formatMonthFull() {
    return "སྤྱི་LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "MMMM d";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, སྤྱི་LLLL ཚེ་d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M-d";
  }

  @Override
  public String formatYear() {
    return "y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y སྤྱི་ཟླ་MMM";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y MMM d";
  }

  @Override
  public String formatYearMonthFull() {
    return "y MMMM";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "སྤྱི་ལོ་y MMMM ཚེས་ d";
  }

  @Override
  public String formatYearMonthNum() {
    return "y-M";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y-M-d";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "གཟའ་EEE, ལོy ཟླ་MMM ཚེ་d";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "ཟླ་དངཔ་",
        "ཟླ་གཉིས་པ་",
        "ཟླ་གསུམ་པ་",
        "ཟླ་བཞི་པ་",
        "ཟླ་ལྔ་པ་",
        "ཟླ་དྲུག་པ",
        "ཟླ་བདུན་པ་",
        "ཟླ་བརྒྱད་པ་",
        "ཟླ་དགུ་པ་",
        "ཟླ་བཅུ་པ་",
        "ཟླ་བཅུ་གཅིག་པ་",
        "ཟླ་བཅུ་གཉིས་པ་"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "སྤྱི་ཟླ་དངཔ་",
        "སྤྱི་ཟླ་གཉིས་པ་",
        "སྤྱི་ཟླ་གསུམ་པ་",
        "སྤྱི་ཟླ་བཞི་པ",
        "སྤྱི་ཟླ་ལྔ་པ་",
        "སྤྱི་ཟླ་དྲུག་པ",
        "སྤྱི་ཟླ་བདུན་པ་",
        "སྤྱི་ཟླ་བརྒྱད་པ་",
        "སྤྱི་ཟླ་དགུ་པ་",
        "སྤྱི་ཟླ་བཅུ་པ་",
        "སྤྱི་ཟླ་བཅུ་གཅིག་པ་",
        "སྤྱི་ཟླ་བཅུ་གཉིས་པ་"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "༡",
        "༢",
        "༣",
        "4",
        "༥",
        "༦",
        "༧",
        "༨",
        "9",
        "༡༠",
        "༡༡",
        "༡༢"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return new String[] {
        "༡",
        "༢",
        "༣",
        "༤",
        "༥",
        "༦",
        "༧",
        "༨",
        "༩",
        "༡༠",
        "༡༡",
        "༡༢"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "༡",
        "༢",
        "༣",
        "༤",
        "༥",
        "༦",
        "༧",
        "༨",
        "༩",
        "༡༠",
        "༡༡",
        "12"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "ཟླ་༡",
        "ཟླ་༢",
        "ཟླ་༣",
        "ཟླ་༤",
        "ཟླ་༥",
        "ཟླ་༦",
        "ཟླ་༧",
        "ཟླ་༨",
        "ཟླ་༩",
        "ཟླ་༡༠",
        "ཟླ་༡༡",
        "ཟླ་༡༢"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "བཞི་དཔྱ་དང་པ་",
        "བཞི་དཔྱ་གཉིས་པ་",
        "བཞི་དཔྱ་གསུམ་པ་",
        "བཞི་དཔྱ་བཞི་པ་"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "བཞི་དཔྱ་༡",
        "བཞི་དཔྱ་༢",
        "བཞི་དཔྱ་༣",
        "བཞི་དཔྱ་༤"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "ཆུ་ཚོད་ h སྐར་མ་ mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "ཆུ་ཚོད་ h སྐར་མ་ mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "ཆུ་ཚོད་h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "ཆུ་ཚོད་ h སྐར་མ་ mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "གཟའ་ཟླ་བ་",
        "གཟའ་མིག་དམར་",
        "གཟའ་ལྷག་པ་",
        "གཟའ་ཕུར་བུ་",
        "གཟའ་པ་སངས་",
        "གཟའ་སྤེན་པ་",
        "གཟའ་ཉི་མ་"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return weekdaysFull();
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "ཟླ",
        "མིར",
        "ལྷག",
        "ཕུར",
        "སངྶ",
        "སྤེན",
        "ཉི"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ཟླ་",
        "མིར་",
        "ལྷག་",
        "ཕུར་",
        "སངས་",
        "སྤེན་",
        "ཉི་"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }

  @Override
  public int weekendEnd() {
    return 0;
  }

  @Override
  public int weekendStart() {
    return 6;
  }
}
