/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.client.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ccp" locale.
 */
public class LocalizedNamesImpl_ccp extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "EZ",
        "XA",
        "XB",
        "QO",
        "AU",
        "AZ",
        "AD",
        "AF",
        "AS",
        "IE",
        "AW",
        "AR",
        "DZ",
        "AM",
        "AX",
        "CO",
        "AL",
        "AT",
        "UA",
        "ET",
        "YE",
        "LR",
        "CI",
        "IM",
        "IS",
        "OM",
        "AO",
        "AQ",
        "AC",
        "EU",
        "EC",
        "IL",
        "IT",
        "ID",
        "IQ",
        "IR",
        "ER",
        "AI",
        "UG",
        "UZ",
        "MP",
        "KP",
        "UY",
        "EE",
        "AG",
        "SV",
        "KZ",
        "QA",
        "CA",
        "CD",
        "CG",
        "KM",
        "KH",
        "XK",
        "CU",
        "CW",
        "KI",
        "KG",
        "EA",
        "CK",
        "KW",
        "KE",
        "CV",
        "KY",
        "CC",
        "CR",
        "IC",
        "CM",
        "BQ",
        "CX",
        "HR",
        "CP",
        "GM",
        "GN",
        "GW",
        "GY",
        "GT",
        "GP",
        "GU",
        "GA",
        "GG",
        "GR",
        "GL",
        "GD",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "UN",
        "JP",
        "JM",
        "ZM",
        "DE",
        "JE",
        "AE",
        "GB",
        "UM",
        "GE",
        "JO",
        "DJ",
        "GI",
        "ZW",
        "TV",
        "TK",
        "TG",
        "TO",
        "TA",
        "DK",
        "DM",
        "DO",
        "TJ",
        "TZ",
        "TN",
        "TL",
        "TR",
        "TC",
        "TM",
        "TW",
        "TT",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "DG",
        "NR",
        "NA",
        "NO",
        "NZ",
        "NU",
        "NI",
        "GQ",
        "NF",
        "NL",
        "NP",
        "NE",
        "NG",
        "NC",
        "PK",
        "PA",
        "PG",
        "PW",
        "EH",
        "PT",
        "PN",
        "PR",
        "PE",
        "PL",
        "PY",
        "TF",
        "FK",
        "GF",
        "PF",
        "FJ",
        "FI",
        "PS",
        "PH",
        "FO",
        "FR",
        "BD",
        "BB",
        "BM",
        "BS",
        "BH",
        "BW",
        "BO",
        "BA",
        "BI",
        "BF",
        "BG",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "VU",
        "IN",
        "VN",
        "BT",
        "VE",
        "VA",
        "MG",
        "MM",
        "YT",
        "US",
        "VI",
        "MQ",
        "MH",
        "MW",
        "ML",
        "MT",
        "MV",
        "MY",
        "MN",
        "CF",
        "ME",
        "MS",
        "MR",
        "MU",
        "EG",
        "MX",
        "FM",
        "MZ",
        "MC",
        "MA",
        "MD",
        "MO",
        "MK",
        "RU",
        "RE",
        "RW",
        "RO",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LU",
        "LB",
        "LS",
        "WF",
        "ST",
        "SM",
        "WS",
        "RS",
        "SJ",
        "SB",
        "SG",
        "SX",
        "SL",
        "SY",
        "SC",
        "SD",
        "SR",
        "SN",
        "KN",
        "PM",
        "BL",
        "VC",
        "MF",
        "LC",
        "SH",
        "CY",
        "CH",
        "SE",
        "SO",
        "SZ",
        "SA",
        "ES",
        "LK",
        "SK",
        "SI",
        "HM",
        "HK",
        "HU",
        "HN",
        "HT",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "𑄛𑄨𑄖𑄴𑄗𑄨𑄟𑄨");
    namesMap.put("002", "𑄃𑄜𑄳𑄢𑄨𑄇");
    namesMap.put("003", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇");
    namesMap.put("005", "𑄘𑄨𑄉𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇");
    namesMap.put("009", "𑄃𑄮𑄥𑄨𑄠𑄚𑄨𑄠");
    namesMap.put("011", "𑄛𑄧𑄏𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇");
    namesMap.put("013", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇");
    namesMap.put("014", "𑄛𑄪𑄇𑄴𑄘𑄩 𑄃𑄜𑄳𑄢𑄨𑄇");
    namesMap.put("015", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄜𑄳𑄢𑄨𑄇");
    namesMap.put("017", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇");
    namesMap.put("018", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇 𑄎𑄉");
    namesMap.put("019", "𑄃𑄟𑄬𑄢𑄨𑄇𑄥𑄴");
    namesMap.put("021", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄎𑄉𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇");
    namesMap.put("029", "𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴");
    namesMap.put("030", "𑄛𑄪𑄉𑄬𑄘𑄩 𑄃𑄬𑄥𑄨𑄠");
    namesMap.put("034", "𑄘𑄧𑄉𑄨𑄚𑄬 𑄃𑄬𑄥𑄨𑄠");
    namesMap.put("035", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄛𑄪𑄇𑄴 𑄃𑄬𑄥𑄨𑄠");
    namesMap.put("039", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴");
    namesMap.put("053", "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄣𑄬𑄥𑄨𑄠");
    namesMap.put("054", "𑄟𑄳𑄠𑄣𑄬𑄚𑄬𑄥𑄨𑄠");
    namesMap.put("057", "𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠 𑄎𑄉");
    namesMap.put("061", "𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠");
    namesMap.put("142", "𑄃𑄬𑄥𑄨𑄠");
    namesMap.put("143", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄬𑄥𑄨𑄠");
    namesMap.put("145", "𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄬𑄥𑄨𑄠");
    namesMap.put("150", "𑄄𑄃𑄪𑄢𑄮𑄛𑄴");
    namesMap.put("151", "𑄛𑄪𑄉𑄬𑄘𑄨 𑄄𑄃𑄪𑄢𑄮𑄛𑄴");
    namesMap.put("154", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴");
    namesMap.put("155", "𑄛𑄧𑄎𑄨𑄟𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴");
    namesMap.put("419", "𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇");
    namesMap.put("AC", "𑄃𑄳𑄠𑄥𑄴𑄥𑄬𑄚𑄴𑄥𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("AD", "𑄃𑄚𑄴𑄓𑄮𑄢");
    namesMap.put("AE", "𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴");
    namesMap.put("AF", "𑄃𑄛𑄴𑄉𑄚𑄨𑄌𑄴𑄖𑄚𑄴");
    namesMap.put("AG", "𑄆𑄚𑄴𑄖𑄨𑄉𑄱 𑄃𑄮 𑄝𑄢𑄴𑄟𑄪𑄓");
    namesMap.put("AI", "𑄄𑄳𑄠𑄋𑄴𑄉𑄪𑄃𑄨𑄣");
    namesMap.put("AL", "𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠");
    namesMap.put("AM", "𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠");
    namesMap.put("AO", "𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣");
    namesMap.put("AQ", "𑄃𑄳𑄠𑄚𑄴𑄑𑄢𑄴𑄇𑄧𑄑𑄨𑄇");
    namesMap.put("AR", "𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚");
    namesMap.put("AS", "𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄟𑄮𑄠");
    namesMap.put("AT", "𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠");
    namesMap.put("AU", "𑄃𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠");
    namesMap.put("AW", "𑄃𑄢𑄪𑄝");
    namesMap.put("AX", "𑄃𑄣𑄚𑄴𑄓𑄧 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("AZ", "𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴");
    namesMap.put("BA", "𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄮 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚");
    namesMap.put("BB", "𑄝𑄢𑄴𑄝𑄘𑄮𑄌𑄴");
    namesMap.put("BD", "𑄝𑄁𑄣𑄘𑄬𑄌𑄴");
    namesMap.put("BE", "𑄝𑄬𑄣𑄴𑄎𑄨𑄠𑄟𑄴");
    namesMap.put("BF", "𑄝𑄪𑄢𑄴𑄇𑄨𑄚 𑄜𑄥𑄮");
    namesMap.put("BG", "𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠");
    namesMap.put("BH", "𑄝𑄦𑄧𑄢𑄭𑄚𑄴");
    namesMap.put("BI", "𑄝𑄪𑄢𑄪𑄚𑄴𑄘𑄨");
    namesMap.put("BJ", "𑄝𑄬𑄚𑄨𑄚𑄴");
    namesMap.put("BL", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄝𑄢𑄴𑄗𑄬𑄣𑄨𑄟𑄨");
    namesMap.put("BM", "𑄝𑄢𑄴𑄟𑄪𑄓");
    namesMap.put("BN", "𑄝𑄳𑄢𑄪𑄚𑄬𑄭");
    namesMap.put("BO", "𑄝𑄧𑄣𑄨𑄞𑄨𑄠");
    namesMap.put("BQ", "𑄇𑄳𑄠𑄢𑄨𑄝𑄨𑄠𑄚𑄴 𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄧𑄥𑄴");
    namesMap.put("BR", "𑄝𑄳𑄢𑄎𑄨𑄣𑄴");
    namesMap.put("BS", "𑄝𑄦𑄟 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("BT", "𑄞𑄪𑄑𑄚𑄴");
    namesMap.put("BV", "𑄝𑄮𑄞𑄬𑄑𑄴 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("BW", "𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚");
    namesMap.put("BY", "𑄝𑄬𑄣𑄢𑄪𑄌𑄴");
    namesMap.put("BZ", "𑄝𑄬𑄣𑄨𑄎𑄴");
    namesMap.put("CA", "𑄇𑄚𑄓");
    namesMap.put("CC", "𑄇𑄮𑄇𑄮𑄌𑄴 (𑄇𑄨𑄣𑄨𑄁) 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("CD", "𑄇𑄧𑄋𑄴𑄉𑄮-𑄚𑄨𑄇𑄴𑄥𑄥");
    namesMap.put("CF", "𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇𑄢𑄴𑄛𑄳𑄢𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧");
    namesMap.put("CG", "𑄇𑄧𑄋𑄴𑄉𑄮-𑄝𑄳𑄢𑄎𑄞𑄨𑄣𑄴");
    namesMap.put("CH", "𑄥𑄭𑄪𑄎𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("CI", "𑄃𑄭𑄞𑄧𑄢𑄨 𑄇𑄮𑄌𑄴𑄑𑄴");
    namesMap.put("CK", "𑄇𑄪𑄇𑄪 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("CL", "𑄌𑄨𑄣𑄨");
    namesMap.put("CM", "𑄇𑄳𑄠𑄟𑄬𑄢𑄪𑄚𑄴");
    namesMap.put("CN", "𑄌𑄩𑄚𑄴");
    namesMap.put("CO", "𑄃𑄣𑄧𑄟𑄴𑄝𑄨𑄠");
    namesMap.put("CP", "𑄇𑄳𑄣𑄨𑄛𑄢𑄴𑄑𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄳𑄓𑄴");
    namesMap.put("CR", "𑄇𑄮𑄥𑄳𑄑𑄢𑄨𑄇");
    namesMap.put("CU", "𑄇𑄨𑄃𑄪𑄝");
    namesMap.put("CV", "𑄇𑄬𑄛𑄴𑄞𑄢𑄴𑄘𑄬");
    namesMap.put("CW", "𑄇𑄨𑄃𑄪𑄢𑄥𑄃𑄮");
    namesMap.put("CX", "𑄇𑄳𑄢𑄨𑄥𑄴𑄟𑄥𑄴 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("CY", "𑄥𑄭𑄛𑄳𑄢𑄥𑄴");
    namesMap.put("CZ", "𑄌𑄬𑄌𑄨𑄠");
    namesMap.put("DE", "𑄎𑄢𑄴𑄟𑄚𑄨");
    namesMap.put("DG", "𑄘𑄨𑄠𑄬𑄉𑄮 𑄉𑄢𑄴𑄥𑄨𑄠");
    namesMap.put("DJ", "𑄎𑄨𑄝𑄪𑄖𑄨");
    namesMap.put("DK", "𑄓𑄬𑄚𑄴𑄟𑄢𑄴𑄇𑄧");
    namesMap.put("DM", "𑄓𑄮𑄟𑄨𑄚𑄨𑄇");
    namesMap.put("DO", "𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧");
    namesMap.put("DZ", "𑄃𑄢𑄴𑄎𑄬𑄢𑄨𑄠");
    namesMap.put("EA", "𑄇𑄪𑄃𑄪𑄑 𑄃𑄳𑄃 𑄟𑄬𑄣𑄨𑄣");
    namesMap.put("EC", "𑄄𑄇𑄪𑄠𑄬𑄓𑄧𑄢𑄴");
    namesMap.put("EE", "𑄆𑄌𑄴𑄖𑄮𑄚𑄨𑄠");
    namesMap.put("EG", "𑄟𑄨𑄥𑄧𑄢𑄴");
    namesMap.put("EH", "𑄛𑄧𑄎𑄨𑄟𑄴 𑄥𑄦𑄢");
    namesMap.put("ER", "𑄄𑄢𑄨𑄖𑄳𑄢𑄨𑄠");
    namesMap.put("ES", "𑄥𑄳𑄛𑄬𑄚𑄴");
    namesMap.put("ET", "𑄃𑄨𑄜𑄨𑄃𑄮𑄛𑄨𑄠");
    namesMap.put("EU", "𑄄𑄃𑄪𑄢𑄮𑄛𑄩𑄠𑄧 𑄄𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴");
    namesMap.put("FI", "𑄜𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("FJ", "𑄜𑄨𑄎𑄨");
    namesMap.put("FK", "𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("FM", "𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠");
    namesMap.put("FO", "𑄜𑄳𑄠𑄢𑄧𑄃𑄮 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("FR", "𑄜𑄳𑄢𑄚𑄴𑄥𑄴");
    namesMap.put("GA", "𑄉𑄳𑄠𑄝𑄧𑄚𑄴");
    namesMap.put("GB", "𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮");
    namesMap.put("GD", "𑄉𑄳𑄢𑄬𑄚𑄓");
    namesMap.put("GE", "𑄎𑄧𑄢𑄴𑄎𑄨𑄠");
    namesMap.put("GF", "𑄜𑄧𑄢𑄥𑄩 𑄉𑄠𑄚");
    namesMap.put("GG", "𑄉𑄳𑄢𑄚𑄴𑄏𑄨");
    namesMap.put("GH", "𑄊𑄚");
    namesMap.put("GI", "𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴");
    namesMap.put("GL", "𑄉𑄳𑄢𑄩𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("GM", "𑄉𑄟𑄴𑄝𑄨𑄠");
    namesMap.put("GN", "𑄉𑄨𑄚𑄨");
    namesMap.put("GP", "𑄉𑄪𑄠𑄘𑄬𑄣𑄯𑄛𑄴");
    namesMap.put("GQ", "𑄚𑄨𑄢𑄧𑄇𑄴𑄈𑄩𑄠𑄧 𑄉𑄨𑄚𑄨");
    namesMap.put("GR", "𑄉𑄳𑄢𑄨𑄌𑄴");
    namesMap.put("GS", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄃𑄮 𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄪𑄃𑄨𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("GT", "𑄉𑄪𑄠𑄖𑄬𑄟𑄣");
    namesMap.put("GU", "𑄉𑄪𑄠𑄟𑄴");
    namesMap.put("GW", "𑄉𑄨𑄚𑄨-𑄝𑄨𑄥𑄃𑄪");
    namesMap.put("GY", "𑄉𑄨𑄠𑄚");
    namesMap.put("HK", "𑄦𑄧𑄁𑄇𑄧𑄁 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚");
    namesMap.put("HM", "𑄦𑄢𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠 𑄃𑄳𑄃 𑄟𑄳𑄠𑄇𑄴𑄓𑄮𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("HN", "𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴");
    namesMap.put("HR", "𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠");
    namesMap.put("HT", "𑄦𑄭𑄖𑄨");
    namesMap.put("HU", "𑄦𑄧𑄋𑄴𑄉𑄬𑄢𑄨");
    namesMap.put("IC", "𑄇𑄳𑄠𑄚𑄢𑄨 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("ID", "𑄄𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠");
    namesMap.put("IE", "𑄃𑄠𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("IL", "𑄄𑄎𑄴𑄢𑄠𑄬𑄣𑄴");
    namesMap.put("IM", "𑄃𑄭𑄣𑄴 𑄃𑄧𑄜𑄴 𑄟𑄳𑄠𑄚𑄴");
    namesMap.put("IN", "𑄞𑄢𑄧𑄖𑄴");
    namesMap.put("IO", "𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄞𑄢𑄧𑄖𑄴 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄨𑄠𑄧 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("IQ", "𑄄𑄢𑄇𑄴");
    namesMap.put("IR", "𑄄𑄢𑄚𑄴");
    namesMap.put("IS", "𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("IT", "𑄄𑄖𑄣𑄨");
    namesMap.put("JE", "𑄎𑄢𑄴𑄥𑄨");
    namesMap.put("JM", "𑄎𑄟𑄭𑄇");
    namesMap.put("JO", "𑄎𑄧𑄢𑄴𑄓𑄧𑄚𑄴");
    namesMap.put("JP", "𑄎𑄛𑄚𑄴");
    namesMap.put("KE", "𑄇𑄬𑄚𑄨𑄠");
    namesMap.put("KG", "𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄨𑄌𑄴𑄖𑄚𑄴");
    namesMap.put("KH", "𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠");
    namesMap.put("KI", "𑄇𑄨𑄢𑄨𑄝𑄖𑄨");
    namesMap.put("KM", "𑄇𑄧𑄟𑄮𑄢𑄮𑄌𑄴");
    namesMap.put("KN", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄇𑄨𑄑𑄴𑄥𑄴 𑄃𑄮 𑄚𑄬𑄞𑄨𑄌𑄴");
    namesMap.put("KP", "𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠");
    namesMap.put("KR", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠");
    namesMap.put("KW", "𑄇𑄪𑄠𑄬𑄖𑄴");
    namesMap.put("KY", "𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("KZ", "𑄇𑄎𑄈𑄌𑄴𑄖𑄚𑄴");
    namesMap.put("LA", "𑄣𑄃𑄮𑄌𑄴");
    namesMap.put("LB", "𑄣𑄬𑄝𑄚𑄧𑄚𑄴");
    namesMap.put("LC", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄣𑄪𑄥𑄨𑄠");
    namesMap.put("LI", "𑄣𑄨𑄌𑄬𑄚𑄴𑄥𑄳𑄑𑄬𑄃𑄨𑄚𑄴");
    namesMap.put("LK", "𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇");
    namesMap.put("LR", "𑄃𑄭𑄝𑄬𑄢𑄨𑄠");
    namesMap.put("LS", "𑄣𑄬𑄥𑄮𑄗𑄮");
    namesMap.put("LT", "𑄣𑄨𑄗𑄪𑄠𑄚𑄨𑄠");
    namesMap.put("LU", "𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄧");
    namesMap.put("LV", "𑄣𑄖𑄴𑄞𑄨𑄠");
    namesMap.put("LY", "𑄣𑄨𑄝𑄨𑄠");
    namesMap.put("MA", "𑄟𑄮𑄢𑄧𑄇𑄴𑄇𑄮");
    namesMap.put("MC", "𑄟𑄮𑄚𑄇𑄮");
    namesMap.put("MD", "𑄟𑄮𑄣𑄴𑄘𑄞𑄨𑄠");
    namesMap.put("ME", "𑄟𑄧𑄚𑄴𑄑𑄨𑄚𑄨𑄉𑄳𑄢𑄮");
    namesMap.put("MF", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄨𑄚𑄴");
    namesMap.put("MG", "𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴");
    namesMap.put("MH", "𑄟𑄢𑄴𑄥𑄣𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("MK", "𑄟𑄳𑄠𑄥𑄓𑄮𑄚𑄨𑄠");
    namesMap.put("ML", "𑄟𑄣𑄨");
    namesMap.put("MM", "𑄟𑄠𑄚𑄴𑄟𑄢𑄴 (𑄝𑄢𑄴𑄟)");
    namesMap.put("MN", "𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠");
    namesMap.put("MO", "𑄟𑄳𑄠𑄇𑄃𑄮 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚");
    namesMap.put("MP", "𑄅𑄪𑄖𑄴𑄖𑄮𑄉𑄎𑄢𑄴 𑄟𑄢𑄨𑄠𑄚 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("MQ", "𑄟𑄢𑄴𑄑𑄨𑄚𑄨𑄇𑄴");
    namesMap.put("MR", "𑄟𑄧𑄢𑄨𑄖𑄚𑄨𑄠");
    namesMap.put("MS", "𑄟𑄧𑄚𑄴𑄑𑄴𑄥𑄬𑄢𑄑𑄴");
    namesMap.put("MT", "𑄟𑄣𑄴𑄑");
    namesMap.put("MU", "𑄟𑄧𑄢𑄨𑄥𑄥𑄴");
    namesMap.put("MV", "𑄟𑄣𑄴𑄘𑄨𑄛𑄴");
    namesMap.put("MW", "𑄟𑄣𑄃𑄪𑄃𑄨");
    namesMap.put("MX", "𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮");
    namesMap.put("MY", "𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠");
    namesMap.put("MZ", "𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴");
    namesMap.put("NA", "𑄚𑄟𑄨𑄝𑄨𑄠");
    namesMap.put("NC", "𑄚𑄱 𑄇𑄳𑄠𑄣𑄬𑄓𑄮𑄚𑄨𑄠");
    namesMap.put("NE", "𑄚𑄭𑄎𑄢𑄴");
    namesMap.put("NF", "𑄚𑄨𑄢𑄴𑄜𑄮𑄇𑄴 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("NG", "𑄚𑄭𑄎𑄬𑄢𑄨𑄠");
    namesMap.put("NI", "𑄚𑄨𑄇𑄢𑄉𑄪𑄠");
    namesMap.put("NL", "𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴𑄥𑄴");
    namesMap.put("NO", "𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬");
    namesMap.put("NP", "𑄚𑄬𑄛𑄣𑄴");
    namesMap.put("NR", "𑄚𑄃𑄪𑄢𑄪");
    namesMap.put("NU", "𑄚𑄨𑄃𑄪𑄠𑄬");
    namesMap.put("NZ", "𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("OM", "𑄃𑄮𑄟𑄚𑄴");
    namesMap.put("PA", "𑄛𑄚𑄟");
    namesMap.put("PE", "𑄛𑄬𑄢𑄪");
    namesMap.put("PF", "𑄜𑄧𑄢𑄥𑄩 𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠");
    namesMap.put("PG", "𑄛𑄛𑄪𑄠 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨");
    namesMap.put("PH", "𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴");
    namesMap.put("PK", "𑄛𑄇𑄨𑄌𑄴𑄖𑄚𑄴");
    namesMap.put("PL", "𑄛𑄮𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("PM", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄛𑄨𑄠𑄬𑄢𑄴 𑄃𑄮 𑄟𑄨𑄢𑄪𑄠𑄬𑄣𑄧𑄚𑄴");
    namesMap.put("PN", "𑄛𑄨𑄇𑄴𑄇𑄬𑄠𑄢𑄴𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("PR", "𑄛𑄪𑄠𑄬𑄢𑄴𑄖𑄮 𑄢𑄨𑄇𑄮");
    namesMap.put("PS", "𑄜𑄨𑄣𑄨𑄌𑄴𑄖𑄨𑄚𑄴 𑄎𑄉𑄊𑄚𑄨");
    namesMap.put("PT", "𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄣𑄴");
    namesMap.put("PW", "𑄛𑄣𑄃𑄪");
    namesMap.put("PY", "𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄬");
    namesMap.put("QA", "𑄇𑄖𑄢𑄴");
    namesMap.put("QO", "𑄃𑄅𑄪𑄑𑄣𑄭𑄚𑄨𑄁 𑄃𑄮𑄥𑄚𑄨𑄠");
    namesMap.put("RE", "𑄢𑄨𑄃𑄨𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴");
    namesMap.put("RO", "𑄢𑄮𑄟𑄚𑄨𑄠");
    namesMap.put("RS", "𑄥𑄢𑄴𑄝𑄨𑄠");
    namesMap.put("RU", "𑄢𑄥𑄨𑄠");
    namesMap.put("RW", "𑄢𑄪𑄠𑄚𑄴𑄓");
    namesMap.put("SA", "𑄥𑄯𑄘𑄨 𑄃𑄢𑄧𑄝𑄴");
    namesMap.put("SB", "𑄥𑄧𑄣𑄮𑄟𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("SC", "𑄥𑄨𑄥𑄨𑄣𑄨");
    namesMap.put("SD", "𑄥𑄪𑄘𑄚𑄴");
    namesMap.put("SE", "𑄥𑄭𑄪𑄓𑄬𑄚𑄴");
    namesMap.put("SG", "𑄥𑄨𑄋𑄴𑄉𑄛𑄪𑄢𑄴");
    namesMap.put("SH", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄦𑄬𑄣𑄬𑄚");
    namesMap.put("SI", "𑄥𑄳𑄣𑄮𑄞𑄚𑄨𑄠");
    namesMap.put("SJ", "𑄥𑄣𑄴𑄝𑄢𑄴𑄓𑄴 𑄃𑄮 𑄎𑄚𑄴 𑄟𑄬𑄠𑄬𑄚𑄴");
    namesMap.put("SK", "𑄥𑄳𑄣𑄮𑄞𑄇𑄨𑄠");
    namesMap.put("SL", "𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄃𑄮𑄚𑄴");
    namesMap.put("SM", "𑄥𑄚𑄴 𑄟𑄢𑄨𑄚𑄮");
    namesMap.put("SN", "𑄥𑄬𑄚𑄬𑄉𑄣𑄴");
    namesMap.put("SO", "𑄥𑄮𑄟𑄣𑄨𑄠");
    namesMap.put("SR", "𑄥𑄪𑄢𑄨𑄚𑄟𑄴");
    namesMap.put("SS", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄴");
    namesMap.put("ST", "𑄥𑄃𑄮𑄑𑄟 𑄃𑄮 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄨");
    namesMap.put("SV", "𑄆𑄣𑄴 𑄥𑄣𑄴𑄞𑄬𑄘𑄧𑄢𑄴");
    namesMap.put("SX", "𑄥𑄨𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄬𑄚𑄴");
    namesMap.put("SY", "𑄥𑄨𑄢𑄨𑄠");
    namesMap.put("SZ", "𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("TA", "𑄑𑄳𑄢𑄌𑄴𑄑𑄚𑄴 𑄓 𑄇𑄪𑄚𑄴𑄦");
    namesMap.put("TC", "𑄖𑄪𑄢𑄴𑄇𑄧𑄌𑄴 𑄃𑄮 𑄇𑄭𑄇𑄮𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("TD", "𑄌𑄘𑄴");
    namesMap.put("TF", "𑄜𑄢𑄥𑄩 𑄘𑄧𑄉𑄨𑄚𑄧 𑄎𑄉");
    namesMap.put("TG", "𑄑𑄮𑄉𑄮");
    namesMap.put("TH", "𑄗𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴");
    namesMap.put("TJ", "𑄖𑄎𑄨𑄇𑄴𑄥𑄳𑄗𑄚𑄴");
    namesMap.put("TK", "𑄑𑄮𑄇𑄬𑄣𑄃𑄪");
    namesMap.put("TL", "𑄖𑄨𑄟𑄪𑄢𑄴-𑄣𑄬𑄌𑄴𑄖𑄬");
    namesMap.put("TM", "𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄴");
    namesMap.put("TN", "𑄖𑄨𑄃𑄪𑄚𑄨𑄥𑄨𑄠");
    namesMap.put("TO", "𑄑𑄮𑄋𑄴𑄉");
    namesMap.put("TR", "𑄖𑄪𑄢𑄧𑄌𑄴𑄇𑄧");
    namesMap.put("TT", "𑄖𑄳𑄢𑄨𑄚𑄨𑄚𑄘𑄴 𑄃𑄮 𑄑𑄮𑄝𑄳𑄠𑄉𑄮");
    namesMap.put("TV", "𑄑𑄪𑄞𑄣𑄪");
    namesMap.put("TW", "𑄖𑄭𑄤𑄚𑄴");
    namesMap.put("TZ", "𑄖𑄚𑄴𑄎𑄚𑄨𑄠");
    namesMap.put("UA", "𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄴");
    namesMap.put("UG", "𑄅𑄉𑄚𑄴𑄓");
    namesMap.put("UM", "𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄦𑄭𑄇𑄪𑄢𑄬 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("UN", "𑄎𑄘𑄨𑄥𑄧𑄁𑄊𑄧");
    namesMap.put("US", "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮");
    namesMap.put("UY", "𑄅𑄪𑄢𑄪𑄉𑄪𑄠𑄬");
    namesMap.put("UZ", "𑄅𑄪𑄎𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄴");
    namesMap.put("VA", "𑄞𑄳𑄠𑄑𑄨𑄇𑄚𑄴 𑄥𑄨𑄑𑄨");
    namesMap.put("VC", "𑄥𑄬𑄚𑄴𑄑𑄴 𑄞𑄨𑄚𑄴𑄥𑄬𑄚𑄴𑄑𑄴 𑄃𑄮 𑄘𑄳𑄠 𑄉𑄳𑄢𑄬𑄚𑄓𑄨𑄚𑄴𑄥𑄴");
    namesMap.put("VE", "𑄞𑄬𑄚𑄬𑄎𑄪𑄠𑄬𑄣");
    namesMap.put("VG", "𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("VI", "𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠");
    namesMap.put("VN", "𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄴");
    namesMap.put("VU", "𑄞𑄚𑄪𑄠𑄑𑄪");
    namesMap.put("WF", "𑄤𑄣𑄨𑄌𑄴 𑄃𑄮 𑄜𑄪𑄑𑄪𑄚");
    namesMap.put("WS", "𑄥𑄟𑄮𑄠");
    namesMap.put("XK", "𑄇𑄧𑄥𑄮𑄞𑄮");
    namesMap.put("YE", "𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄴");
    namesMap.put("YT", "𑄟𑄠𑄮𑄖𑄴𑄖𑄬");
    namesMap.put("ZA", "𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇");
    namesMap.put("ZM", "𑄎𑄟𑄴𑄝𑄨𑄠");
    namesMap.put("ZW", "𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬");
    namesMap.put("ZZ", "𑄃𑄨𑄌𑄨𑄚𑄴 𑄎𑄉");
  }

}
