/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "kl" locale.
 */
public class DateTimeFormatInfoImpl_kl extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "u.t.",
        "u.k."
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE dd MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "dd MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "MMM dd, y";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "Kristusip inunngornerata siornagut",
        "Kristusip inunngornerata kingornagut"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "Kr.in.si.",
        "Kr.in.king."
    };
  }

  @Override
  public String formatHour24Minute() {
    return "HH.mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH.mm.ss";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "januari",
        "februari",
        "martsi",
        "aprili",
        "maji",
        "juni",
        "juli",
        "augustusi",
        "septemberi",
        "oktoberi",
        "novemberi",
        "decemberi"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "jan",
        "feb",
        "mar",
        "apr",
        "maj",
        "jun",
        "jul",
        "aug",
        "sep",
        "okt",
        "nov",
        "dec"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "ukiup sisamararterutaa 1",
        "ukiup sisamararterutaa 2",
        "ukiup sisamararterutaa 3",
        "ukiup sisamararterutaa 4"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "S1",
        "S2",
        "S3",
        "S4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "HH.mm.ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "HH.mm.ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "HH.mm.ss";
  }

  @Override
  public String timeFormatShort() {
    return "HH.mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "sapaat",
        "ataasinngorneq",
        "marlunngorneq",
        "pingasunngorneq",
        "sisamanngorneq",
        "tallimanngorneq",
        "arfininngorneq"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "A",
        "M",
        "P",
        "S",
        "T",
        "A"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "sap",
        "ata",
        "mar",
        "pin",
        "sis",
        "tal",
        "arf"
    };
  }
}
