/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.TypeRegistry;
import org.dominokit.jacksonapt.processor.deserialization.AptDeserializerBuilder;

public class DeserializerGenerator {
    public String generate(TypeMirror beanType, String packageName) {
        String generatedClassName = Type.deserializerName(packageName, beanType);
        if (!TypeRegistry.containsDeserializer(beanType.toString())) {
            try {
                new AptDeserializerBuilder(beanType, ObjectMapperProcessor.filer).generate(packageName);
                TypeRegistry.registerDeserializer(beanType.toString(), (TypeName)ClassName.bestGuess((String)generatedClassName));
            }
            catch (IOException e) {
                throw new DeserializerGenerationFailedException(beanType.toString());
            }
        }
        return generatedClassName;
    }

    private class DeserializerGenerationFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        DeserializerGenerationFailedException(String type) {
            super(type);
        }
    }
}

