/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.dominokit.jacksonapt.processor.DeserializerGenerator;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.SerializerGenerator;
import org.dominokit.jacksonapt.processor.TypeRegistry;

public class Type {
    private static final int FIRST_ARGUMENT = 0;
    private static final int SECOND_ARGUMENT = 1;
    public static final String BEAN_JSON_SERIALIZER_IMPL = "BeanJsonSerializerImpl";
    public static final String BEAN_JSON_DESERIALIZER_IMPL = "BeanJsonDeserializerImpl";

    public static TypeName wrapperType(TypeMirror type) {
        if (Type.isPrimitive(type)) {
            if ("boolean".equals(type.toString())) {
                return TypeName.get(Boolean.class);
            }
            if ("byte".equals(type.toString())) {
                return TypeName.get(Byte.class);
            }
            if ("short".equals(type.toString())) {
                return TypeName.get(Short.class);
            }
            if ("int".equals(type.toString())) {
                return TypeName.get(Integer.class);
            }
            if ("long".equals(type.toString())) {
                return TypeName.get(Long.class);
            }
            if ("char".equals(type.toString())) {
                return TypeName.get(Character.class);
            }
            if ("float".equals(type.toString())) {
                return TypeName.get(Float.class);
            }
            if ("double".equals(type.toString())) {
                return TypeName.get(Double.class);
            }
            return TypeName.get(Void.class);
        }
        return TypeName.get((TypeMirror)type);
    }

    private static boolean isPrimitive(TypeMirror typeMirror) {
        return typeMirror.getKind().isPrimitive();
    }

    public static boolean isPrimitiveArray(TypeMirror typeMirror) {
        return Type.isArray(typeMirror) && Type.isPrimitive(Type.arrayComponentType(typeMirror)) || Type.isPrimitive2dArray(typeMirror);
    }

    private static boolean isPrimitive2dArray(TypeMirror typeMirror) {
        return Type.is2dArray(typeMirror) && Type.isPrimitiveArray(Type.arrayComponentType(typeMirror));
    }

    public static boolean isArray(TypeMirror typeMirror) {
        return TypeKind.ARRAY.compareTo(typeMirror.getKind()) == 0;
    }

    public static boolean is2dArray(TypeMirror typeMirror) {
        return Type.isArray(typeMirror) && Type.isArray(Type.arrayComponentType(typeMirror));
    }

    public static TypeMirror arrayComponentType(TypeMirror typeMirror) {
        return ((ArrayType)typeMirror).getComponentType();
    }

    public static TypeMirror deepArrayComponentType(TypeMirror typeMirror) {
        TypeMirror type = ((ArrayType)typeMirror).getComponentType();
        return Type.isArray(type) ? Type.arrayComponentType(type) : type;
    }

    public static boolean isEnum(TypeMirror typeMirror) {
        return !Objects.isNull(ObjectMapperProcessor.typeUtils.asElement(typeMirror)) && !Type.isPrimitive(typeMirror) && !Type.isPrimitiveArray(typeMirror) && ElementKind.ENUM.compareTo(ObjectMapperProcessor.typeUtils.asElement(typeMirror).getKind()) == 0;
    }

    public static boolean isCollection(TypeMirror typeMirror) {
        return !Type.isPrimitive(typeMirror) && Type.isAssignableFrom(typeMirror, Collection.class);
    }

    public static boolean isIterable(TypeMirror typeMirror) {
        return !Type.isPrimitive(typeMirror) && Type.isAssignableFrom(typeMirror, Iterable.class);
    }

    public static boolean isAssignableFrom(TypeMirror typeMirror, Class<?> targetClass) {
        return ObjectMapperProcessor.typeUtils.isAssignable(typeMirror, ObjectMapperProcessor.typeUtils.getDeclaredType(ObjectMapperProcessor.elementUtils.getTypeElement(targetClass.getName()), new TypeMirror[0]));
    }

    public static boolean isMap(TypeMirror typeMirror) {
        return !Type.isPrimitive(typeMirror) && Type.isAssignableFrom(typeMirror, Map.class);
    }

    public static TypeMirror firstTypeArgument(TypeMirror typeMirror) {
        return ((DeclaredType)typeMirror).getTypeArguments().get(0);
    }

    public static TypeMirror secondTypeArgument(TypeMirror typeMirror) {
        return ((DeclaredType)typeMirror).getTypeArguments().get(1);
    }

    public static boolean isBasicType(TypeMirror typeMirror) {
        return TypeRegistry.isBasicType(typeMirror.toString());
    }

    public static String getPackage(TypeMirror typeMirror) {
        return ObjectMapperProcessor.elementUtils.getPackageOf(ObjectMapperProcessor.typeUtils.asElement(typeMirror)).getSimpleName().toString();
    }

    public static Name simpleName(TypeMirror typeMirror) {
        return ObjectMapperProcessor.typeUtils.asElement(typeMirror).getSimpleName();
    }

    public static String serializerName(TypeMirror typeMirror) {
        ClassName type = ClassName.bestGuess((String)typeMirror.toString());
        return Type.serializerName(type.packageName(), typeMirror);
    }

    public static String serializerName(String packageName, TypeMirror beanType) {
        return packageName + "." + Type.stringifyType(beanType) + BEAN_JSON_SERIALIZER_IMPL;
    }

    public static String deserializerName(TypeMirror typeMirror) {
        ClassName type = ClassName.bestGuess((String)typeMirror.toString());
        return Type.deserializerName(type.packageName(), typeMirror);
    }

    public static String deserializerName(String packageName, TypeMirror beanType) {
        return packageName + "." + Type.stringifyType(beanType) + BEAN_JSON_DESERIALIZER_IMPL;
    }

    public static String stringifyType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<String, String>(){

            @Override
            public String visitDeclared(DeclaredType t, String p) {
                return p + t.asElement().getSimpleName() + (!t.getTypeArguments().isEmpty() ? "_" + t.getTypeArguments().stream().map(type -> (String)this.visit((TypeMirror)type, "")).collect(Collectors.joining("_")) : "");
            }
        }, "");
    }

    public static String generateDeserializer(TypeMirror typeMirror) {
        ClassName type = ClassName.bestGuess((String)typeMirror.toString());
        return new DeserializerGenerator().generate(typeMirror, type.packageName());
    }

    public static String generateSerializer(TypeMirror typeMirror) {
        ClassName type = ClassName.bestGuess((String)typeMirror.toString());
        return new SerializerGenerator().generate(typeMirror, type.packageName());
    }
}

