/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.deserialization;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.Deque;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.deser.EnumJsonDeserializer;
import org.dominokit.jacksonapt.deser.array.ArrayJsonDeserializer;
import org.dominokit.jacksonapt.deser.array.dd.Array2dJsonDeserializer;
import org.dominokit.jacksonapt.processor.MappersChainBuilder;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.TypeRegistry;

public class FieldDeserializersChainBuilder
implements MappersChainBuilder {
    private static final String GET_INSTANCE = "$T.getInstance()";
    private static final String NEW_INSTANCE = "$T.newInstance(";
    private CodeBlock.Builder builder = CodeBlock.builder();
    private Deque<TypeName> deserializers = new LinkedList<TypeName>();
    private TypeMirror beanType;

    public FieldDeserializersChainBuilder(TypeMirror beanType) {
        this.beanType = beanType;
    }

    @Override
    public CodeBlock getInstance(Element field) {
        return this.builder.add(this.getFieldDeserializer(field.asType()), (Object[])this.asClassesArray()).build();
    }

    public CodeBlock getInstance(TypeMirror type) {
        return this.builder.add(this.getFieldDeserializer(type), (Object[])this.asClassesArray()).build();
    }

    private TypeName[] asClassesArray() {
        return this.deserializers.toArray(new TypeName[this.deserializers.size()]);
    }

    private String getFieldDeserializer(TypeMirror typeMirror) {
        if (Type.isIterable(typeMirror)) {
            return this.getIterableDeserializer(typeMirror);
        }
        if (Type.isMap(typeMirror)) {
            return this.getMapDeserializer(typeMirror);
        }
        if (Type.isArray(typeMirror)) {
            return this.getArrayDeserializer(typeMirror);
        }
        if (Type.isEnum(typeMirror)) {
            return this.getEnumDeserializer(typeMirror);
        }
        return this.getBasicOrCustomDeserializer(typeMirror);
    }

    private String getBasicOrCustomDeserializer(TypeMirror typeMirror) {
        if (Type.isBasicType(typeMirror)) {
            return this.getBasicDeserializer(typeMirror);
        }
        return this.getCustomDeserializer(typeMirror);
    }

    private String getCustomDeserializer(TypeMirror typeMirror) {
        if (typeMirror.toString().equals(this.beanType.toString())) {
            this.deserializers.addLast((TypeName)ClassName.bestGuess((String)Type.deserializerName(typeMirror)));
        } else if (TypeRegistry.containsDeserializer(typeMirror)) {
            this.deserializers.addLast(TypeRegistry.getCustomDeserializer(typeMirror));
        } else {
            TypeRegistry.registerDeserializer(typeMirror.toString(), (TypeName)ClassName.bestGuess((String)this.generateCustomDeserializer(typeMirror)));
            this.deserializers.addLast(TypeRegistry.getCustomDeserializer(typeMirror));
        }
        return "new $T()";
    }

    private String generateCustomDeserializer(TypeMirror typeMirror) {
        return Type.generateDeserializer(typeMirror);
    }

    private String getEnumDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(EnumJsonDeserializer.class));
        this.deserializers.addLast(TypeName.get((TypeMirror)typeMirror));
        return "$T.newInstance($T.class)";
    }

    private String getBasicDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeRegistry.getDeserializer(typeMirror));
        return GET_INSTANCE;
    }

    private String getMapDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(TypeRegistry.getMapDeserializer(typeMirror)));
        return NEW_INSTANCE + this.getKeyDeserializer(Type.firstTypeArgument(typeMirror)) + ", " + this.getFieldDeserializer(Type.secondTypeArgument(typeMirror)) + ")";
    }

    private String getKeyDeserializer(TypeMirror typeMirror) {
        if (Type.isEnum(typeMirror)) {
            return this.getEnumKeyDeserializer(typeMirror);
        }
        return this.getBasicKeyDeserializer(typeMirror);
    }

    private String getBasicKeyDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeRegistry.getKeyDeserializer(typeMirror.toString()));
        return GET_INSTANCE;
    }

    private String getEnumKeyDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeRegistry.getKeyDeserializer(Enum.class.getName()));
        this.deserializers.addLast(TypeName.get((TypeMirror)typeMirror));
        return "$T.newInstance($T.class)";
    }

    private String getIterableDeserializer(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(TypeRegistry.getCollectionDeserializer(typeMirror)));
        return NEW_INSTANCE + this.getFieldDeserializer(Type.firstTypeArgument(typeMirror)) + ")";
    }

    private String getArrayDeserializer(TypeMirror typeMirror) {
        if (Type.isPrimitiveArray(typeMirror)) {
            return this.getBasicDeserializer(typeMirror);
        }
        if (Type.is2dArray(typeMirror)) {
            this.deserializers.addLast(TypeName.get(Array2dJsonDeserializer.class));
            return NEW_INSTANCE + this.getFieldDeserializer(Type.deepArrayComponentType(typeMirror)) + ", " + this.getArray2dCreatorFormat(typeMirror) + ")";
        }
        this.deserializers.addLast(TypeName.get(ArrayJsonDeserializer.class));
        return NEW_INSTANCE + this.getFieldDeserializer(Type.arrayComponentType(typeMirror)) + ", " + this.getArrayCreatorFormat(typeMirror) + ")";
    }

    private String getArrayCreatorFormat(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(ArrayJsonDeserializer.ArrayCreator.class));
        this.deserializers.addLast(TypeName.get((TypeMirror)Type.arrayComponentType(typeMirror)));
        this.deserializers.addLast(TypeName.get((TypeMirror)ObjectMapperProcessor.typeUtils.erasure(Type.arrayComponentType(typeMirror))));
        return "($T<$T>) $T[]::new";
    }

    private String getArray2dCreatorFormat(TypeMirror typeMirror) {
        this.deserializers.addLast(TypeName.get(Array2dJsonDeserializer.Array2dCreator.class));
        this.deserializers.addLast(TypeName.get((TypeMirror)Type.deepArrayComponentType(typeMirror)));
        this.deserializers.addLast(TypeName.get((TypeMirror)ObjectMapperProcessor.typeUtils.erasure(Type.deepArrayComponentType(typeMirror))));
        return "($T<$T>) (first, second) -> new $T[first][second]";
    }
}

