/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.AbstractMapperGenerator;
import org.dominokit.jacksonapt.processor.BeanMapperGenerator;
import org.dominokit.jacksonapt.processor.BeanReaderGenerator;
import org.dominokit.jacksonapt.processor.BeanWriterGenerator;
import org.dominokit.jacksonapt.processor.CollectionMapperGenerator;
import org.dominokit.jacksonapt.processor.CollectionReaderGenerator;
import org.dominokit.jacksonapt.processor.CollectionWriterGenerator;
import org.dominokit.jacksonapt.processor.MapperGenerator;
import org.dominokit.jacksonapt.processor.Type;

public class MapperGeneratorFactory
implements MapperGenerator {
    @Override
    public void generate(Element element) throws IOException {
        TypeMirror beanType = AbstractMapperGenerator.getElementType(element);
        if (Type.isCollection(beanType) || Type.isMap(beanType)) {
            new CollectionMapperGenerator().generate(element);
        } else {
            new BeanMapperGenerator().generate(element);
        }
    }

    public void generateReader(Element element) throws IOException {
        TypeMirror beanType = AbstractMapperGenerator.getElementType(element);
        if (Type.isCollection(beanType)) {
            new CollectionReaderGenerator().generate(element);
        } else {
            new BeanReaderGenerator().generate(element);
        }
    }

    public void generateWriter(Element element) throws IOException {
        TypeMirror beanType = AbstractMapperGenerator.getElementType(element);
        if (Type.isCollection(beanType)) {
            new CollectionWriterGenerator().generate(element);
        } else {
            new BeanWriterGenerator().generate(element);
        }
    }
}

