/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.TypeRegistry;
import org.dominokit.jacksonapt.processor.serialization.AptSerializerBuilder;

public class SerializerGenerator {
    public String generate(TypeMirror beanType, String packageName) {
        String generatedClassName = Type.serializerName(packageName, beanType);
        if (!TypeRegistry.containsSerializer(beanType.toString())) {
            try {
                new AptSerializerBuilder(beanType, ObjectMapperProcessor.filer).generate(packageName);
                TypeRegistry.registerSerializer(beanType.toString(), (TypeName)ClassName.bestGuess((String)generatedClassName));
            }
            catch (IOException e) {
                throw new SerializerGenerationFailedException(beanType.toString());
            }
        }
        return generatedClassName;
    }

    private class SerializerGenerationFailedException
    extends RuntimeException {
        SerializerGenerationFailedException(String type) {
            super(type);
        }
    }
}

