/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ii" locale.
 */
public class DateTimeFormatInfoImpl_ii extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "ꎸꄑ",
        "ꁯꋒ"
    };
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "ꃅꋊꂿ",
        "ꃅꋊꊂ"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "ꃅꋊꂿ",
        "ꃅꋊꊂ"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y-MM-dd";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "ꋍꆪ",
        "ꑍꆪ",
        "ꌕꆪ",
        "ꇖꆪ",
        "ꉬꆪ",
        "ꃘꆪ",
        "ꏃꆪ",
        "ꉆꆪ",
        "ꈬꆪ",
        "ꊰꆪ",
        "ꊰꊪꆪ",
        "ꊰꑋꆪ"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "ꋍꆪ",
        "ꑍꆪ",
        "ꌕꆪ",
        "ꇖꆪ",
        "ꉬꆪ",
        "ꃘꆪ",
        "ꏃꆪ",
        "ꉆꆪ",
        "ꈬꆪ",
        "ꊰꆪ",
        "ꊰꊪꆪ",
        "ꊰꑋꆪ"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "ꃅꑌ",
        "ꃅꎸ",
        "ꃅꍵ",
        "ꃅꋆ"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "ꃅꑌ",
        "ꃅꎸ",
        "ꃅꍵ",
        "ꃅꋆ"
    };
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "ꑭꆏꑍ",
        "ꆏꊂꋍ",
        "ꆏꊂꑍ",
        "ꆏꊂꌕ",
        "ꆏꊂꇖ",
        "ꆏꊂꉬ",
        "ꆏꊂꃘ"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "ꆏ",
        "ꋍ",
        "ꑍ",
        "ꌕ",
        "ꇖ",
        "ꉬ",
        "ꃘ"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ꑭꆏ",
        "ꆏꋍ",
        "ꆏꑍ",
        "ꆏꌕ",
        "ꆏꇖ",
        "ꆏꉬ",
        "ꆏꃘ"
    };
  }
}
