/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor.deserialization;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.JacksonContextProvider;
import org.dominokit.jacksonapt.JsonDeserializationContext;
import org.dominokit.jacksonapt.JsonDeserializer;
import org.dominokit.jacksonapt.JsonDeserializerParameters;
import org.dominokit.jacksonapt.deser.bean.AbstractBeanJsonDeserializer;
import org.dominokit.jacksonapt.deser.bean.BeanPropertyDeserializer;
import org.dominokit.jacksonapt.deser.bean.HasDeserializerAndParameters;
import org.dominokit.jacksonapt.deser.bean.Instance;
import org.dominokit.jacksonapt.deser.bean.InstanceBuilder;
import org.dominokit.jacksonapt.deser.bean.MapLike;
import org.dominokit.jacksonapt.deser.bean.SubtypeDeserializer;
import org.dominokit.jacksonapt.deser.bean.TypeDeserializationInfo;
import org.dominokit.jacksonapt.processor.AbstractJsonMapperGenerator;
import org.dominokit.jacksonapt.processor.AbstractMapperProcessor;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.deserialization.DeserializerBuilder;
import org.dominokit.jacksonapt.stream.JsonReader;

public class AptDeserializerBuilder
extends AbstractJsonMapperGenerator {
    private static final WildcardTypeName DEFAULT_WILDCARD = WildcardTypeName.subtypeOf(Object.class);

    public AptDeserializerBuilder(String packageName, TypeMirror beanType, Filer filer) {
        super(packageName, beanType, filer);
    }

    @Override
    protected TypeName superClass() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(AbstractBeanJsonDeserializer.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)this.beanType)});
    }

    @Override
    protected String namePostfix() {
        return "BeanJsonDeserializerImpl";
    }

    @Override
    protected String targetTypeMethodName() {
        return "getDeserializedType";
    }

    @Override
    protected MethodSpec initMethod() {
        return this.buildInitDeserializersMethod(this.beanType);
    }

    @Override
    protected MethodSpec initSubtypesMethod() {
        if (this.subTypesInfo == null) {
            return MethodSpec.methodBuilder((String)"initMapSubtypeClassToDeserializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(SubtypeDeserializer.class)})).addStatement("return $T.emptyMap()", new Object[]{Collections.class}).build();
        }
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initMapSubtypeClassToDeserializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(SubtypeDeserializer.class)})).addStatement("$T map = new $T($L)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(Class.class), ClassName.get(SubtypeDeserializer.class)}), ClassName.get(IdentityHashMap.class), this.subTypesInfo.getSubTypes().size()});
        for (Map.Entry<String, TypeMirror> subtypeEntry : this.subTypesInfo.getSubTypes().entrySet()) {
            TypeSpec subtypeType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ClassName.get(SubtypeDeserializer.BeanSubtypeDeserializer.class)).addMethod(MethodSpec.methodBuilder((String)"newDeserializer").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonDeserializer.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})).addStatement("return new $T()", new Object[]{ClassName.bestGuess((String)Type.deserializerName(this.packageName, subtypeEntry.getValue()))}).build()).build();
            builder.addStatement("map.put($T.class, $L)", new Object[]{TypeName.get((TypeMirror)subtypeEntry.getValue()), subtypeType});
        }
        builder.addStatement("return map", new Object[0]);
        return builder.build();
    }

    @Override
    protected Set<MethodSpec> moreMethods() {
        JsonIgnoreProperties ignorePropertiesAnnotation;
        MethodSpec initIgnoreFieldsMethod;
        HashSet<MethodSpec> methods = new HashSet<MethodSpec>();
        if (this.beanType.getKind() == TypeKind.DECLARED && ((DeclaredType)this.beanType).asElement().getKind() == ElementKind.CLASS && !((DeclaredType)this.beanType).asElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            methods.add(this.buildInitInstanceBuilderMethod(this.beanType));
        }
        if (Objects.nonNull(initIgnoreFieldsMethod = this.buildInitIgnoreFields(this.beanType))) {
            methods.add(initIgnoreFieldsMethod);
        }
        if (Objects.nonNull(ignorePropertiesAnnotation = AbstractMapperProcessor.typeUtils.asElement(this.beanType).getAnnotation(JsonIgnoreProperties.class))) {
            methods.add(this.buildIgnoreUnknownMethod(ignorePropertiesAnnotation.ignoreUnknown()));
        }
        return methods;
    }

    private MethodSpec buildIgnoreUnknownMethod(boolean ignored) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"isDefaultIgnoreUnknown").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.BOOLEAN).addStatement("return $L", new Object[]{ignored});
        return builder.build();
    }

    private MethodSpec buildInitIgnoreFields(TypeMirror beanType) {
        List<Element> ignoredFields = this.getIgnoredFields(beanType);
        if (!ignoredFields.isEmpty()) {
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initIgnoredProperties");
            builder.addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get(HashSet.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{String.class})).addStatement("HashSet<String> col = new HashSet<String>(" + ignoredFields.size() + ")", new Object[0]);
            ignoredFields.forEach(f -> builder.addStatement("col.add(\"" + this.getPropertyName((Element)f) + "\")", new Object[0]));
            builder.addStatement("return col", new Object[0]);
            return builder.build();
        }
        return null;
    }

    private List<Element> getIgnoredFields(TypeMirror beanType) {
        TypeElement typeElement = (TypeElement)AbstractMapperProcessor.typeUtils.asElement(beanType);
        ArrayList<Element> fields = new ArrayList<Element>();
        List<Element> ignoredFields = this.getIgnoredFields(typeElement);
        fields.addAll(ignoredFields);
        return fields;
    }

    private List<Element> getIgnoredFields(TypeElement typeElement) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return new ArrayList<Element>();
        }
        List<Element> ignoredFields = typeElement.getEnclosedElements().stream().filter(e -> ElementKind.FIELD.equals((Object)e.getKind()) && this.isNotStatic((Element)e) && this.isIgnored((Element)e)).collect(Collectors.toList());
        ignoredFields.addAll(this.getIgnoredFields((TypeElement)AbstractMapperProcessor.typeUtils.asElement(superclass)));
        return ignoredFields;
    }

    private MethodSpec buildInitInstanceBuilderMethod(TypeMirror beanType) {
        return MethodSpec.methodBuilder((String)"initInstanceBuilder").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(InstanceBuilder.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)beanType)})).addStatement("final $T deserializers = null", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(MapLike.class), (TypeName[])new TypeName[]{ClassName.get(HasDeserializerAndParameters.class)})}).addStatement("return $L", new Object[]{this.instanceBuilderReturnType()}).addAnnotation(Override.class).build();
    }

    private TypeSpec instanceBuilderReturnType() {
        MethodSpec createMethod = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(ClassName.get((TypeMirror)this.beanType)).addStatement(Type.isGenericType(this.beanType) ? "return new $T<>()" : "return new $T()", new Object[]{TypeName.get((TypeMirror)AbstractMapperProcessor.typeUtils.erasure(this.beanType))}).build();
        return TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(InstanceBuilder.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)this.beanType)})).addMethod(this.newInstanceMethod(this.beanType, createMethod)).addMethod(this.getDeserializerMethod(this.beanType)).addMethod(createMethod).build();
    }

    private MethodSpec newInstanceMethod(TypeMirror beanType, MethodSpec createMethod) {
        return MethodSpec.methodBuilder((String)"newInstance").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Instance.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)beanType)})).addParameter(JsonReader.class, "reader", new Modifier[0]).addParameter(JsonDeserializationContext.class, "ctx", new Modifier[0]).addParameter(JsonDeserializerParameters.class, "params", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{String.class, String.class}), "bufferedProperties", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{String.class, Object.class}), "bufferedPropertiesValues", new Modifier[0]).addStatement("return new $T($N(), bufferedProperties)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Instance.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)beanType)}), createMethod}).build();
    }

    private MethodSpec getDeserializerMethod(TypeMirror beanType) {
        return MethodSpec.methodBuilder((String)"getParametersDeserializer").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return deserializers", new Object[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(MapLike.class), (TypeName[])new TypeName[]{ClassName.get(HasDeserializerAndParameters.class)})).build();
    }

    private MethodSpec buildInitDeserializersMethod(TypeMirror beanType) {
        ParameterizedTypeName resultType = ParameterizedTypeName.get((ClassName)ClassName.get(MapLike.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(BeanPropertyDeserializer.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)beanType), DEFAULT_WILDCARD})});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"initDeserializers").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)resultType).addStatement("$T map = $T.get().mapLikeFactory().make()", new Object[]{resultType, JacksonContextProvider.class});
        this.orderedFields().entrySet().stream().filter(entry -> this.isEligibleForSerializationDeserialization((Element)entry.getKey())).forEach(entry -> builder.addStatement("map.put($S, $L)", new Object[]{this.getPropertyName((Element)entry.getKey()), new DeserializerBuilder(AbstractMapperProcessor.typeUtils, beanType, this.packageName, (Element)entry.getKey(), (TypeMirror)entry.getValue()).buildDeserializer()}));
        builder.addStatement("return map", new Object[0]);
        return builder.build();
    }

    private String getPropertyName(Element field) {
        JsonProperty annotation = field.getAnnotation(JsonProperty.class);
        if (Objects.isNull(annotation) || "".equals(annotation.value())) {
            return field.getSimpleName().toString();
        }
        return annotation.value();
    }

    @Override
    protected Class<?> getMapperType() {
        return TypeDeserializationInfo.class;
    }
}

