/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.SubTypesInfo;
import org.dominokit.jacksonapt.processor.Type;
import org.dominokit.jacksonapt.processor.TypeRegistry;
import org.dominokit.jacksonapt.processor.serialization.AptSerializerBuilder;

public class SerializerGenerator {
    public String generate(String packageName, TypeMirror beanType) {
        String serializerName = Type.serializerName(packageName, beanType);
        if (!TypeRegistry.containsSerializer(Type.stringifyTypeWithPackage(beanType))) {
            try {
                this.generateSubTypeSerializers(packageName, beanType);
                new AptSerializerBuilder(packageName, beanType, ObjectMapperProcessor.filer).generate();
                TypeRegistry.registerSerializer(Type.stringifyTypeWithPackage(beanType), (TypeName)ClassName.bestGuess((String)serializerName));
            }
            catch (IOException e) {
                throw new SerializerGenerationFailedException(beanType.toString());
            }
        }
        return serializerName;
    }

    private void generateSubTypeSerializers(String packageName, TypeMirror beanType) {
        SubTypesInfo subTypesInfo = Type.getSubTypes(beanType);
        for (Map.Entry<String, TypeMirror> subtypeEntry : subTypesInfo.getSubTypes().entrySet()) {
            if (!((DeclaredType)beanType).getTypeArguments().isEmpty() || !((DeclaredType)((DeclaredType)subtypeEntry.getValue()).asElement().asType()).getTypeArguments().isEmpty()) {
                throw new RuntimeException("@JsonSubTypes and &JsonTypeInfo can be used only on non-generic Java types");
            }
            new SerializerGenerator().generate(packageName, subtypeEntry.getValue());
        }
    }

    private class SerializerGenerationFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        SerializerGenerationFailedException(String type) {
            super(type);
        }
    }
}

