/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.dominokit.jacksonapt.annotation.JSONMapper;
import org.dominokit.jacksonapt.processor.DeserializerGenerator;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.SerializerGenerator;
import org.dominokit.jacksonapt.processor.SubTypesInfo;
import org.dominokit.jacksonapt.processor.TypeRegistry;

public class Type {
    private static final int FIRST_ARGUMENT = 0;
    private static final int SECOND_ARGUMENT = 1;
    public static final String BEAN_JSON_SERIALIZER_IMPL = "BeanJsonSerializerImpl";
    public static final String BEAN_JSON_DESERIALIZER_IMPL = "BeanJsonDeserializerImpl";

    public static TypeName wrapperType(TypeMirror type) {
        if (Type.isPrimitive(type)) {
            if ("boolean".equals(type.toString())) {
                return TypeName.get(Boolean.class);
            }
            if ("byte".equals(type.toString())) {
                return TypeName.get(Byte.class);
            }
            if ("short".equals(type.toString())) {
                return TypeName.get(Short.class);
            }
            if ("int".equals(type.toString())) {
                return TypeName.get(Integer.class);
            }
            if ("long".equals(type.toString())) {
                return TypeName.get(Long.class);
            }
            if ("char".equals(type.toString())) {
                return TypeName.get(Character.class);
            }
            if ("float".equals(type.toString())) {
                return TypeName.get(Float.class);
            }
            if ("double".equals(type.toString())) {
                return TypeName.get(Double.class);
            }
            return TypeName.get(Void.class);
        }
        return TypeName.get((TypeMirror)type);
    }

    private static boolean isPrimitive(TypeMirror typeMirror) {
        return typeMirror.getKind().isPrimitive();
    }

    public static boolean isPrimitiveArray(TypeMirror typeMirror) {
        return Type.isArray(typeMirror) && Type.isPrimitive(Type.arrayComponentType(typeMirror)) || Type.isPrimitive2dArray(typeMirror);
    }

    private static boolean isPrimitive2dArray(TypeMirror typeMirror) {
        return Type.is2dArray(typeMirror) && Type.isPrimitiveArray(Type.arrayComponentType(typeMirror));
    }

    public static boolean isArray(TypeMirror typeMirror) {
        return TypeKind.ARRAY.compareTo(typeMirror.getKind()) == 0;
    }

    public static boolean is2dArray(TypeMirror typeMirror) {
        return Type.isArray(typeMirror) && Type.isArray(Type.arrayComponentType(typeMirror));
    }

    public static TypeMirror arrayComponentType(TypeMirror typeMirror) {
        return ((ArrayType)typeMirror).getComponentType();
    }

    public static TypeMirror deepArrayComponentType(TypeMirror typeMirror) {
        TypeMirror type = ((ArrayType)typeMirror).getComponentType();
        return Type.isArray(type) ? Type.arrayComponentType(type) : type;
    }

    public static boolean isEnum(TypeMirror typeMirror) {
        return !Objects.isNull(ObjectMapperProcessor.typeUtils.asElement(typeMirror)) && !Type.isPrimitive(typeMirror) && !Type.isPrimitiveArray(typeMirror) && ElementKind.ENUM.compareTo(ObjectMapperProcessor.typeUtils.asElement(typeMirror).getKind()) == 0;
    }

    public static boolean isCollection(TypeMirror typeMirror) {
        return !Type.isPrimitive(typeMirror) && Type.isAssignableFrom(typeMirror, Collection.class);
    }

    public static boolean isIterable(TypeMirror typeMirror) {
        return !Type.isPrimitive(typeMirror) && Type.isAssignableFrom(typeMirror, Iterable.class);
    }

    public static boolean isAssignableFrom(TypeMirror typeMirror, Class<?> targetClass) {
        return ObjectMapperProcessor.typeUtils.isAssignable(typeMirror, ObjectMapperProcessor.typeUtils.getDeclaredType(ObjectMapperProcessor.elementUtils.getTypeElement(targetClass.getName()), new TypeMirror[0]));
    }

    public static boolean isMap(TypeMirror typeMirror) {
        return !Type.isPrimitive(typeMirror) && Type.isAssignableFrom(typeMirror, Map.class);
    }

    public static TypeMirror firstTypeArgument(TypeMirror typeMirror) {
        return ((DeclaredType)typeMirror).getTypeArguments().get(0);
    }

    public static TypeMirror secondTypeArgument(TypeMirror typeMirror) {
        return ((DeclaredType)typeMirror).getTypeArguments().get(1);
    }

    public static boolean isBasicType(TypeMirror typeMirror) {
        return TypeRegistry.isBasicType(Type.stringifyTypeWithPackage(typeMirror));
    }

    public static String getPackage(TypeMirror typeMirror) {
        return ObjectMapperProcessor.typeUtils.asElement(ObjectMapperProcessor.typeUtils.erasure(typeMirror)) != null ? ObjectMapperProcessor.elementUtils.getPackageOf(ObjectMapperProcessor.typeUtils.asElement(ObjectMapperProcessor.typeUtils.erasure(typeMirror))).toString() : "";
    }

    public static Name simpleName(TypeMirror typeMirror) {
        return ObjectMapperProcessor.typeUtils.asElement(typeMirror).getSimpleName();
    }

    public static String serializerName(String packageName, TypeMirror beanType) {
        return packageName + "." + Type.stringifyType(beanType) + BEAN_JSON_SERIALIZER_IMPL;
    }

    public static String deserializerName(String packageName, TypeMirror beanType) {
        return packageName + "." + Type.stringifyType(beanType) + BEAN_JSON_DESERIALIZER_IMPL;
    }

    public static String stringifyTypeWithPackage(TypeMirror type) {
        return Type.stringifyType(type, true);
    }

    public static String stringifyType(TypeMirror type) {
        return Type.stringifyType(type, false);
    }

    private static String stringifyType(TypeMirror type, boolean appendPackage) {
        return (appendPackage ? (!Type.getPackage(type).isEmpty() ? Type.getPackage(type) + "." : "") : "") + type.accept(new SimpleTypeVisitor8<String, Void>(){

            @Override
            public String visitDeclared(DeclaredType t, Void p) {
                return t.asElement().getSimpleName() + (!t.getTypeArguments().isEmpty() ? "_" + t.getTypeArguments().stream().map(type -> (String)this.visit((TypeMirror)type, p)).collect(Collectors.joining("_")) : "");
            }

            @Override
            public String visitWildcard(WildcardType t, Void p) {
                return t.getExtendsBound() != null ? "extends_" + (String)this.visit(t.getExtendsBound(), p) : (t.getSuperBound() != null ? "super_" + (String)this.visit(t.getSuperBound(), p) : "");
            }

            @Override
            public String visitArray(ArrayType t, Void p) {
                return (String)this.visit(t.getComponentType(), p) + "[]";
            }

            @Override
            public String visitTypeVariable(TypeVariable t, Void p) {
                return t.toString();
            }

            @Override
            public String visitPrimitive(PrimitiveType t, Void p) {
                return t.toString();
            }
        }, null);
    }

    public static String generateDeserializer(String packageName, TypeMirror typeMirror) {
        return new DeserializerGenerator().generate(packageName, typeMirror);
    }

    public static String generateSerializer(String packageName, TypeMirror typeMirror) {
        return new SerializerGenerator().generate(packageName, typeMirror);
    }

    public static TypeMirror removeOuterWildCards(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType t, Void p) {
                return t;
            }

            @Override
            public TypeMirror visitTypeVariable(TypeVariable t, Void p) {
                return t;
            }

            @Override
            public TypeMirror visitWildcard(WildcardType t, Void p) {
                return t.getExtendsBound() != null ? (TypeMirror)this.visit(t.getExtendsBound(), p) : (t.getSuperBound() != null ? (TypeMirror)this.visit(t.getSuperBound(), p) : ObjectMapperProcessor.typeUtils.getDeclaredType(ObjectMapperProcessor.elementUtils.getTypeElement(Object.class.getName()), new TypeMirror[0]));
            }

            @Override
            public TypeMirror visitArray(ArrayType t, Void p) {
                return ObjectMapperProcessor.typeUtils.getArrayType((TypeMirror)this.visit(t.getComponentType(), p));
            }

            @Override
            public TypeMirror visitPrimitive(PrimitiveType t, Void p) {
                return t;
            }
        }, null);
    }

    public static boolean hasWildcards(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType t, Void p) {
                return t.getTypeArguments().stream().map(typeArg -> (Boolean)this.visit((TypeMirror)typeArg, p)).filter(b -> b).findFirst().orElse(false);
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Void p) {
                return false;
            }

            @Override
            public Boolean visitWildcard(WildcardType t, Void p) {
                return true;
            }

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return (Boolean)this.visit(t.getComponentType(), p);
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Void p) {
                return false;
            }
        }, null);
    }

    public static boolean isGenericType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType t, Void p) {
                return !t.getTypeArguments().isEmpty();
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Void p) {
                return true;
            }

            @Override
            public Boolean visitWildcard(WildcardType t, Void p) {
                return true;
            }

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return (Boolean)this.visit(t.getComponentType(), p);
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Void p) {
                return false;
            }
        }, null);
    }

    public static boolean hasTypeParameter(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType t, Void p) {
                return t.getTypeArguments().stream().map(typeArg -> (Boolean)this.visit((TypeMirror)typeArg, p)).filter(b -> b).findFirst().orElse(false);
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Void p) {
                return true;
            }

            @Override
            public Boolean visitWildcard(WildcardType t, Void p) {
                return t.getExtendsBound() != null ? (Boolean)this.visit(t.getExtendsBound(), p) : (t.getSuperBound() != null ? (Boolean)this.visit(t.getSuperBound(), p) : Boolean.valueOf(false));
            }

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return (Boolean)this.visit(t.getComponentType(), p);
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Void p) {
                return false;
            }
        }, null);
    }

    public static SubTypesInfo getSubTypes(TypeMirror type) {
        TypeElement beanElement;
        JsonTypeInfo typeInfo;
        SubTypesInfo subTypeInfo = SubTypesInfo.emtpy();
        if (type.getKind() == TypeKind.DECLARED && (typeInfo = (beanElement = (TypeElement)((DeclaredType)type).asElement()).getAnnotation(JsonTypeInfo.class)) != null && typeInfo.use() == JsonTypeInfo.Id.NAME && beanElement.getAnnotation(JsonSubTypes.class) != null) {
            subTypeInfo = new SubTypesInfo(typeInfo.include(), typeInfo.property().isEmpty() ? typeInfo.use().getDefaultPropertyName() : typeInfo.property(), Type.getSubtypeTypeMirrors(beanElement));
        }
        return subTypeInfo;
    }

    private static Map<String, TypeMirror> getSubtypeTypeMirrors(Element element) {
        List subTypes = element.getAnnotationMirrors().stream().filter(am -> am.getAnnotationType().asElement().getSimpleName().toString().equals("JsonSubTypes")).flatMap(am -> am.getElementValues().entrySet().stream()).filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals("value")).flatMap(entry -> ((List)((AnnotationValue)entry.getValue()).getValue()).stream()).collect(Collectors.toList());
        return subTypes.stream().collect(Collectors.toMap(am -> am.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals("name")).map(entry -> (String)((AnnotationValue)entry.getValue()).getValue()).findFirst().orElse(null), am -> am.getElementValues().entrySet().stream().filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals("value")).map(entry -> (TypeMirror)((AnnotationValue)entry.getValue()).getValue()).findFirst().orElse(null)));
    }

    public static TypeMirror getDeclaredType(TypeMirror type, final Map<? extends TypeParameterElement, ? extends TypeMirror> parametersToArgumentsMap) {
        return type.accept(new SimpleTypeVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType t, Void p) {
                return ObjectMapperProcessor.typeUtils.getDeclaredType((TypeElement)t.asElement(), (TypeMirror[])t.getTypeArguments().stream().map(arg -> (TypeMirror)this.visit((TypeMirror)arg, p)).toArray(TypeMirror[]::new));
            }

            @Override
            public TypeMirror visitTypeVariable(TypeVariable t, Void p) {
                return (TypeMirror)parametersToArgumentsMap.get(ObjectMapperProcessor.typeUtils.asElement(t));
            }

            @Override
            public TypeMirror visitPrimitive(PrimitiveType t, Void p) {
                return t;
            }

            @Override
            public TypeMirror visitArray(ArrayType t, Void p) {
                return ObjectMapperProcessor.typeUtils.getArrayType((TypeMirror)this.visit(t.getComponentType(), p));
            }

            @Override
            public TypeMirror visitWildcard(WildcardType t, Void p) {
                return ObjectMapperProcessor.typeUtils.getWildcardType(t.getExtendsBound() != null ? (TypeMirror)this.visit(t.getExtendsBound(), p) : null, t.getSuperBound() != null ? (TypeMirror)this.visit(t.getSuperBound(), p) : null);
            }
        }, null);
    }

    public static boolean hasUnboundedWildcards(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType t, Void p) {
                return t.getTypeArguments().stream().map(typeArg -> (Boolean)this.visit((TypeMirror)typeArg, p)).filter(b -> b).findFirst().orElse(false);
            }

            @Override
            public Boolean visitWildcard(WildcardType t, Void p) {
                return t.getExtendsBound() != null ? (Boolean)this.visit(t.getExtendsBound(), p) : (t.getSuperBound() != null ? (Boolean)this.visit(t.getSuperBound(), p) : Boolean.valueOf(true));
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Void p) {
                return false;
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Void p) {
                return false;
            }

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return (Boolean)this.visit(t.getComponentType(), p);
            }
        }, null);
    }

    public static boolean hasTypeArgumentWithBoundedWildcards(final TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<Boolean, Boolean>(){

            @Override
            public Boolean visitDeclared(DeclaredType t, Boolean p) {
                Boolean isCustomType = !Type.isCollection(t) && !Type.isIterable(t) && !Type.isMap(t) && !Type.isEnum(t);
                return t.getTypeArguments().stream().map(typeArg -> (Boolean)this.visit((TypeMirror)typeArg, p != false || isCustomType != false)).filter(b -> b).findFirst().orElse(false);
            }

            @Override
            public Boolean visitWildcard(WildcardType t, Boolean p) {
                return t.getExtendsBound() != null ? p.booleanValue() || ((Boolean)this.visit(t.getExtendsBound(), p)).booleanValue() : (t.getSuperBound() != null ? p.booleanValue() || !((Boolean)this.visit(t.getSuperBound(), p)).booleanValue() : false);
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Boolean p) {
                return false;
            }

            @Override
            public Boolean visitTypeVariable(TypeVariable t, Boolean p) {
                throw new RuntimeException("Unexpected type variable for:" + type);
            }

            @Override
            public Boolean visitArray(ArrayType t, Boolean p) {
                return (Boolean)this.visit(t.getComponentType(), p);
            }
        }, false);
    }

    public static boolean isJsonMapper(TypeMirror typeMirror) {
        return Objects.nonNull(ObjectMapperProcessor.typeUtils.asElement(typeMirror).getAnnotation(JSONMapper.class));
    }
}

