/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.client.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "yue" locale.
 */
public class DateTimeFormatInfoImpl_yue extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "上午",
        "下午"
    };
  }

  @Override
  public String dateFormatFull() {
    return "y年M月d日 EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "y年M月d日";
  }

  @Override
  public String dateFormatMedium() {
    return "y年M月d日";
  }

  @Override
  public String dateFormatShort() {
    return "y/M/d";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "西元前",
        "西元"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "西元前",
        "西元"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatDay() {
    return "d日";
  }

  @Override
  public String formatHour12Minute() {
    return "ah:mm";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "ah:mm:ss";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "M月d日";
  }

  @Override
  public String formatMonthFullDay() {
    return "M月d日";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "M月d日 EEEE";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYear() {
    return "y年";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y年M月";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y年M月d日";
  }

  @Override
  public String formatYearMonthFull() {
    return "y年M月";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y年M月d日";
  }

  @Override
  public String formatYearMonthNum() {
    return "y/M";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y/M/d";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y年M月d日 EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y年QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y年Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "1月",
        "2月",
        "3月",
        "4月",
        "5月",
        "6月",
        "7月",
        "8月",
        "9月",
        "10月",
        "11月",
        "12月"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "1月",
        "2月",
        "3月",
        "4月",
        "5月",
        "6月",
        "7月",
        "8月",
        "9月",
        "10月",
        "11月",
        "12月"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "第1季",
        "第2季",
        "第3季",
        "第4季"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "第1季",
        "第2季",
        "第3季",
        "第4季"
    };
  }

  @Override
  public String timeFormatFull() {
    return "ah:mm:ss [zzzz]";
  }

  @Override
  public String timeFormatLong() {
    return "ah:mm:ss [z]";
  }

  @Override
  public String timeFormatMedium() {
    return "ah:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "ah:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "星期日",
        "星期一",
        "星期二",
        "星期三",
        "星期四",
        "星期五",
        "星期六"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "日",
        "一",
        "二",
        "三",
        "四",
        "五",
        "六"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "星期日",
        "星期一",
        "星期二",
        "星期三",
        "星期四",
        "星期五",
        "星期六"
    };
  }
}
