/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "lt" locale.
 */
public class DateTimeFormatInfoImpl_lt extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "priešpiet",
        "popiet"
    };
  }

  @Override
  public String dateFormatFull() {
    return "y 'm'. MMMM d 'd'., EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "y 'm'. MMMM d 'd'.";
  }

  @Override
  public String dateFormatMedium() {
    return "y-MM-dd";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "prieš Kristų",
        "po Kristaus"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "pr. Kr.",
        "po Kr."
    };
  }

  @Override
  public String formatDay() {
    return "dd";
  }

  @Override
  public String formatHour12Minute() {
    return "hh:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "hh:mm:ss a";
  }

  @Override
  public String formatMonthAbbrev() {
    return "MM";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "MM-dd";
  }

  @Override
  public String formatMonthFullDay() {
    return "MMMM d 'd'.";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "MMMM d 'd'., EEEE";
  }

  @Override
  public String formatMonthNumDay() {
    return "MM-d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y-MM";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y-MM-dd";
  }

  @Override
  public String formatYearMonthFull() {
    return "y 'm'. LLLL";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y 'm'. MMMM d 'd'.";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y-MM-dd";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y-MM-dd, EEE";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "sausio",
        "vasario",
        "kovo",
        "balandžio",
        "gegužės",
        "birželio",
        "liepos",
        "rugpjūčio",
        "rugsėjo",
        "spalio",
        "lapkričio",
        "gruodžio"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "sausis",
        "vasaris",
        "kovas",
        "balandis",
        "gegužė",
        "birželis",
        "liepa",
        "rugpjūtis",
        "rugsėjis",
        "spalis",
        "lapkritis",
        "gruodis"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "S",
        "V",
        "K",
        "B",
        "G",
        "B",
        "L",
        "R",
        "R",
        "S",
        "L",
        "G"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "saus.",
        "vas.",
        "kov.",
        "bal.",
        "geg.",
        "birž.",
        "liep.",
        "rugp.",
        "rugs.",
        "spal.",
        "lapkr.",
        "gruod."
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "I ketvirtis",
        "II ketvirtis",
        "III ketvirtis",
        "IV ketvirtis"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "I k.",
        "II k.",
        "III k.",
        "IV k."
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "sekmadienis",
        "pirmadienis",
        "antradienis",
        "trečiadienis",
        "ketvirtadienis",
        "penktadienis",
        "šeštadienis"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "P",
        "A",
        "T",
        "K",
        "P",
        "Š"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "sk",
        "pr",
        "an",
        "tr",
        "kt",
        "pn",
        "št"
    };
  }
}
