/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "vo" locale.
 */
public class DateTimeFormatInfoImpl_vo extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "y MMMM'a' 'd'. d'id'";
  }

  @Override
  public String dateFormatMedium() {
    return "y MMM. d";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "b. t. kr.",
        "p. t. kr."
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "b. t. kr.",
        "p. t. kr."
    };
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "yanul",
        "febul",
        "mäzul",
        "prilul",
        "mayul",
        "yunul",
        "yulul",
        "gustul",
        "setul",
        "tobul",
        "novul",
        "dekul"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "Y",
        "F",
        "M",
        "P",
        "M",
        "Y",
        "Y",
        "G",
        "S",
        "T",
        "N",
        "D"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "yan",
        "feb",
        "mäz",
        "prl",
        "may",
        "yun",
        "yul",
        "gst",
        "set",
        "ton",
        "nov",
        "dek"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "yan",
        "feb",
        "mäz",
        "prl",
        "may",
        "yun",
        "yul",
        "gst",
        "set",
        "tob",
        "nov",
        "dek"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1id yelafoldil",
        "2id yelafoldil",
        "3id yelafoldil",
        "4id yelafoldil"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "Yf1",
        "Yf2",
        "Yf3",
        "Yf4"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "sudel",
        "mudel",
        "tudel",
        "vedel",
        "dödel",
        "fridel",
        "zädel"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "M",
        "T",
        "V",
        "D",
        "F",
        "Z"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "su.",
        "mu.",
        "tu.",
        "ve.",
        "dö.",
        "fr.",
        "zä."
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return new String[] {
        "Su",
        "Mu",
        "Tu",
        "Ve",
        "Dö",
        "Fr",
        "Zä"
    };
  }
}
