/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.client.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "yi" locale.
 */
public class DateTimeFormatInfoImpl_yi extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "פֿאַרמיטאָג",
        "נאָכמיטאָג"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, dטן MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "dטן MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "dטן MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "dd/MM/yy";
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + ", " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "BCE",
        "CE"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "BCE",
        "CE"
    };
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "dטן MMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "dטן MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d-M-y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, dטן MMM y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "יאַנואַר",
        "פֿעברואַר",
        "מערץ",
        "אַפּריל",
        "מיי",
        "יוני",
        "יולי",
        "אויגוסט",
        "סעפּטעמבער",
        "אקטאבער",
        "נאוועמבער",
        "דעצעמבער"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
        "10",
        "11",
        "12"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "יאַנואַר",
        "פֿעברואַר",
        "מערץ",
        "אַפּריל",
        "מיי",
        "יוני",
        "יולי",
        "אויגוסט",
        "סעפּטעמבער",
        "אקטאבער",
        "נאוועמבער",
        "דעצעמבער"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "יאַנ",
        "פֿעב",
        "מערץ",
        "אַפּר",
        "מיי",
        "יוני",
        "יולי",
        "אויג",
        "סעפּ",
        "אקט",
        "נאוו",
        "דעצ"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "Q1",
        "Q2",
        "Q3",
        "Q4"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "זונטיק",
        "מאָנטיק",
        "דינסטיק",
        "מיטוואך",
        "דאנערשטיק",
        "פֿרײַטיק",
        "שבת"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "זונטיק",
        "מאָנטיק",
        "דינסטיק",
        "מיטוואך",
        "דאנערשטיק",
        "פֿרײַטיק",
        "שבת"
    };
  }
}
