/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.client.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "kln" locale.
 */
public class LocalizedNamesImpl_kln extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "KE",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AQ",
        "AX",
        "BL",
        "BQ",
        "BV",
        "CC",
        "CP",
        "CW",
        "CX",
        "DG",
        "EA",
        "EH",
        "AF",
        "CF",
        "ZA",
        "AL",
        "DZ",
        "AS",
        "US",
        "AD",
        "AO",
        "AI",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "TD",
        "CL",
        "CN",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CI",
        "HR",
        "CU",
        "CY",
        "CZ",
        "DK",
        "DJ",
        "DM",
        "DO",
        "EC",
        "SV",
        "GQ",
        "ER",
        "EE",
        "ET",
        "FJ",
        "FI",
        "FR",
        "GA",
        "GM",
        "GE",
        "DE",
        "GH",
        "GI",
        "GR",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GF",
        "GN",
        "GW",
        "GY",
        "HT",
        "SH",
        "NL",
        "HN",
        "HU",
        "IS",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IL",
        "IT",
        "JM",
        "JP",
        "JO",
        "KZ",
        "KE",
        "AE",
        "GB",
        "KI",
        "KP",
        "KR",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LC",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "EG",
        "MD",
        "MC",
        "MN",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PM",
        "PH",
        "PN",
        "PL",
        "PF",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "KN",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SY",
        "TW",
        "TJ",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "VC",
        "WF",
        "YE",
        "ZM",
        "ZW",
        "EU",
        "EZ",
        "FO",
        "GG",
        "GS",
        "HK",
        "HM",
        "IC",
        "MP",
        "MH",
        "NF",
        "SB",
        "TC",
        "VG",
        "CV",
        "KY",
        "CK",
        "FK",
        "VI",
        "IM",
        "JE",
        "IO",
        "ME",
        "MF",
        "MO",
        "QO",
        "RS",
        "SJ",
        "SS",
        "SX",
        "TA",
        "TF",
        "UM",
        "UN",
        "XA",
        "XB",
        "XK",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AD", "Emetab Andorra");
    namesMap.put("AE", "Emetab kibagenge nebo arabuk");
    namesMap.put("AF", "Emetab Afghanistan");
    namesMap.put("AG", "Emetab Antigua ak Barbuda");
    namesMap.put("AI", "Emetab Anguilla");
    namesMap.put("AL", "Emetab Albania");
    namesMap.put("AM", "Emetab Armenia");
    namesMap.put("AO", "Emetab Angola");
    namesMap.put("AR", "Emetab Argentina");
    namesMap.put("AS", "Emetab American Samoa");
    namesMap.put("AT", "Emetab Austria");
    namesMap.put("AU", "Emetab Australia");
    namesMap.put("AW", "Emetab Aruba");
    namesMap.put("AZ", "Emetab Azerbaijan");
    namesMap.put("BA", "Emetab Bosnia ak Herzegovina");
    namesMap.put("BB", "Emetab Barbados");
    namesMap.put("BD", "Emetab Bangladesh");
    namesMap.put("BE", "Emetab Belgium");
    namesMap.put("BF", "Emetab Burkina Faso");
    namesMap.put("BG", "Emetab Bulgaria");
    namesMap.put("BH", "Emetab Bahrain");
    namesMap.put("BI", "Emetab Burundi");
    namesMap.put("BJ", "Emetab Benin");
    namesMap.put("BM", "Emetab Bermuda");
    namesMap.put("BN", "Emetab Brunei");
    namesMap.put("BO", "Emetab Bolivia");
    namesMap.put("BR", "Emetab Brazil");
    namesMap.put("BS", "Emetab Bahamas");
    namesMap.put("BT", "Emetab Bhutan");
    namesMap.put("BW", "Emetab Botswana");
    namesMap.put("BY", "Emetab Belarus");
    namesMap.put("BZ", "Emetab Belize");
    namesMap.put("CA", "Emetab Canada");
    namesMap.put("CD", "Emetab Congo - Kinshasa");
    namesMap.put("CF", "Emetab Afrika nebo Kwen");
    namesMap.put("CG", "Emetab Congo - Brazzaville");
    namesMap.put("CH", "Emetab Switzerland");
    namesMap.put("CI", "Emetab Côte d’Ivoire");
    namesMap.put("CK", "Ikwembeyotab Cook");
    namesMap.put("CL", "Emetab Chile");
    namesMap.put("CM", "Emetab Cameroon");
    namesMap.put("CN", "Emetab China");
    namesMap.put("CO", "Emetab Colombia");
    namesMap.put("CR", "Emetab Costa Rica");
    namesMap.put("CU", "Emetab Cuba");
    namesMap.put("CV", "Ikwembeyotab Cape Verde");
    namesMap.put("CY", "Emetab Cyprus");
    namesMap.put("CZ", "Emetab Czech Republic");
    namesMap.put("DE", "Emetab Geruman");
    namesMap.put("DJ", "Emetab Djibouti");
    namesMap.put("DK", "Emetab Denmark");
    namesMap.put("DM", "Emetab Dominica");
    namesMap.put("DO", "Emetab Dominican Republic");
    namesMap.put("DZ", "Emetab Algeria");
    namesMap.put("EC", "Emetab Ecuador");
    namesMap.put("EE", "Emetab Estonia");
    namesMap.put("EG", "Emetab Misiri");
    namesMap.put("ER", "Emetab Eritrea");
    namesMap.put("ES", "Emetab Spain");
    namesMap.put("ET", "Emetab Ethiopia");
    namesMap.put("FI", "Emetab Finland");
    namesMap.put("FJ", "Emetab Fiji");
    namesMap.put("FK", "Ikwembeyotab Falkland");
    namesMap.put("FM", "Emetab Micronesia");
    namesMap.put("FR", "Emetab France");
    namesMap.put("GA", "Emetab Gabon");
    namesMap.put("GB", "Emetab Kibagenge nebo Uingereza");
    namesMap.put("GD", "Emetab Grenada");
    namesMap.put("GE", "Emetab Georgia");
    namesMap.put("GF", "Emetab Guiana nebo Ufaransa");
    namesMap.put("GH", "Emetab Ghana");
    namesMap.put("GI", "Emetab Gibraltar");
    namesMap.put("GL", "Emetab Greenland");
    namesMap.put("GM", "Emetab Gambia");
    namesMap.put("GN", "Emetab Guinea");
    namesMap.put("GP", "Emetab Guadeloupe");
    namesMap.put("GQ", "Emetab Equatorial Guinea");
    namesMap.put("GR", "Emetab Greece");
    namesMap.put("GT", "Emetab Guatemala");
    namesMap.put("GU", "Emetab Guam");
    namesMap.put("GW", "Emetab Guinea-Bissau");
    namesMap.put("GY", "Emetab Guyana");
    namesMap.put("HN", "Emetab Honduras");
    namesMap.put("HR", "Emetab Croatia");
    namesMap.put("HT", "Emetab Haiti");
    namesMap.put("HU", "Emetab Hungary");
    namesMap.put("ID", "Emetab Indonesia");
    namesMap.put("IE", "Emetab Ireland");
    namesMap.put("IL", "Emetab Israel");
    namesMap.put("IN", "Emetab India");
    namesMap.put("IO", "Kebebertab araraitab indian Ocean nebo Uingeresa");
    namesMap.put("IQ", "Emetab Iraq");
    namesMap.put("IR", "Emetab Iran");
    namesMap.put("IS", "Emetab Iceland");
    namesMap.put("IT", "Emetab Italy");
    namesMap.put("JM", "Emetab Jamaica");
    namesMap.put("JO", "Emetab Jordan");
    namesMap.put("JP", "Emetab Japan");
    namesMap.put("KE", "Emetab Kenya");
    namesMap.put("KG", "Emetab Kyrgyzstan");
    namesMap.put("KH", "Emetab Cambodia");
    namesMap.put("KI", "Emetab Kiribati");
    namesMap.put("KM", "Emetab Comoros");
    namesMap.put("KN", "Emetab Saint Kitts ak Nevis");
    namesMap.put("KP", "Emetab Korea nebo murot katam");
    namesMap.put("KR", "Emetab korea nebo murot tai");
    namesMap.put("KW", "Emetab Kuwait");
    namesMap.put("KY", "Ikwembeyotab Cayman");
    namesMap.put("KZ", "Emetab Kazakhstan");
    namesMap.put("LA", "Emetab Laos");
    namesMap.put("LB", "Emetab Lebanon");
    namesMap.put("LC", "Emetab Lucia Ne");
    namesMap.put("LI", "Emetab Liechtenstein");
    namesMap.put("LK", "Emetab Sri Lanka");
    namesMap.put("LR", "Emetab Liberia");
    namesMap.put("LS", "Emetab Lesotho");
    namesMap.put("LT", "Emetab Lithuania");
    namesMap.put("LU", "Emetab Luxembourg");
    namesMap.put("LV", "Emetab Latvia");
    namesMap.put("LY", "Emetab Libya");
    namesMap.put("MA", "Emetab Morocco");
    namesMap.put("MC", "Emetab Monaco");
    namesMap.put("MD", "Emetab Moldova");
    namesMap.put("MG", "Emetab Madagascar");
    namesMap.put("MH", "Ikwembeiyotab Marshall");
    namesMap.put("MK", "Emetab Macedonia");
    namesMap.put("ML", "Emetab Mali");
    namesMap.put("MM", "Emetab Myanmar");
    namesMap.put("MN", "Emetab Mongolia");
    namesMap.put("MP", "Ikwembeiyotab Mariana nebo murot katam");
    namesMap.put("MQ", "Emetab Martinique");
    namesMap.put("MR", "Emetab Mauritania");
    namesMap.put("MS", "Emetab Montserrat");
    namesMap.put("MT", "Emetab Malta");
    namesMap.put("MU", "Emetab Mauritius");
    namesMap.put("MV", "Emetab Maldives");
    namesMap.put("MW", "Emetab Malawi");
    namesMap.put("MX", "Emetab Mexico");
    namesMap.put("MY", "Emetab Malaysia");
    namesMap.put("MZ", "Emetab Mozambique");
    namesMap.put("NA", "Emetab Namibia");
    namesMap.put("NC", "Emetab New Caledonia");
    namesMap.put("NE", "Emetab niger");
    namesMap.put("NF", "Ikwembeiyotab Norfork");
    namesMap.put("NG", "Emetab Nigeria");
    namesMap.put("NI", "Emetab Nicaragua");
    namesMap.put("NL", "Emetab Holand");
    namesMap.put("NO", "Emetab Norway");
    namesMap.put("NP", "Emetab Nepal");
    namesMap.put("NR", "Emetab Nauru");
    namesMap.put("NU", "Emetab Niue");
    namesMap.put("NZ", "Emetab New Zealand");
    namesMap.put("OM", "Emetab Oman");
    namesMap.put("PA", "Emetab Panama");
    namesMap.put("PE", "Emetab Peru");
    namesMap.put("PF", "Emetab Polynesia nebo ufaransa");
    namesMap.put("PG", "Emetab Papua New Guinea");
    namesMap.put("PH", "Emetab Philippines");
    namesMap.put("PK", "Emetab Pakistan");
    namesMap.put("PL", "Emetab Poland");
    namesMap.put("PM", "Emetab Peter Ne titil ak Miquelon");
    namesMap.put("PN", "Emetab Pitcairn");
    namesMap.put("PR", "Emetab Puerto Rico");
    namesMap.put("PS", "Emetab Palestine");
    namesMap.put("PT", "Emetab Portugal");
    namesMap.put("PW", "Emetab Palau");
    namesMap.put("PY", "Emetab Paraguay");
    namesMap.put("QA", "Emetab Qatar");
    namesMap.put("RE", "Emetab Réunion");
    namesMap.put("RO", "Emetab Romania");
    namesMap.put("RU", "Emetab Russia");
    namesMap.put("RW", "Emetab Rwanda");
    namesMap.put("SA", "Emetab Saudi Arabia");
    namesMap.put("SB", "Ikwembeiyotab Solomon");
    namesMap.put("SC", "Emetab Seychelles");
    namesMap.put("SD", "Emetab Sudan");
    namesMap.put("SE", "Emetab Sweden");
    namesMap.put("SG", "Emetab Singapore");
    namesMap.put("SH", "Emetab Helena Ne tilil");
    namesMap.put("SI", "Emetab Slovenia");
    namesMap.put("SK", "Emetab Slovakia");
    namesMap.put("SL", "Emetab Sierra Leone");
    namesMap.put("SM", "Emetab San Marino");
    namesMap.put("SN", "Emetab Senegal");
    namesMap.put("SO", "Emetab Somalia");
    namesMap.put("SR", "Emetab Suriname");
    namesMap.put("ST", "Emetab São Tomé and Príncipe");
    namesMap.put("SV", "Emetab El Salvador");
    namesMap.put("SY", "Emetab Syria");
    namesMap.put("SZ", "Emetab Swaziland");
    namesMap.put("TC", "Ikwembeiyotab Turks ak Caicos");
    namesMap.put("TD", "Emetab Chad");
    namesMap.put("TG", "Emetab Togo");
    namesMap.put("TH", "Emetab Thailand");
    namesMap.put("TJ", "Emetab Tajikistan");
    namesMap.put("TK", "Emetab Tokelau");
    namesMap.put("TL", "Emetab Timor nebo Murot tai");
    namesMap.put("TM", "Emetab Turkmenistan");
    namesMap.put("TN", "Emetab Tunisia");
    namesMap.put("TO", "Emetab Tonga");
    namesMap.put("TR", "Emetab Turkey");
    namesMap.put("TT", "Emetab Trinidad ak Tobago");
    namesMap.put("TV", "Emetab Tuvalu");
    namesMap.put("TW", "Emetab Taiwan");
    namesMap.put("TZ", "Emetab Tanzania");
    namesMap.put("UA", "Emetab Ukrainie");
    namesMap.put("UG", "Emetab Uganda");
    namesMap.put("US", "Emetab amerika");
    namesMap.put("UY", "Emetab Uruguay");
    namesMap.put("UZ", "Emetab Uzibekistani");
    namesMap.put("VA", "Emetab Vatican");
    namesMap.put("VC", "Emetab Vincent netilil ak Grenadines");
    namesMap.put("VE", "Emetab Venezuela");
    namesMap.put("VG", "Ikwembeyotab British Virgin");
    namesMap.put("VI", "Ikwemweiyotab Amerika");
    namesMap.put("VN", "Emetab Vietnam");
    namesMap.put("VU", "Emetab Vanuatu");
    namesMap.put("WF", "Emetab Walis ak Futuna");
    namesMap.put("WS", "Emetab Samoa");
    namesMap.put("YE", "Emetab Yemen");
    namesMap.put("YT", "Emetab Mayotte");
    namesMap.put("ZA", "Emetab Afrika nebo Murot tai");
    namesMap.put("ZM", "Emetab Zambia");
    namesMap.put("ZW", "Emetab Zimbabwe");
  }

}
