/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.dominokit.jacksonapt.processor.ObjectMapperProcessor;
import org.dominokit.jacksonapt.processor.SubTypesInfo;
import org.dominokit.jacksonapt.processor.Type;

public abstract class AbstractJsonMapperGenerator {
    protected final TypeMirror beanType;
    protected final SubTypesInfo subTypesInfo;
    protected final String packageName;
    private final Filer filer;

    public AbstractJsonMapperGenerator(String packageName, TypeMirror beanType, Filer filer) {
        this.beanType = beanType;
        this.subTypesInfo = Type.getSubTypes(beanType);
        this.packageName = packageName;
        this.filer = filer;
    }

    protected void generate() throws IOException {
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(Type.stringifyType(this.beanType) + this.namePostfix())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(this.superClass()).addMethod(constructor).addMethod(this.targetTypeMethod());
        this.moreMethods().forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
        MethodSpec initMethod = this.initMethod();
        if (Objects.nonNull(initMethod)) {
            builder.addMethod(initMethod);
        }
        if (this.subTypesInfo.hasSubTypes()) {
            builder.addMethod(this.buildInitTypeInfoMethod());
            builder.addMethod(this.initSubtypesMethod());
        }
        JavaFile.builder((String)this.packageName, (TypeSpec)builder.build()).build().writeTo(this.filer);
    }

    private MethodSpec targetTypeMethod() {
        return MethodSpec.methodBuilder((String)this.targetTypeMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get(Class.class)).addStatement("return $T.class", new Object[]{TypeName.get((TypeMirror)ObjectMapperProcessor.typeUtils.erasure(this.beanType))}).build();
    }

    protected abstract TypeName superClass();

    protected abstract String namePostfix();

    protected abstract String targetTypeMethodName();

    protected Set<MethodSpec> moreMethods() {
        return Collections.emptySet();
    }

    protected abstract MethodSpec initMethod();

    protected abstract MethodSpec initSubtypesMethod();

    protected Map<Element, TypeMirror> orderedFields() {
        return this.beanType.getKind() == TypeKind.DECLARED ? this.getOrderedFields((DeclaredType)this.beanType) : Collections.emptyMap();
    }

    private Map<Element, TypeMirror> getOrderedFields(DeclaredType enclosingType) {
        TypeElement enclosingElement = (TypeElement)enclosingType.asElement();
        TypeMirror superclass = enclosingElement.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return new HashMap<Element, TypeMirror>();
        }
        ArrayList orderedProperties = new ArrayList();
        List enclosedFields = enclosingElement.getEnclosedElements().stream().filter(e -> ElementKind.FIELD.equals((Object)e.getKind()) && this.isEligibleForSerializationDeserialization((Element)e)).collect(Collectors.toList());
        Optional.ofNullable(ObjectMapperProcessor.typeUtils.asElement(this.beanType).getAnnotation(JsonPropertyOrder.class)).ifPresent(jsonPropertyOrder -> {
            List<String> orderedFieldsNames = Arrays.asList(jsonPropertyOrder.value());
            orderedProperties.addAll(enclosedFields.stream().filter(f -> orderedFieldsNames.contains(f.getSimpleName().toString())).collect(Collectors.toList()));
            enclosedFields.removeAll(orderedProperties);
            if (jsonPropertyOrder.alphabetic()) {
                enclosedFields.sort(Comparator.comparing(f -> f.getSimpleName().toString()));
            }
            enclosedFields.addAll(0, orderedProperties);
        });
        List<? extends TypeParameterElement> typeParameters = enclosingElement.getTypeParameters();
        List<? extends TypeMirror> typeArguments = enclosingType.getTypeArguments();
        Map<TypeParameterElement, TypeMirror> typeParameterMap = IntStream.range(0, typeParameters.size()).boxed().collect(Collectors.toMap(i -> (TypeParameterElement)typeParameters.get((int)i), i -> (TypeMirror)typeArguments.get((int)i)));
        Map res = enclosedFields.stream().collect(Collectors.toMap(fieldElement -> fieldElement, fieldElement -> Type.getDeclaredType(fieldElement.asType(), typeParameterMap), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        String typeErrs = res.entrySet().stream().filter(entry -> Type.hasTypeArgumentWithBoundedWildcards((TypeMirror)entry.getValue()) || Type.hasUnboundedWildcards((TypeMirror)entry.getValue())).map(entry -> "Member '" + ((Element)entry.getKey()).getSimpleName() + "' resolved type: '" + entry.getValue() + "'").collect(Collectors.joining("\n"));
        if (!typeErrs.isEmpty()) {
            throw new RuntimeException("Type: '" + enclosingType + "' could not have generic member of type parametrized with type argument having unbounded wildcards or non-collections having type argument with bounded wildcards:\n" + typeErrs);
        }
        if (superclass.getKind() == TypeKind.DECLARED) {
            res.putAll(this.getOrderedFields((DeclaredType)Type.getDeclaredType(superclass, typeParameterMap)));
        }
        return res;
    }

    protected boolean isNotStatic(Element field) {
        return !field.getModifiers().contains((Object)Modifier.STATIC);
    }

    protected boolean isIgnored(Element field) {
        JsonIgnore annotation = field.getAnnotation(JsonIgnore.class);
        return Objects.nonNull(annotation) && annotation.value();
    }

    protected boolean isEligibleForSerializationDeserialization(Element field) {
        return this.isNotStatic(field) && !this.isIgnored(field);
    }

    protected abstract Class<?> getMapperType();

    protected final CodeBlock generateTypeInfo() {
        Class<?> type = this.getMapperType();
        CodeBlock.Builder builder = CodeBlock.builder().add("new $T($T.$L, $S)", new Object[]{type, JsonTypeInfo.As.class, this.subTypesInfo.getInclude(), this.subTypesInfo.getPropertyName()}).indent().indent();
        for (Map.Entry<String, TypeMirror> entry : this.subTypesInfo.getSubTypes().entrySet()) {
            builder.add("\n.addTypeInfo($T.class, $S)", new Object[]{entry.getValue(), entry.getKey()});
        }
        return builder.unindent().unindent().build();
    }

    private MethodSpec buildInitTypeInfoMethod() {
        Class<?> type = this.getMapperType();
        return MethodSpec.methodBuilder((String)"initTypeInfo").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(type), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.beanType)})).addStatement("return $L", new Object[]{this.generateTypeInfo()}).build();
    }

    public static class AccessorInfo {
        public boolean present;
        public String accessor;

        public AccessorInfo(boolean present, String accessor) {
            this.present = present;
            this.accessor = accessor;
        }
    }
}

