/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.jacksonapt.processor;

import com.squareup.javapoet.WildcardTypeName;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.dominokit.jacksonapt.annotation.JSONMapper;
import org.dominokit.jacksonapt.annotation.JSONReader;
import org.dominokit.jacksonapt.annotation.JSONWriter;
import org.dominokit.jacksonapt.processor.AbstractMapperProcessor;
import org.dominokit.jacksonapt.processor.BeanMapperGenerator;
import org.dominokit.jacksonapt.processor.BeanReaderGenerator;
import org.dominokit.jacksonapt.processor.BeanWriterGenerator;

public class ObjectMapperProcessor
extends AbstractMapperProcessor {
    public static final WildcardTypeName DEFAULT_WILDCARD = WildcardTypeName.subtypeOf(Object.class);

    @Override
    protected boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.mappers.forEach(this::generateMappers);
        this.readers.forEach(this::generateMapperForReader);
        this.writers.forEach(this::generateMapperForWriter);
        return false;
    }

    private void generateMappers(Element element) {
        try {
            new BeanMapperGenerator().generate(element);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private void generateMapperForReader(Element element) {
        try {
            new BeanReaderGenerator().generate(element);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private void generateMapperForWriter(Element element) {
        try {
            new BeanWriterGenerator().generate(element);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    @Override
    protected List<Class<?>> supportedAnnotations() {
        return Arrays.asList(JSONReader.class, JSONWriter.class, JSONMapper.class);
    }
}

