/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = 7373345728974414241L;
    private static final char[] CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private String value;

    private UUID() {
    }

    public static UUID fromString(String uuidString) {
        UUID uuid = new UUID();
        uuid.value = uuidString;
        return uuid;
    }

    public static UUID randomUUID() {
        return UUID.fromString(UUID.generateUUIDString());
    }

    private static String generateUUIDString() {
        char[] uuid = new char[36];
        uuid[23] = 45;
        uuid[18] = 45;
        uuid[13] = 45;
        uuid[8] = 45;
        uuid[14] = 52;
        for (int i = 0; i < 36; ++i) {
            if (uuid[i] != '\u0000') continue;
            int r = (int)(Math.random() * 16.0);
            uuid[i] = CHARS[i == 19 ? r & 3 | 8 : r & 0xF];
        }
        return new String(uuid);
    }

    @Override
    public int compareTo(UUID arg0) {
        return this.value.compareTo(arg0.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UUID other = (UUID)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value;
    }
}

