package org.dominokit.ui.tools.processor;

import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dominokit.jacksonapt.JacksonContextProvider;
import org.dominokit.jacksonapt.JsonDeserializationContext;
import org.dominokit.jacksonapt.JsonDeserializer;
import org.dominokit.jacksonapt.JsonDeserializerParameters;
import org.dominokit.jacksonapt.deser.BooleanJsonDeserializer;
import org.dominokit.jacksonapt.deser.StringJsonDeserializer;
import org.dominokit.jacksonapt.deser.bean.AbstractBeanJsonDeserializer;
import org.dominokit.jacksonapt.deser.bean.BeanPropertyDeserializer;
import org.dominokit.jacksonapt.deser.bean.HasDeserializerAndParameters;
import org.dominokit.jacksonapt.deser.bean.Instance;
import org.dominokit.jacksonapt.deser.bean.InstanceBuilder;
import org.dominokit.jacksonapt.deser.bean.MapLike;
import org.dominokit.jacksonapt.deser.collection.ListJsonDeserializer;
import org.dominokit.jacksonapt.stream.JsonReader;

public final class MetaIconInfoBeanJsonDeserializerImpl extends AbstractBeanJsonDeserializer<MetaIconInfo> {
  public MetaIconInfoBeanJsonDeserializerImpl() {
  }

  @Override
  public Class getDeserializedType() {
    return MetaIconInfo.class;
  }

  @Override
  protected InstanceBuilder<MetaIconInfo> initInstanceBuilder() {
    final MapLike<HasDeserializerAndParameters> deserializers = null;
    return new InstanceBuilder<MetaIconInfo>() {
      @Override
      public Instance<MetaIconInfo> newInstance(JsonReader reader, JsonDeserializationContext ctx,
          JsonDeserializerParameters params, Map<String, String> bufferedProperties,
          Map<String, Object> bufferedPropertiesValues) {
        return new Instance<MetaIconInfo>(create(), bufferedProperties);
      }

      @Override
      public MapLike<HasDeserializerAndParameters> getParametersDeserializer() {
        return deserializers;
      }

      private MetaIconInfo create() {
        return new MetaIconInfo();
      }
    };
  }

  @Override
  protected HashSet<String> initIgnoredProperties() {
    HashSet<String> col = new HashSet<String>(1);
    col.add("id");
    return col;
  }

  @Override
  protected MapLike<BeanPropertyDeserializer<MetaIconInfo, ?>> initDeserializers() {
    MapLike<BeanPropertyDeserializer<MetaIconInfo, ?>> map = JacksonContextProvider.get().mapLikeFactory().make();
    map.put("name", new BeanPropertyDeserializer<MetaIconInfo, String>() {
      @Override
      protected JsonDeserializer<?> newDeserializer() {
        return StringJsonDeserializer.getInstance();
      }

      @Override
      public void setValue(MetaIconInfo bean, String value, JsonDeserializationContext ctx) {
        bean.setName(value);
      }
    });
    map.put("codepoint", new BeanPropertyDeserializer<MetaIconInfo, String>() {
      @Override
      protected JsonDeserializer<?> newDeserializer() {
        return StringJsonDeserializer.getInstance();
      }

      @Override
      public void setValue(MetaIconInfo bean, String value, JsonDeserializationContext ctx) {
        bean.setCodepoint(value);
      }
    });
    map.put("aliases", new BeanPropertyDeserializer<MetaIconInfo, List<String>>() {
      @Override
      protected JsonDeserializer<?> newDeserializer() {
        return ListJsonDeserializer.newInstance(StringJsonDeserializer.getInstance());
      }

      @Override
      public void setValue(MetaIconInfo bean, List<String> value, JsonDeserializationContext ctx) {
        bean.setAliases(value);
      }
    });
    map.put("tags", new BeanPropertyDeserializer<MetaIconInfo, List<String>>() {
      @Override
      protected JsonDeserializer<?> newDeserializer() {
        return ListJsonDeserializer.newInstance(StringJsonDeserializer.getInstance());
      }

      @Override
      public void setValue(MetaIconInfo bean, List<String> value, JsonDeserializationContext ctx) {
        bean.setTags(value);
      }
    });
    map.put("author", new BeanPropertyDeserializer<MetaIconInfo, String>() {
      @Override
      protected JsonDeserializer<?> newDeserializer() {
        return StringJsonDeserializer.getInstance();
      }

      @Override
      public void setValue(MetaIconInfo bean, String value, JsonDeserializationContext ctx) {
        bean.setAuthor(value);
      }
    });
    map.put("version", new BeanPropertyDeserializer<MetaIconInfo, String>() {
      @Override
      protected JsonDeserializer<?> newDeserializer() {
        return StringJsonDeserializer.getInstance();
      }

      @Override
      public void setValue(MetaIconInfo bean, String value, JsonDeserializationContext ctx) {
        bean.setVersion(value);
      }
    });
    map.put("deprecated", new BeanPropertyDeserializer<MetaIconInfo, Boolean>() {
      @Override
      protected JsonDeserializer<?> newDeserializer() {
        return BooleanJsonDeserializer.getInstance();
      }

      @Override
      public void setValue(MetaIconInfo bean, Boolean value, JsonDeserializationContext ctx) {
        bean.setDeprecated(value);
      }
    });
    return map;
  }
}
